/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.wsfile;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.Utilities;
import com.iizix.gyro.IAppSessionDisposeListener;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.server.prop.ServerSettings;
import com.iizix.server.wsfile.WSFileDownload;
import com.iizix.server.wsfile.b;
import com.iizix.server.wsfile.c;
import com.iizix.urn.URNLocation;
import com.iizix.urn.URNResourceType;
import com.iizix.wsfile.IWSFile;
import com.iizix.wsfile.IWSFileDownload;
import com.iizix.wsfile.IWSFileProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WSFileProvider
implements IWSFileProvider {
    private final File a;
    private final Path a;
    private final String a;
    private final URNResourceType a;
    private String b;
    private final String c;
    private final b a;
    private final HashMap<String, IWSFile> a = new HashMap();
    private final HashMap<String, IWSFile> b;
    private final HashMap<String, IWSFile> c;
    private final boolean b = new HashMap();
    private boolean c = new HashMap();

    private static String a() {
        return UUID.randomUUID().toString();
    }

    WSFileProvider(File file, String string, URNResourceType uRNResourceType, String string2, String string3, boolean bl, ServerSettings serverSettings) throws IOException {
        try {
            this.a = file.toPath();
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("Invalid root path \"" + String.valueOf(file) + "\": " + invalidPathException.getMessage());
        }
        b b2 = null;
        String string4 = "";
        if (uRNResourceType.storageLocation == URNLocation.DATABASE) {
            b2 = new b(uRNResourceType, file, serverSettings);
            string4 = ", using database backing storage";
        }
        this.a = file;
        this.a = string;
        this.a = uRNResourceType;
        this.c = string2;
        this.b = string3;
        this.b = bl;
        this.a = b2;
        if (!file.isDirectory()) {
            Files.createDirectories(this.a, new FileAttribute[0]);
        }
        String string5 = "Created web server file provider " + String.valueOf(uRNResourceType);
        if (uRNResourceType.isSubjectBased && string3 != null) {
            string5 = string5 + ", subject = \"" + string3 + "\"";
        }
        string5 = string5 + ", description = \"" + string2 + "\", in \"" + String.valueOf(file) + "\", URL path = \"" + string + "\"";
        string5 = string5 + string4;
        Throwable throwable = null;
        Object var12_14 = null;
        try (FileWriter fileWriter = new FileWriter(new File(file, "_contents_"));){
            fileWriter.write(Utilities.formatCurrentDate() + "  " + string5);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ILog.INFO(this.getClass(), (String)string5);
    }

    public URNResourceType getType() {
        return this.a;
    }

    public File getRoot() throws IOException {
        if (this.c) {
            throw new IOException("File provider " + String.valueOf(this.a) + " is disposed");
        }
        if (!this.a.isDirectory()) {
            Files.createDirectories(this.a, new FileAttribute[0]);
        }
        return this.a;
    }

    public boolean isDisposed() {
        return this.c;
    }

    public boolean deleteAllFiles(Map<File, IOException> map) throws IOException {
        return this.deleteAllFiles(map, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAllFiles(Map<File, IOException> map, boolean bl) throws IOException {
        WSFileProvider wSFileProvider = this;
        synchronized (wSFileProvider) {
            ((HashMap)((Object)this.a)).clear();
            ((HashMap)((Object)this.b)).clear();
        }
        if (map == null && bl) {
            map = new LinkedHashMap<File, IOException>();
        }
        boolean bl2 = Utilities.deleteDirectoryRecursive((Path)this.a, map);
        if (bl && map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("Failed deleting contents for file provider ").append(this.a.toString()).append(' ').append(this.c);
            if (this.b != null) {
                stringBuilder.append(" with subject ").append(this.b);
            }
            stringBuilder.append(" in directory ").append(this.a.getAbsolutePath()).append(':');
            for (Map.Entry<File, IOException> entry : map.entrySet()) {
                stringBuilder.append("\n - ").append(entry.getKey().getAbsolutePath()).append(": ").append(entry.getValue().getMessage());
            }
            ILog.SEVERE(this.getClass(), (String)stringBuilder.toString());
        }
        return bl2;
    }

    public void disposeNoThrow(boolean bl) {
        try {
            this.dispose(bl, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose(boolean bl, boolean bl2) throws IOException {
        if (this.c) {
            return;
        }
        Object object = this;
        synchronized (object) {
            if (this.c) {
                return;
            }
            this.c = true;
        }
        object = null;
        if (bl) {
            try {
                LinkedHashMap<File, IOException> linkedHashMap = bl2 ? new LinkedHashMap<File, IOException>() : null;
                this.deleteAllFiles(linkedHashMap, true);
            }
            catch (IOException iOException) {
                object = iOException;
            }
        }
        if (this.a != null) {
            try {
                this.a.a(true);
            }
            catch (SQLException sQLException) {
                if (object == null) {
                    object = new IOException("Failure disposing of database backup", sQLException);
                }
                ((Throwable)object).addSuppressed(sQLException);
            }
        }
        if (object != null) {
            throw object;
        }
    }

    public IWSFileDownload createDownloadInstance(URL uRL, Object object, String string) {
        if (this.a.idClass != null) {
            Class<?> clazz = object.getClass();
            if (!clazz.equals(this.a.idClass)) {
                throw new IllegalArgumentException("id class must be " + this.a.idClass.getCanonicalName() + " but is " + clazz.getCanonicalName());
            }
        } else {
            object = null;
        }
        return new WSFileDownload(uRL, object, string);
    }

    public void downloadFiles(IAppSessionGyro iAppSessionGyro2, IWSFileDownload[] iWSFileDownloadArray, Runnable runnable) {
        IAppSessionDisposeListener iAppSessionDisposeListener = null;
        if (iAppSessionGyro2 != null) {
            iAppSessionDisposeListener = iAppSessionGyro -> {
                IWSFileDownload[] iWSFileDownloadArray2 = iWSFileDownloadArray;
                int n = iWSFileDownloadArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWSFileDownload iWSFileDownload = iWSFileDownloadArray2[n2];
                    iWSFileDownload.dispose();
                    ++n2;
                }
            };
            iAppSessionGyro2.addDisposeListener(iAppSessionDisposeListener);
        }
        IAppSessionDisposeListener iAppSessionDisposeListener2 = null;
        int[] nArray = new int[1];
        Runnable runnable2 = () -> {
            int[] nArray2 = nArray;
            synchronized (nArray) {
                nArray[0] = nArray[0] + 1;
                if (nArray[0] < iWSFileDownloadArray.length) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                if (iAppSessionGyro2 != null) {
                    iAppSessionGyro2.removeDisposeListener(iAppSessionDisposeListener2);
                }
                runnable.run();
                return;
            }
        };
        IWSFileDownload[] iWSFileDownloadArray2 = iWSFileDownloadArray;
        int n = iWSFileDownloadArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWSFileDownload iWSFileDownload = iWSFileDownloadArray2[n2];
            ((WSFileDownload)iWSFileDownload).a(iAppSessionGyro2, this.a, this.a, runnable2);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWSFile reserveFile(File file, String string, Object object) throws NotFoundException, IllegalArgumentException, IOException {
        Class<?> clazz;
        if (this.a.idClass != null) {
            clazz = object.getClass();
            if (!clazz.equals(this.a.idClass)) {
                throw new IllegalArgumentException("id class must be " + this.a.idClass.getCanonicalName() + " but is " + clazz.getCanonicalName());
            }
        } else {
            object = null;
        }
        try {
            file = file.getCanonicalFile();
            if (!file.isFile()) {
                throw new NotFoundException("File " + file.getAbsolutePath() + " is not found");
            }
        }
        catch (IOException iOException) {
            throw new NotFoundException("File " + file.getAbsolutePath() + " is not found", (Throwable)iOException);
        }
        if (!this.a.equals(file.getParentFile())) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " is not a child of " + this.a.getAbsolutePath());
        }
        clazz = this;
        synchronized (clazz) {
            String string2 = file.getName();
            IWSFile iWSFile = (IWSFile)((HashMap)((Object)this.b)).get(string2);
            if (iWSFile == null) {
                Object object2;
                Object object3 = object2 = this.b ? string2 : WSFileProvider.a();
                if (!((HashMap)((Object)this.a)).containsKey(object2)) {
                    int n;
                    if (!this.b && (n = string2.lastIndexOf(46)) >= 0) {
                        object2 = (String)object2 + string2.substring(n);
                    }
                    String string3 = Utilities.encodeURIComponent((String)object2);
                    iWSFile = new c(this, file, string3, string, object);
                    if (this.a != null) {
                        try {
                            this.a.a(object, file, string, true);
                        }
                        catch (SQLException sQLException) {
                            throw new IOException("Failed database operation for backuped file \"" + string2 + "\" in WSFileProvider " + String.valueOf(this), sQLException);
                        }
                        ((HashMap)((Object)this.a)).put(string3, iWSFile);
                        ((HashMap)((Object)this.b)).put(string2, iWSFile);
                    }
                }
            }
            return iWSFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean a(IWSFile iWSFile) throws IOException {
        IWSFile iWSFile2;
        String string = this.c;
        synchronized (string) {
            iWSFile2 = ((HashMap)((Object)this.c)).putIfAbsent(iWSFile.getURLName(), iWSFile);
        }
        if (iWSFile2 == iWSFile) {
            return false;
        }
        if (iWSFile2 != null) {
            throw new IOException("File already published with another instance: " + String.valueOf(iWSFile2));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean b(IWSFile iWSFile) {
        String string = this.c;
        synchronized (string) {
            IWSFile iWSFile2 = (IWSFile)((HashMap)((Object)this.c)).remove(iWSFile.getURLName());
            assert (iWSFile2 == null || iWSFile2 == iWSFile) : "Not same published file";
            return iWSFile2 != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean c(IWSFile iWSFile) throws IOException {
        boolean bl = false;
        String string = iWSFile.getFileName();
        Object object = this;
        synchronized (object) {
            if (((HashMap)((Object)this.a)).remove(iWSFile.getURLName()) != null) {
                bl = true;
            }
            if (((HashMap)((Object)this.b)).remove(string) != null) {
                bl = true;
            }
        }
        object = iWSFile.getID();
        if (object != null && this.a != null) {
            try {
                if (this.a.a(object, string)) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                throw new IOException("Failed deleting file \"" + string + "\" in database", sQLException);
            }
        }
        return bl;
    }

    public String getURLPath() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWSFile getFileFromFileName(String string) {
        WSFileProvider wSFileProvider = this;
        synchronized (wSFileProvider) {
            return (IWSFile)((HashMap)((Object)this.b)).get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File a(String string) {
        IWSFile iWSFile;
        File file = this.a;
        synchronized (file) {
            iWSFile = (IWSFile)((HashMap)((Object)this.c)).get(string);
        }
        return iWSFile != null ? iWSFile.getPublishedFile() : null;
    }

    public String toString() {
        return this.getClass().getName() + "[type=" + String.valueOf(this.a) + ",descr=" + this.c + ",root=" + String.valueOf(this.a) + ",path=" + this.a + ",subject=" + this.b + "]";
    }
}

