/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.weblogos;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.Utilities;
import com.iizix.server.IServerDisposeListener;
import com.iizix.server.ServerShell;
import com.iizix.server.weblogos.WebLogo;
import com.iizix.server.weblogos.a;
import com.iizix.server.wsfile.WSFileProvider;
import com.iizix.server.wsfile.WSFileProviderEngine;
import com.iizix.urn.URNResourceType;
import com.iizix.wsfile.IWSFile;
import jakarta.mail.internet.InternetAddress;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WebLogos {
    public static final boolean DEBUG = false;
    public static final String[] FILE_EXTS = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp"};
    private static final String[] a = new String[FILE_EXTS.length];
    private final ThreadPoolExecutor a;
    final WSFileProvider a;
    private final File a;
    private boolean a;
    private HashMap<String, WebLogo> a;
    private final ServerShell a;
    private final IServerDisposeListener a = new a(this);

    static {
        int n = FILE_EXTS.length;
        while (--n >= 0) {
            WebLogos.a[n] = "-logo" + FILE_EXTS[n];
        }
    }

    public static String siteToFileName(String string, int n, int n2, int n3) {
        if (n < 10 || n > 1000) {
            throw new IllegalArgumentException("width (10-1000) invalid: " + n);
        }
        if (n2 < 10 || n2 > 1000) {
            throw new IllegalArgumentException("height (10-1000) invalid: " + n2);
        }
        if (n3 < 0 || n3 > 100) {
            throw new IllegalArgumentException("quality (0-100) invalid: " + n3);
        }
        StringBuilder stringBuilder = new StringBuilder("website-").append(string.toLowerCase()).append("-logo-").append(n).append('x').append(n2);
        if (n3 == 0) {
            stringBuilder.append(".png");
        } else {
            stringBuilder.append('-').append(n3).append(".jpg");
        }
        return stringBuilder.toString();
    }

    public static File siteToFileName(File file, String string) {
        String string2 = "website-" + string.toLowerCase() + "-logo";
        File file2 = null;
        long l = -1L;
        String[] stringArray = FILE_EXTS;
        int n = FILE_EXTS.length;
        int n2 = 0;
        while (n2 < n) {
            long l2;
            String string3 = stringArray[n2];
            File file3 = new File(file, string2 + string3);
            if (file3.isFile() && file3.length() > 0L && (l2 = file3.lastModified()) > l) {
                l = l2;
                file2 = file3;
            }
            ++n2;
        }
        return file2 != null ? Utilities.getCanonicalFile(file2) : null;
    }

    public static String siteToFileName(String string) {
        return "website-" + string.toLowerCase() + "-logo.png";
    }

    public static String fileNameToSite(String string) {
        int n = string.length();
        if (n < 20 || !string.startsWith("website-")) {
            return null;
        }
        String[] stringArray = a;
        int n2 = a.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (string.endsWith(string2)) {
                String string3 = string.substring(8, n - string2.length());
                return string3.isEmpty() ? null : string3;
            }
            ++n3;
        }
        return null;
    }

    public static String urlToSite(URL uRL) throws MalformedURLException {
        return WebLogos.stringToSite(uRL.toExternalForm());
    }

    public static String urlToSite(InternetAddress internetAddress) throws MalformedURLException {
        return WebLogos.stringToSite(internetAddress.getAddress());
    }

    public static String stringToSite(String string) throws MalformedURLException {
        String string2 = string;
        int n = (string = string.trim()).indexOf("//");
        if (n >= 0) {
            string = string.substring(n + 2);
        }
        if ((n = string.indexOf(64)) >= 0) {
            if ((n = (string = string.substring(n + 1)).indexOf(62)) >= 0) {
                string = string.substring(0, n).trim();
            }
        } else {
            n = string.indexOf(58);
            if (n >= 0) {
                string = string.substring(0, n);
            }
        }
        if ((n = string.indexOf(47)) >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(63)) >= 0) {
            string = string.substring(0, n);
        }
        if ((string = string.trim().toLowerCase()).isEmpty() || string.indexOf(46) < 0) {
            throw new MalformedURLException("Invalid site (" + string + ") for logos: " + string2);
        }
        try {
            new URI("http://" + string).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new MalformedURLException("Invalid Website URL \"http[s]://" + string + "\" for logos: " + exception.getMessage());
        }
        return string;
    }

    public WebLogos(ServerShell serverShell) throws IOException {
        if (!serverShell.addDisposeListener(this.a)) {
            throw new IllegalStateException("WebLogos must be created from the Server instance and not directly");
        }
        this.a = serverShell;
        WSFileProviderEngine wSFileProviderEngine = serverShell.getFileProviderEngine();
        this.a = wSFileProviderEngine.getCreateFileProvider(URNResourceType.COMMON_PERSISTENT, "WebLogos", "weblogos", null, true, serverShell.getServerSettings());
        this.a = this.a.getRoot();
        ILog.INFO(this.getClass(), (String)("Website logo images are loaded from " + this.a.getPath()));
        this.a = new ThreadPoolExecutor(10, 10, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.a();
    }

    public WSFileProvider getFileProvider() {
        return this.a;
    }

    private void a() {
        int n = 0;
        File[] fileArray = this.a.listFiles();
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                block8: {
                    String string;
                    String string2;
                    File file = fileArray2[n3];
                    if (file.isFile() && file.length() > 0L && (string2 = WebLogos.fileNameToSite(string = file.getName())) != null && string.equals(WebLogos.siteToFileName(string2)) && !this.a.containsKey(string2)) {
                        try {
                            file = Utilities.getCanonicalFile((File)file);
                            string = file.getName();
                            IWSFile iWSFile = this.a.getFileFromFileName(string);
                            if (iWSFile == null) {
                                try {
                                    iWSFile = this.a.reserveFile(file, string2, null);
                                }
                                catch (NotFoundException notFoundException) {
                                    break block8;
                                }
                            }
                            WebLogo webLogo = new WebLogo(string2, file, iWSFile);
                            this.a.put(string2, webLogo);
                            ++n;
                        }
                        catch (Throwable throwable) {
                            ILog.SEVERE(this.getClass(), (String)"This should not be happening!", (Throwable)throwable);
                        }
                    }
                }
                ++n3;
            }
        }
        ILog.INFO(this.getClass(), (String)("Loaded " + n + " Website logos"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebLogo requestWebLogo(String string) throws MalformedURLException, IllegalStateException {
        String[] stringArray = this.a;
        synchronized (this.a) {
            WebLogo webLogo;
            block15: {
                if (this.a) {
                    throw new IllegalStateException("WebLogos instance is disposed of");
                }
                webLogo = (WebLogo)this.a.get(string = WebLogos.stringToSite(string));
                if (webLogo == null) {
                    boolean bl = false;
                    IWSFile iWSFile = null;
                    String string2 = WebLogos.siteToFileName(string);
                    File file = Utilities.getCanonicalFile((File)new File(this.a, string2));
                    if (file.isFile() && file.length() > 0L) {
                        try {
                            iWSFile = this.a.getFileFromFileName(string2);
                            if (iWSFile == null) {
                                try {
                                    iWSFile = this.a.reserveFile(file, string, null);
                                }
                                catch (NotFoundException notFoundException) {}
                            }
                        }
                        catch (Throwable throwable) {
                            ILog.SEVERE(this.getClass(), (String)"This should not be happening!", (Throwable)throwable);
                        }
                        bl = iWSFile != null;
                    }
                    webLogo = new WebLogo(string, file, iWSFile);
                    this.a.put(string, webLogo);
                    if (!bl) {
                        try {
                            Runnable runnable = webLogo.a(this.a, this.a);
                            if (runnable != null) {
                                this.a.execute(runnable);
                            }
                        }
                        catch (Throwable throwable) {
                            if (this.a) break block15;
                            ILog.SEVERE(this.getClass(), (String)("Failed loading the logo for the Website " + string), (Throwable)throwable);
                        }
                    }
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return webLogo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(ServerShell serverShell) {
        WebLogo[] webLogoArray = this;
        synchronized (this) {
            if (this.a) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.a = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.a.purge();
            this.a.shutdownNow();
            serverShell.removeDisposeListener(this.a);
            Object object = this.a;
            synchronized (this.a) {
                webLogoArray = this.a.values().toArray(new WebLogo[this.a.size()]);
                this.a.clear();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                WebLogo[] webLogoArray2 = webLogoArray;
                int n = webLogoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = webLogoArray2[n2];
                    ((WebLogo)object).a();
                    ++n2;
                }
                return;
            }
        }
    }
}

