/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.oauth.services;

import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.iizix.ILog;
import com.iizix.Size;
import com.iizix.comm.oauth.AuthenticationProvider;
import com.iizix.image.ImageType;
import com.iizix.server.oauth.AbstractOAuthService;
import com.iizix.server.oauth.OAuthSession;
import com.iizix.server.oauth.services.IServiceCreator;
import com.iizix.user.ProfilePictureInfo;
import com.iizix.user.UserProfileInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Twitter
extends AbstractOAuthService {
    public static IServiceCreator<Twitter> initialize(String string, String string2) {
        Twitter.validate(string, string2, null);
        return oAuthSession -> new Twitter(oAuthSession, string, string2);
    }

    public Twitter(OAuthSession oAuthSession, String string, String string2) {
        super(oAuthSession, Twitter.createServiceBuilder(string, string2).apiSecret(string2).callback(oAuthSession.getCallbackURL()).build((DefaultApi10a)TwitterApi.instance()));
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return AuthenticationProvider.Twitter;
    }

    public Size getApproximateSize() {
        return new Size(750, 550);
    }

    @Override
    public String getLogoutURL() {
        return null;
    }

    @Override
    public UserProfileInfo getUserProfileInfo() throws IOException, InterruptedException, ExecutionException {
        OAuth1AccessToken oAuth1AccessToken = this.getAccessToken1();
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, "https://api.twitter.com/1.1/account/verify_credentials.json?include_email=true&skip_status=true&include_entities=false");
        this.service1.signRequest(oAuth1AccessToken, oAuthRequest);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Response response = this.service1.execute(oAuthRequest);){
            int n = response.getCode();
            if (n != 200) {
                String string = "Failed retrieving profile, HTTP response " + n + ": " + response.getMessage();
                ILog.WARNING(this.getClass(), (String)string);
                throw new IOException(string);
            }
            String string = response.getBody();
            UserProfileInfo userProfileInfo = this.a(string);
            if (userProfileInfo != null) {
                return userProfileInfo;
            }
            throw new IOException("Failed parsing body JSON response: " + string);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private UserProfileInfo a(String string) {
        JSONObject jSONObject = new JSONObject(new JSONTokener(string));
        System.out.println("JSON body profile response:\n" + jSONObject.toString(2));
        try {
            ImageType imageType;
            int n;
            int n2;
            String string2;
            String string3 = jSONObject.getString("id_str");
            String string4 = null;
            String string5 = jSONObject.optString("name");
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = jSONObject.optString("email", null);
            boolean bl = string9 != null && jSONObject.optBoolean("verified");
            String string10 = null;
            String string11 = null;
            ProfilePictureInfo[] profilePictureInfoArray = null;
            if (!jSONObject.optBoolean("default_profile_image") && (string2 = jSONObject.optString("profile_image_url_https")) != null && (n2 = string2.lastIndexOf(46)) > 0 && (n = string2.lastIndexOf(47)) > 0 && n2 > n + 1 && (imageType = ImageType.fromExtension((String)string2.substring(n2 + 1))) != null && imageType.isValidExtension) {
                try {
                    ProfilePictureInfo profilePictureInfo = new ProfilePictureInfo(string2, imageType.mediaType);
                    int n3 = string2.lastIndexOf("_normal.");
                    profilePictureInfoArray = n3 + 7 == n2 ? new ProfilePictureInfo[]{profilePictureInfo, new ProfilePictureInfo(string2.substring(0, n3) + string2.substring(n2), imageType.mediaType)} : new ProfilePictureInfo[]{profilePictureInfo};
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    ILog.WARNING(this.getClass(), (String)("Profile image URL error: " + string2), (Throwable)exception);
                }
            }
            return new UserProfileInfo(string3, string4, string5, string6, string7, string8, string9, Boolean.valueOf(bl), string10, string11, profilePictureInfoArray);
        }
        catch (JSONException jSONException) {
            ILog.SEVERE(this.getClass(), (String)("Failed parsing profile response from JSON body: " + jSONException.getMessage() + "\n" + jSONObject.toString(2)));
            return null;
        }
    }
}

