/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.SessionInfo;
import com.iizix.Utilities;
import com.iizix.Worker;
import com.iizix.WorkerTask;
import com.iizix.WriteCache;
import com.iizix.comm.IServerWebSocketCommListener;
import com.iizix.nio.DataPacket;
import com.iizix.nio.IWebSocketComm;
import com.iizix.nio.IWorkerTimeout;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.ui.UIContextMenu;
import com.iizix.server.IEndPoint;
import com.iizix.server.ServerShell;
import com.iizix.server.WorkerThread;
import com.iizix.server.a;
import com.iizix.server.c;
import com.iizix.server.d;
import com.iizix.server.prop.IRootPropTransactionSender;
import com.iizix.server.prop.RootPropTransactionSender;
import com.iizix.virtual.ThreadGroupType;
import com.iizix.virtual.VirtualThreadGroup;
import java.io.IOException;
import java.util.HashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class AbstractEndPoint
implements IServerWebSocketCommListener,
IEndPoint,
IRootPropTransactionSender {
    protected boolean DEBUG = false;
    private final WorkerThread a;
    protected final long serverSessionID;
    protected final String name;
    protected final Worker worker;
    protected final ServerShell server;
    protected final SessionInfo sessionInfo;
    protected final VirtualThreadGroup threadGroup;
    protected final IEndPoint.Type endPointType;
    protected final PropMgr endPointPropertyManager;
    protected PropCnr root;
    protected RootPropTransactionSender propTransSender;
    private IWebSocketComm a;
    private boolean a;
    private final HashMap<Integer, String> a;
    private final WriteCache a;
    private final DataPacket a;
    private long a;
    private final IWorkerTimeout a;
    private SendTransaction a = new a(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEndPoint(IEndPoint.Type type, String string, long l, IWebSocketComm iWebSocketComm, ServerShell serverShell, HashMap<String, String> hashMap, ClassLoader classLoader) throws IOException {
        this.serverSessionID = l;
        this.endPointType = type;
        this.name = string;
        this.a = iWebSocketComm;
        this.server = serverShell;
        this.sessionInfo = new SessionInfo(l, iWebSocketComm.getSocketAddress(), iWebSocketComm.getRemoteHost());
        this.sessionInfo.setPrivateData(STORAGE_NAME, (Object)this);
        this.worker = new Worker(this.sessionInfo);
        this.sessionInfo.setWorker(this.worker);
        this.a = new WorkerThread(this.worker, () -> {
            boolean bl = this.dispose();
        });
        this.threadGroup = new VirtualThreadGroup(ThreadGroupType.SERVER_END_POINT, string, this.sessionInfo, classLoader);
        this.threadGroup.startThread((Runnable)this.a, "<worker>", 6);
        WorkerThread workerThread = this.a;
        synchronized (workerThread) {
            try {
                this.a.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long l2 = this.getHeartBeatInterval();
        if (l2 > 0L) {
            this.worker.registerTimeoutHandler(this.a);
        }
        this.endPointPropertyManager = serverShell.getPropertyFactory().createPropertyManager(1, hashMap);
        int[] nArray = serverShell.getServerProperties().getServerSettings().getCacheParams();
        this.a = new WriteCache(nArray[2], nArray[0], nArray[1]);
    }

    public final IEndPoint getEndPoint() {
        return this;
    }

    @Override
    public final long getServerSessionID() {
        return this.serverSessionID;
    }

    @Override
    public final ServerShell getServer() {
        return this.server;
    }

    @Override
    public IServerWebSocketCommListener getWebSocketCommListener(IWebSocketComm iWebSocketComm) {
        return this;
    }

    @Override
    public final IEndPoint.Type getEndPointType() {
        return this.endPointType;
    }

    @Override
    public String getEndPointName() {
        return this.name;
    }

    protected long getHeartBeatInterval() {
        return 15000L;
    }

    protected void onSendHeartHeat() {
        block4: {
            try {
                IWebSocketComm iWebSocketComm = this.a;
                if (iWebSocketComm != null) {
                    if (this.DEBUG) {
                        System.err.println("onSendHeartHeat @" + Utilities.formatCurrentDate());
                    }
                    iWebSocketComm.sendHeartBeat();
                    this.a = System.currentTimeMillis();
                }
            }
            catch (IOException iOException) {
                if (this.a.isClosed()) break block4;
                ILog.WARNING(this.getClass(), (String)("Failed sending heart-beat: " + iOException.getMessage()));
            }
        }
    }

    protected void onSessionConnected() {
    }

    public final PropMgr getPropertyManager() {
        return this.endPointPropertyManager;
    }

    public final PropCnr getProperties() {
        return this.root;
    }

    @Override
    public final SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispose() {
        IWebSocketComm iWebSocketComm;
        Worker worker;
        AbstractEndPoint abstractEndPoint = this;
        synchronized (abstractEndPoint) {
            block9: {
                if (!this.a) break block9;
                return false;
            }
            this.a = true;
        }
        if (this.DEBUG) {
            System.err.println("dispose @" + Utilities.formatCurrentDate());
        }
        if ((abstractEndPoint = this.root) != null) {
            abstractEndPoint.dispose();
        }
        if ((worker = this.worker) != null) {
            worker.dispose();
        }
        if ((iWebSocketComm = this.a) != null) {
            iWebSocketComm.close(true);
        }
        if (this.a != null) {
            this.a.awaitExit();
        }
        this.server.onEndPointDisposed(this);
        return true;
    }

    public void onCommOpen(IWebSocketComm iWebSocketComm) {
        if (this.a != iWebSocketComm) {
            boolean bl;
            if (this.DEBUG) {
                System.err.println("onCommOpen @" + Utilities.formatCurrentDate());
            }
            String string = (bl = iWebSocketComm.isSecure()) ? " (secured)" : "";
            ILog.INFO(this.getClass(), (String)("Communication link open with " + iWebSocketComm.getRemoteHost() + " / " + iWebSocketComm.getRemoteAddr() + string));
            this.a = iWebSocketComm;
            this.sessionInfo.assignRemoteAddress(iWebSocketComm.getSocketAddress(), iWebSocketComm.getRemoteHost(), iWebSocketComm.getDomain(), iWebSocketComm.getPort(), bl);
        }
    }

    public void onCommConnected(IWebSocketComm iWebSocketComm) {
        boolean bl;
        if (this.DEBUG) {
            System.err.println("onCommConnected @" + Utilities.formatCurrentDate());
        }
        String string = (bl = iWebSocketComm.isSecure()) ? " (secured)" : "";
        ILog.INFO(this.getClass(), (String)("Communication link established with " + iWebSocketComm.getRemoteHost() + " / " + iWebSocketComm.getRemoteAddr() + string));
        this.sessionInfo.assignRemoteAddress(iWebSocketComm.getSocketAddress(), iWebSocketComm.getRemoteHost(), iWebSocketComm.getDomain(), iWebSocketComm.getPort(), bl);
        this.onSessionConnected();
        if (this.getHeartBeatInterval() > 0L) {
            this.a = System.currentTimeMillis();
        }
    }

    public void onCommData(IWebSocketComm iWebSocketComm, byte[] byArray, int n, int n2) {
        if (this.DEBUG) {
            System.err.println("onCommData @" + Utilities.formatCurrentDate());
        }
        if (this.getHeartBeatInterval() > 0L) {
            this.a = System.currentTimeMillis();
        }
        try {
            byte[] byArray2 = this.a.decrypt(byArray, n, n2);
            if ((byArray2[0] & 0x80) != 0) {
                try {
                    byArray2[0] = (byte)(byArray2[0] & 0x7F);
                    byArray2 = DataPacket.decompress((byte[])byArray2);
                }
                catch (IOException iOException) {
                    this.onCommError(iWebSocketComm, new IOException("Error decompressing incoming data", iOException));
                    iWebSocketComm.close(true);
                    return;
                }
            }
            this.a(byArray2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.onCommError(iWebSocketComm, new IOException("Error processing Transaction", arrayIndexOutOfBoundsException));
            iWebSocketComm.close(true);
        }
    }

    public void onCommData(IWebSocketComm iWebSocketComm, String string) {
        if (this.DEBUG) {
            System.err.println("onCommData @" + Utilities.formatCurrentDate());
        }
        if (this.getHeartBeatInterval() > 0L) {
            this.a = System.currentTimeMillis();
        }
        this.a(Utilities.decodeBase64((String)string));
    }

    public void onCommHeartBeat(IWebSocketComm iWebSocketComm, long l) {
        if (this.DEBUG) {
            System.err.println("onCommHeartBeat @" + Utilities.formatCurrentDate());
        }
        if (this.getHeartBeatInterval() > 0L) {
            this.a = System.currentTimeMillis();
        }
        ILog.FINE(this.getClass(), (String)("Web socket heart-beat @" + l + "ms"));
    }

    public void onCommTimeout(IWebSocketComm iWebSocketComm, boolean bl) {
        if (this.DEBUG) {
            System.err.println("onCommTimeout @" + Utilities.formatCurrentDate());
        }
        ILog.WARNING(this.getClass(), (String)("Communication link timeout: isReadTimeout=" + bl));
    }

    public void onCommError(IWebSocketComm iWebSocketComm, Throwable throwable) {
        if (this.DEBUG) {
            System.err.println("onCommError @" + Utilities.formatCurrentDate());
        }
        if (throwable.getClass().getName().equals("org.eclipse.jetty.io.EofException")) {
            ILog.INFO(this.getClass(), (String)"Communication link remotly closed (EOF)");
        } else {
            ILog.INFO(this.getClass(), (String)"Communication link error", (Throwable)throwable);
        }
        iWebSocketComm.close(true);
    }

    public void onCommClosing(IWebSocketComm iWebSocketComm) {
        if (this.DEBUG) {
            System.err.println("onCommClosing @" + Utilities.formatCurrentDate());
        }
        ILog.FINE(this.getClass(), (String)"Communication link closing");
        this.a = 0L;
    }

    public void onCommClosed(IWebSocketComm iWebSocketComm, int n, String string) {
        if (this.DEBUG) {
            System.err.println("onCommClosed @" + Utilities.formatCurrentDate());
        }
        this.a = 0L;
        if (iWebSocketComm != this.a) {
            return;
        }
        ILog.INFO(this.getClass(), (String)"Communication link closed");
        this.dispose();
    }

    private void a(byte[] byArray) {
        if (this.DEBUG) {
            System.err.println("forwardData @" + Utilities.formatCurrentDate());
        }
        ReadTransaction readTransaction = ReadTransaction.from((byte[])byArray, (HashMap)((Object)this.a));
        c c2 = new c(this, null, readTransaction, null, 10);
        this.worker.post((WorkerTask)c2);
    }

    private void a(ReadTransaction readTransaction) {
        ReadTransaction readTransaction2;
        while ((readTransaction2 = readTransaction.readTransaction()) != null) {
            int n;
            int n2 = readTransaction2.readByte();
            if (this.DEBUG) {
                System.err.println("processQueueTransaction: code=" + n2 + " -- @" + Utilities.formatCurrentDate());
            }
            try {
                this.a(n2, readTransaction2);
            }
            catch (Throwable throwable) {
                ILog.SEVERE(this.getClass(), (String)"Failed transaction processing", (Throwable)throwable);
            }
            if ((n = readTransaction2.getRemainingReadSize()) <= 0) continue;
            ILog.SEVERE(this.getClass(), (String)("Unread transaction data remaining, size = " + n + " for code " + n2));
        }
    }

    private void a(int n, ReadTransaction readTransaction) {
        switch (n) {
            case 0: {
                this.endPointPropertyManager.readPropMgrData(readTransaction);
                break;
            }
            case 1: {
                ILog.log((int)readTransaction.readByte(), (String)"<endpoint>", (String)readTransaction.readString());
                break;
            }
            case 3: {
                if (this.root == null) {
                    this.root = this.endPointPropertyManager.createRootContainer(readTransaction, null);
                    this.propTransSender = new RootPropTransactionSender(this.endPointPropertyManager, this.root, this.worker, this);
                    this.onClientPropsCreated(this.root);
                    break;
                }
                this.endPointPropertyManager.processUpdateTrans(this.root, readTransaction);
                break;
            }
            case 6: {
                this.endPointPropertyManager.processRemoveEvent(readTransaction);
                break;
            }
            default: {
                if (this.processQueuedTransaction(n, readTransaction)) break;
                ILog.SEVERE(this.getClass(), (String)("Invalid transaction code received. Code = " + n + "."));
            }
        }
    }

    protected void onClientPropsCreated(PropCnr propCnr) {
        try {
            propCnr.getEnvironment().getServerEnv().addSystemProperties();
        }
        catch (PropException propException) {
            ILog.SEVERE(this.getClass(), (String)"Failed to update environment", (Throwable)propException);
        }
    }

    protected abstract boolean processQueuedTransaction(int var1, ReadTransaction var2);

    @Override
    public final boolean isConnected() {
        return this.a.isConnected();
    }

    public final SendTransaction createTransaction() {
        return new SendTransaction(this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sendTransaction(SendTransaction sendTransaction) {
        if (!this.a.isConnected()) {
            this.onCommError(this.a, new IOException("Send failure: communication link is not connected"));
            return;
        }
        if (this.DEBUG) {
            System.err.println("sendTransaction @" + Utilities.formatCurrentDate());
        }
        Worker worker = this.worker;
        synchronized (worker) {
            if (this.a != null) {
                this.a.append(sendTransaction);
                return;
            }
            this.a = sendTransaction;
        }
        this.worker.post((WorkerTask)new d(this, null, null, null, 0));
    }

    protected String paramString() {
        String string = this.sessionInfo.toString() + ",name=" + this.name;
        return this.a ? string + ",DISPOSED" : string;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "[" + this.paramString() + "]";
    }

    @Override
    public String getClientContextMenuReference(UIContextMenu uIContextMenu) {
        return "";
    }
}

