/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.oauth.services;

import com.github.scribejava.apis.FacebookApi;
import com.github.scribejava.core.builder.ScopeBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.iizix.ILog;
import com.iizix.Size;
import com.iizix.comm.oauth.AuthenticationProvider;
import com.iizix.server.oauth.AbstractOAuthService;
import com.iizix.server.oauth.OAuthSession;
import com.iizix.server.oauth.services.IServiceCreator;
import com.iizix.user.ProfilePictureInfo;
import com.iizix.user.UserProfileInfo;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Facebook
extends AbstractOAuthService {
    public static final String SCOPE_public_profile = "public_profile";
    public static final String SCOPE_email = "email";
    private static final String[] a = new String[]{"public_profile", "email"};
    private static FacebookApi a;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FacebookApi a() {
        FacebookApi facebookApi = a;
        if (facebookApi != null) return facebookApi;
        String string = "10.0";
        synchronized ("10.0") {
            facebookApi = a;
            if (facebookApi != null) return facebookApi;
            a = FacebookApi.customVersion((String)"10.0");
            return a;
        }
    }

    public static IServiceCreator<Facebook> initialize(String string, String string2, String ... stringArray) {
        Facebook.validate(string, string2, stringArray);
        return oAuthSession -> new Facebook(oAuthSession, string, string2, stringArray);
    }

    public Facebook(OAuthSession oAuthSession, String string, String string2, String ... stringArray) {
        super(oAuthSession, Facebook.createServiceBuilder(string, string2).defaultScope(new ScopeBuilder(stringArray == null || stringArray.length == 0 ? a : stringArray)).callback(oAuthSession.getCallbackURL()).build((DefaultApi20)Facebook.a()));
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return AuthenticationProvider.Facebook;
    }

    public Size getApproximateSize() {
        return new Size(750, 550);
    }

    @Override
    public String getLogoutURL() {
        return null;
    }

    @Override
    public UserProfileInfo getUserProfileInfo() throws IOException, InterruptedException, ExecutionException {
        String string = this.service2.getDefaultScope();
        if (!string.contains(SCOPE_public_profile)) {
            throw new IllegalStateException("No 'public_profile' requested in the scopes");
        }
        OAuth2AccessToken oAuth2AccessToken = this.getAccessToken2();
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, "https://graph.facebook.com/v10.0/me");
        oAuthRequest.addHeader("Accept-Language", "en-US");
        this.service2.signRequest(oAuth2AccessToken, oAuthRequest);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Response response = this.service2.execute(oAuthRequest);){
            int n = response.getCode();
            if (n != 200) {
                String string2 = "Failed retrieving profile, HTTP response " + n + ": " + response.getMessage();
                ILog.WARNING(this.getClass(), (String)string2);
                throw new IOException(string2);
            }
            String string3 = response.getBody();
            UserProfileInfo userProfileInfo = this.a(string3);
            if (userProfileInfo != null) {
                return userProfileInfo;
            }
            throw new IOException("Failed parsing body JSON response: " + string3);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private UserProfileInfo a(String string) {
        JSONObject jSONObject = new JSONObject(new JSONTokener(string));
        System.out.println("JSON body profile response:\n" + jSONObject.toString(2));
        try {
            String string2 = jSONObject.getString("sub");
            String string3 = null;
            String string4 = jSONObject.optString("name", null);
            String string5 = jSONObject.optString("given_name", null);
            String string6 = null;
            String string7 = jSONObject.optString("family_name", null);
            String string8 = jSONObject.optString(SCOPE_email, null);
            Boolean bl = jSONObject.has("email_verified") ? Boolean.valueOf(jSONObject.optBoolean("email_verified")) : null;
            String string9 = null;
            String string10 = jSONObject.optString("locale", null);
            ProfilePictureInfo[] profilePictureInfoArray = null;
            return new UserProfileInfo(string2, string3, string4, string5, string6, string7, string8, bl, string9, string10, profilePictureInfoArray);
        }
        catch (JSONException jSONException) {
            ILog.SEVERE(this.getClass(), (String)("Failed parsing profile response from JSON body: " + jSONException.getMessage() + "\n" + jSONObject.toString(2)));
            return null;
        }
    }
}

