/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.acme;

import com.iizix.comm.PortConfig;
import com.iizix.event.GEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.PKCS12IdentityProp;
import com.iizix.prop.PasswordProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.server.ServerShell;
import com.iizix.server.acme.LetsEncrypt;
import com.iizix.server.acme.LetsEncryptRenewal;
import com.iizix.server.prop.WebServerPortConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LetsEncryptDomain
extends PropCnr {
    public static final String ID_PKCS12 = "idPKCS12";
    public static final String ID_PASSWORD = "idPassword";
    public static final String EXPIRE_DAYS = "expireDays";
    public static final String TOS_URI = "tosURI";
    public static final String TOS_ACCEPT_URI = "acceptTosURI";
    public static final String AUTO_ACCEPT = "autoAccept";
    public static final String ALIAS = "iizi";
    public static final String DEFAULT_PASSWORD = "changeit";
    public static final String CHALLENGE_TYPE = "challenge";
    private KeyStore a;
    private LetsEncryptRenewal a;
    private ArrayList<PortConfig> a;

    public LetsEncryptDomain() {
    }

    public LetsEncryptDomain(Atom atom) {
        super(atom);
    }

    public LetsEncryptDomain clone() {
        try {
            LetsEncryptDomain letsEncryptDomain = (LetsEncryptDomain)super.clone();
            letsEncryptDomain.a = null;
            letsEncryptDomain.a = null;
            return letsEncryptDomain;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public void onEventSelf(GEvent gEvent) {
        super.onEventSelf(gEvent);
        switch (gEvent.getEventID()) {
            case 1: 
            case 2: 
            case 3: {
                GProp gProp = gEvent.getEventTarget();
                switch (gProp.getPropName()) {
                    case "idPKCS12": 
                    case "idPassword": {
                        this.a = null;
                    }
                }
            }
        }
    }

    public String getKeyStorePassword() {
        PasswordProp passwordProp = (PasswordProp)this.getProp(ID_PASSWORD, PasswordProp.class);
        return passwordProp != null ? (String)passwordProp.getPropValue() : DEFAULT_PASSWORD;
    }

    public KeyStore getKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = this.a;
        return keyStore != null ? keyStore : this.getKeyStore(null);
    }

    public KeyStore getKeyStore(StringBuilder stringBuilder) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        PKCS12IdentityProp pKCS12IdentityProp = (PKCS12IdentityProp)this.getProp(ID_PKCS12, PKCS12IdentityProp.class);
        String string = this.getKeyStorePassword();
        if (pKCS12IdentityProp == null || string == null) {
            return null;
        }
        KeyStore keyStore = this.a;
        if (keyStore == null) {
            keyStore = this.a = pKCS12IdentityProp.getKeyStore(string.toCharArray());
        }
        if (stringBuilder != null) {
            stringBuilder.setLength(0);
            stringBuilder.append(string);
        }
        return keyStore;
    }

    public boolean updateIdentity(File file, String string) throws UnrecoverableKeyException, FileNotFoundException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, PropException {
        PasswordProp passwordProp = null;
        if (string == null) {
            string = DEFAULT_PASSWORD;
        } else if (!string.equals(DEFAULT_PASSWORD)) {
            passwordProp = new PasswordProp(Atom.get((String)ID_PASSWORD), string);
        }
        this.a = null;
        boolean bl = this.removeProp(TOS_ACCEPT_URI);
        bl |= passwordProp == null ? this.removeProp(ID_PASSWORD) : this.setProp((IGProp)passwordProp);
        PKCS12IdentityProp pKCS12IdentityProp = new PKCS12IdentityProp(Atom.get((String)ID_PKCS12));
        pKCS12IdentityProp.setIdentity(file.getAbsolutePath(), string.toCharArray());
        if (bl |= this.setProp((IGProp)pKCS12IdentityProp)) {
            this.d();
        }
        return bl;
    }

    public int getExpirationDayCount() {
        int n = this.getInt(EXPIRE_DAYS, 7);
        return Math.min(Math.max(n, 1), 60);
    }

    public Date getExpirationDate() {
        try {
            KeyStore keyStore = this.getKeyStore();
            Enumeration<String> enumeration = keyStore.aliases();
            if (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                return x509Certificate.getNotAfter();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getDomain() {
        return this.getPropName();
    }

    public String getDescription() {
        return this.getString(Atom.DESCR);
    }

    public LetsEncrypt.Type getChallengeType() {
        int n = this.getInt(CHALLENGE_TYPE);
        LetsEncrypt.Type[] typeArray = LetsEncrypt.Type.values();
        return n >= 0 && n < typeArray.length ? typeArray[n] : LetsEncrypt.Type.HTTP;
    }

    public String getTermsOfServiceURI() {
        return this.getString(TOS_URI);
    }

    public boolean isAutoAcceptTermsOfServiceEnabled() {
        return this.getBool(AUTO_ACCEPT);
    }

    public boolean acceptTermsOfService(String string) {
        if (string == null) {
            throw new NullPointerException("uri is null");
        }
        return this.setString(TOS_URI, string);
    }

    public String getNeedToAcceptTermsOfServiceURI() {
        return this.getString(TOS_ACCEPT_URI);
    }

    public boolean setNeedToAcceptTermsOfServiceURI(String string) {
        if (string == null) {
            throw new NullPointerException("uri is null");
        }
        return this.setString(TOS_ACCEPT_URI, string);
    }

    public void startRenewal(ServerShell serverShell) {
        if (this.a == null) {
            this.a = new LetsEncryptRenewal(serverShell, this);
        }
    }

    public LetsEncryptRenewal getRenewalInstance() {
        return this.a;
    }

    public synchronized void addConnectorReference(PortConfig portConfig) {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        ((ArrayList)((Object)this.a)).add(portConfig);
    }

    private void d() {
        PropCnr propCnr = this.getParent();
        if (propCnr != null) {
            String string = this.getDomain();
            WebServerPortConfig[] webServerPortConfigArray = (WebServerPortConfig[])propCnr.getProps(WebServerPortConfig.class);
            int n = webServerPortConfigArray.length;
            int n2 = 0;
            while (n2 < n) {
                WebServerPortConfig webServerPortConfig = webServerPortConfigArray[n2];
                for (String string2 : webServerPortConfig.getLetsEncryptDomainNamesSet()) {
                    if (!string.equals(string2)) continue;
                    webServerPortConfig.restartConnector();
                }
                ++n2;
            }
        }
    }
}

