/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.security;

import com.iizix.Utilities;
import com.iizix.server.client.DHKey;
import com.iizix.server.security.ServerSecurityManager;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ServerKey {
    private static int a = 32;
    private long a;
    private byte[] a;
    private String a;
    private SecretKeySpec a;

    ServerKey() {
        this.a = System.currentTimeMillis();
        this.a = new byte[a];
        Utilities.getSecureRandom().nextBytes(this.a);
        this.a = Utilities.encodeBase64((byte[])ServerSecurityManager.digest(this.a));
    }

    ServerKey(byte[] byArray, long l) {
        this.a = byArray;
        this.a = l;
        this.a = Utilities.encodeBase64((byte[])ServerSecurityManager.digest(byArray));
    }

    public String getFingerPrint() {
        return this.a;
    }

    byte[] a() {
        return this.a;
    }

    long a() {
        return this.a;
    }

    private SecretKeySpec a() {
        if (this.a == null) {
            this.a = new SecretKeySpec(this.a, "AES");
        }
        return this.a;
    }

    String a(String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, DigestException {
        byte[] byArray = Utilities.decodeBase64((String)string);
        int n = byArray.length - 32;
        if (n < 48) {
            throw new IllegalArgumentException("Parameter \"" + string + "\" is not encoded with 'encodeParameter()' or has been modified");
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 32, byArray2, 0, n);
        byte[] byArray3 = messageDigest.digest(byArray2);
        int n2 = 32;
        while (--n2 >= 0) {
            if (byArray3[n2] == byArray[n2]) continue;
            throw new IllegalArgumentException("Parameter \"" + string + "\" has been tampered with since it was encoded with 'encodeParameter()', signature is different");
        }
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)this.a(), DHKey.getIvParameterSpec());
        byte[] byArray4 = cipher.doFinal(byArray, 32, n);
        String string2 = new String(byArray4, StandardCharsets.UTF_8);
        int n3 = string2.indexOf(0);
        if (n3 < 0) {
            throw new IllegalArgumentException("Parameter \"" + string + "\" is not encoded with 'encodeParameter()' or has been modified: padding delimter not found");
        }
        return string2.substring(n3 + 1);
    }

    String b(String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        SecureRandom secureRandom = Utilities.getSecureRandom();
        StringBuilder stringBuilder = new StringBuilder();
        int n = Math.max(47, string.length() + 5) + secureRandom.nextInt(13);
        while (--n >= 0) {
            stringBuilder.append((char)(1 + secureRandom.nextInt(255)));
        }
        stringBuilder.append('\u0000').append(string);
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)this.a(), DHKey.getIvParameterSpec());
        byte[] byArray2 = cipher.doFinal(byArray);
        byte[] byArray3 = MessageDigest.getInstance("SHA-256").digest(byArray2);
        byte[] byArray4 = new byte[byArray2.length + 32];
        System.arraycopy(byArray3, 0, byArray4, 0, 32);
        System.arraycopy(byArray2, 0, byArray4, 32, byArray2.length);
        return Utilities.encodeBase64((byte[])byArray4);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ServerKey) {
            ServerKey serverKey = (ServerKey)object;
            return Arrays.equals(this.a, serverKey.a);
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[fingerPrint=" + this.a + ",timeStamp=" + Utilities.formatDate((long)this.a) + "]";
    }
}

