/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.oauth.services;

import com.github.scribejava.apis.MicrosoftAzureActiveDirectory20Api;
import com.github.scribejava.core.builder.ScopeBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.iizix.ILog;
import com.iizix.Size;
import com.iizix.comm.oauth.AuthenticationProvider;
import com.iizix.server.oauth.AbstractOAuthService;
import com.iizix.server.oauth.OAuthSession;
import com.iizix.server.oauth.services.IServiceCreator;
import com.iizix.user.ProfilePictureInfo;
import com.iizix.user.UserProfileInfo;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Microsoft
extends AbstractOAuthService {
    public static final String SCOPE_user_read = "User.Read";
    public static final String SCOPE_openid = "openid";
    private static final String[] a = new String[]{"User.Read", "openid"};

    public static IServiceCreator<Microsoft> initialize(String string, String string2, String string3, String ... stringArray) {
        Microsoft.validate(string2, string3, stringArray);
        return oAuthSession -> new Microsoft(oAuthSession, string, string2, string3, stringArray);
    }

    public Microsoft(OAuthSession oAuthSession, String string, String string2, String string3, String ... stringArray) {
        super(oAuthSession, Microsoft.createServiceBuilder(string2, string3).defaultScope(new ScopeBuilder(stringArray == null || stringArray.length == 0 ? a : stringArray)).callback(oAuthSession.getCallbackURL()).build((DefaultApi20)(string == null || string.isEmpty() || string.equalsIgnoreCase("common") ? MicrosoftAzureActiveDirectory20Api.instance() : MicrosoftAzureActiveDirectory20Api.custom((String)string))));
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return AuthenticationProvider.Microsoft;
    }

    public Size getApproximateSize() {
        return new Size(750, 550);
    }

    @Override
    public String getLogoutURL() {
        return null;
    }

    @Override
    public UserProfileInfo getUserProfileInfo() throws IOException, InterruptedException, ExecutionException {
        String string = this.service2.getDefaultScope();
        if (!string.contains(SCOPE_user_read)) {
            throw new IllegalStateException("No 'User.Read' requested in the scopes");
        }
        OAuth2AccessToken oAuth2AccessToken = this.getAccessToken2();
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, "https://graph.microsoft.com/v1.0/me");
        oAuthRequest.addHeader("Accept-Language", "en-US");
        this.service2.signRequest(oAuth2AccessToken, oAuthRequest);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Response response = this.service2.execute(oAuthRequest);){
            int n = response.getCode();
            if (n != 200) {
                String string2 = "Failed retrieving profile, HTTP response " + n + ": " + response.getMessage();
                ILog.WARNING(this.getClass(), (String)string2);
                throw new IOException(string2);
            }
            String string3 = response.getBody();
            UserProfileInfo userProfileInfo = this.a(string3, this.service2, oAuth2AccessToken);
            if (userProfileInfo != null) {
                return userProfileInfo;
            }
            throw new IOException("Failed parsing body JSON response: " + string3);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private UserProfileInfo a(String string, OAuth20Service oAuth20Service, OAuth2AccessToken oAuth2AccessToken) {
        JSONObject jSONObject = new JSONObject(new JSONTokener(string));
        System.out.println("JSON body profile response:\n" + jSONObject.toString(2));
        try {
            int n;
            String string2;
            Object object;
            String string3;
            Throwable throwable;
            String string4 = jSONObject.getString("id");
            String string5 = null;
            String string6 = jSONObject.optString("displayName", null);
            String string7 = jSONObject.optString("givenName", null);
            String string8 = null;
            String string9 = jSONObject.optString("surname", null);
            String string10 = jSONObject.optString("mail", null);
            Boolean bl = jSONObject.has("userPrincipalName") ? Boolean.valueOf(Objects.equals(string10, jSONObject.optString("userPrincipalName"))) : null;
            String string11 = null;
            String string12 = jSONObject.optString("preferredLanguage", null);
            ProfilePictureInfo[] profilePictureInfoArray = null;
            OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, "https://graph.microsoft.com/v1.0/me/photo/$value");
            oAuth20Service.signRequest(oAuth2AccessToken, oAuthRequest);
            try {
                throwable = null;
                string3 = null;
                try {
                    object = oAuth20Service.execute(oAuthRequest);
                    try {
                        if (object.getCode() == 200 && (string2 = object.getHeader("content-type")) != null && string2.startsWith("image/")) {
                            profilePictureInfoArray = new ProfilePictureInfo[]{new ProfilePictureInfo(object.getStream(), string2)};
                        }
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throwable = new UserProfileInfo(string4, string5, string6, string7, string8, string9, string10, bl, string11, string12, profilePictureInfoArray);
            string3 = jSONObject.optString("jobTitle", null);
            if (string3 != null && !string3.isEmpty()) {
                throwable.addDetail("IZS-JobTitle", string3);
            }
            if ((object = jSONObject.optString("mobilePhone")) != null && !((String)object).isEmpty()) {
                throwable.addDetail("IZS-HomeMobile", (String)object);
            }
            if ((string2 = jSONObject.optJSONArray("businessPhones")) != null && (n = string2.length()) > 0) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    String string13 = string2.getString(n3);
                    if (string13 != null && !string13.isEmpty()) {
                        Object object2 = "IZS-WorkPhone";
                        if (n2 > 0) {
                            object2 = (String)object2 + "-" + ++n2;
                        }
                        throwable.addDetail((String)object2, string13);
                    }
                    ++n3;
                }
            }
            return throwable;
        }
        catch (JSONException jSONException) {
            ILog.SEVERE(this.getClass(), (String)("Failed parsing profile response from JSON body: " + jSONException.getMessage() + "\n" + jSONObject.toString(2)));
            return null;
        }
    }
}

