/**
 * (C) Copyright Mindus SARL, 2025.
 * All rights reserved.
 * 
 * @fileoverview  Messages uses in the customized version of iiziRun.
 * 
 * @author Christopher Mindus
 */

/* jshint unused:true, undef:true */
/* globals window */

// +------------------------------------------------------------------------------+
// |                                                                              |
// |   N O T E !!!   This file should NOT contain anything else than the SINGLE   |
// |   -----------   definition of window.izRun.M={..object...}.                  |
// |                                                                              |
// |                 Otherwise RuntimeBuilder won't function!                     |
// |                                                                              |
// +------------------------------------------------------------------------------+

window.izRun.M=
  {
  // Application name and description.
  APP_NAME          : 'Your App name',
  APP_DESCR         : 'Your App description',
  
  // Buttons, headings.
  OK                : 'OK',
  CANCEL            : 'Cancel',
  SELECT            : 'select',
  
  // General.
  REMOTE_NOT_PGM    : 'Remote party is not an {0} instance: {1} ({2}).',
  REMOTE_FAILED     : 'Remote connection failed.',
  INV_RESP_FORMAT   : 'Invalid format of the remote response, probably not an {0} instance.',
  REMOTE_WRONG      : 'The remote party is not an {0} instance.',
  REMOTE_INCOMPAT   : 'Remote {0} is not compatible with this version of the app.',
  
  // Version change.
  VERSION           : 'Version {0}',
  VER_UPDATE_HEAD   : 'Version Update',
  VER_UPDATE        : 'The cache has automatically been cleared due to a version update.',
  
  // Restart.
  CONF_RESTART      : 'Do you wish to quit and restart?',
  CONF_RESTART_HEAD : 'Confirm Restart',
    
  // Exit.
  EXIT_HEAD1        : 'Exit',
  EXIT_HEAD2        : 'Confirm Exit',
  EXIT_QUESTION     : 'Do you wish to exit?',
  EXIT_FAILURE      : 'Failed to exit.',
  
  // File system.
  FSS_FAIL          : 'Local file system failed to initialize.',
  FSS_HEAD          : 'File System',
  FSS_ERROR         : 'Error: {0}',
  FSS_INIT_ERR      : 'File system initialization error: {0}.',
  FSS_INIT_ERR1     : 'The file system access is not supported on this device.',
  FSS_INIT_ERR2     : 'App cannot continue.',
  SAVE_HEAD         : 'Save Settings',
  SAVE_ERR          : 'Failed saving settings: {0}.',
  
  // Errors.
  ERROR             : 'Error',
  JS_ERROR          : 'The application encountered a JavaScript error',
  JS_LINE           : ' on line {0}',
  JS_LINE_COLUMN    : ' on line {0}, column {1}',
  JS_IN_SOURCE      : ' in {0}',
  RUN_RESTART       : 'App will restart.',
  
  // Authentication.
  DECODE_PW         : 'Failed decoding password "{0}": {1}.',
    
  // Apps.
  SERVER_NOT_TLS    : 'Server requests authentication but TLS security is not enabled.',
  SERVER_AUTH_CANCEL: 'Server authentication canceled.',
  
  // Download+Launch.
  NO_NC             : 'Network connection is not available', 
  DL_HEAD           : 'Downloading',
  UPDATING_FILES    : 'Updating files, please wait...',
  LAUNCH_APP_ID     : 'Launch App {0}',
  APP_ERROR_HEAD    : 'Application Error',
  APP_ERROR_MSG     : 'Failed loading the iiziApp JavaScript code. The application cannot start.',
  FAIL_INJECT_CSS   : 'Failed injecting CSS {0}',
  LAUNCH_ERR_HEAD   : 'Launch Error',
  LAUNCH_SRV_NONE   : 'The server did not specify how to launch app.', 
  DL_FAILED_HEAD    : 'Download Failed',
  DL_FAILED_MSG     : 'Downloading failed. There were {0} errors:',
  SAVE_DL_FAILED    : 'Saving downloaded file failed: {0}.',
  DL_ERR_NO_TLS     : 'Download failure: server requests authentication but secrity (TLS) is not enabled',
  DL_AUTH_CANCEL    : 'Download failure: server authentication canceled.',
  DL_FAILURE        : 'Download failure',
  DL_FAILURE2       : 'Download failed: status = {0} ({1}).',
  DL_FAILURE3       : 'Failed downloading file "{0}": {1} ({2}).',
  DL_FAILURE4       : 'Failed downloading file "{0}": connection error.',
  CACHE_ERR_HEAD    : 'Internal problem',
  CACHE_ERR_MSG     : 'The window.izApp.def.addr is not set for cacheFiles!',
  CACHE_SAVE_FAILED : 'Failed saving file "{0}" to cache: {1}.',
  LOAD_CACHE_FAILED : 'Failed loading cached file "{0}" from {1}: {2}.',
  
  // Deep linking.
  DEEPLINK_ERR_HEAD : 'Deep Link',
  INVALID_LANG      : 'Invalid language code "{0}".',
  INVALID_THEME     : 'Invalid theme name "{0}".',
  MISSING_PARAM     : 'Missing "{0}" parameter.',
  DEEPLINK_OP       : 'Unknown deep link operation: "{0}".',
  DEEPLINK_OP_URL   : 'Invalid deep link operation "{0}" in url {1}.',
  CHANGE_APP_HEAD   : 'Confirm App Change',
  CHANGE_APP_MSG    : 'Please confirm change of application.'
  };
