/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.js.build;

import com.iizix.ILog;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.js.build.compressors.HtmlCompressor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Compressor {
    static boolean a = false;
    private static Compressor a;
    private final String a = Compressor.a("load/closure-stylesheets-1.5.0-iizi.jar", "CSS compressor");
    private final String b = Compressor.a("load/closure-compiler-v20260107.jar", "JS compressor");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Compressor getInstance(File file) throws IOException {
        if (a != null) return a;
        Class<Compressor> clazz = Compressor.class;
        synchronized (Compressor.class) {
            if (a != null) return a;
            a = new Compressor(file);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return a;
        }
    }

    private static String a(String string, String string2) throws FileNotFoundException {
        try {
            URI uRI;
            File file;
            URL uRL = Compressor.class.getClassLoader().getResource(string);
            if (uRL != null && (file = new File(uRI = uRL.toURI())).isFile()) {
                return file.getCanonicalPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new FileNotFoundException(string2 + " Jar file '" + string + "' is not found");
    }

    private Compressor(File file) throws FileNotFoundException {
    }

    public File invokeCSSCompressor(File file, List<String> list) throws IOException {
        String string = file.getName();
        int n = string.indexOf(46);
        File file2 = File.createTempFile("iiziCompress-" + string.substring(0, n) + "-", ".css");
        File file3 = file.getParentFile();
        this.invokeCSSCompressor(file3, file2, list);
        return file2;
    }

    public void invokeCSSCompressor(File file, File file2) throws IOException {
        file = Utilities.getCanonicalFile((File)file);
        File file3 = file.getParentFile();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getName());
        this.invokeCSSCompressor(file3, file2, arrayList);
    }

    public void invokeCSSCompressor(File file, File file2, List<String> list) throws IOException {
        block23: {
            if (a) {
                File file3 = null;
                try {
                    Throwable throwable = null;
                    Object var6_11 = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                        for (String string : list) {
                            file3 = new File(file, string).getCanonicalFile();
                            fileOutputStream.write(("/* CSS file " + file3.getPath() + " */\n\n").getBytes(Utilities.UTF8));
                            fileOutputStream.write(Files.readAllBytes(file3.toPath()));
                            fileOutputStream.write(10);
                        }
                        break block23;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (InvalidPathException invalidPathException) {
                    if (file3 != null) {
                        throw new IOException("Invalid path \"" + file3.getPath() + "\"", invalidPathException);
                    }
                    throw new IOException("Invalid path", invalidPathException);
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
            arrayList.add("-jar");
            arrayList.add(this.a);
            arrayList.add("--allow-unrecognized-functions");
            arrayList.add("--allow-unrecognized-properties");
            arrayList.addAll(list);
            ILog.INFO(this.getClass(), (String)("Invoking CSS compressor: " + String.join((CharSequence)" ", arrayList)));
            File file4 = File.createTempFile("iiziCompress-CSS-stderr-", ".out");
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                processBuilder.directory(file);
                processBuilder.redirectError(file4);
                processBuilder.redirectOutput(file2);
                processBuilder.environment().clear();
                Process process = processBuilder.start();
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    process.destroyForcibly();
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException2) {
                        // empty catch block
                    }
                    file2.delete();
                    throw new IOException("Compress process interrupted", interruptedException);
                }
                int n = process.exitValue();
                this.a("CSS", n, file4);
                if (n != 0) {
                    System.err.println("Errornous CSS output = " + file2.getAbsolutePath());
                    throw new IOException("Failed CSS compression, return code " + n);
                }
            }
            finally {
                file4.delete();
            }
        }
    }

    public File invokeJSCompressor(File file, List<String> list, Level level) throws IOException {
        String string = file.getName();
        int n = string.indexOf(46);
        File file2 = File.createTempFile("iiziCompress-" + string.substring(0, n) + "-", ".js");
        File file3 = file.getParentFile();
        this.invokeJSCompressor(file3, file2, level, list);
        return file2;
    }

    public void invokeJSCompressor(File file, File file2, Level level) throws IOException {
        File file3 = file.getParentFile();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getAbsolutePath());
        this.invokeJSCompressor(file3, file2, level, arrayList);
    }

    public void invokeJSCompressor(File file, File file2, Level level, List<String> list) throws IOException {
        block46: {
            if (a) {
                File file3 = null;
                try {
                    if (list.size() == 1) {
                        file3 = new File(list.get(0));
                        Files.copy(file3.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        break block46;
                    }
                    Throwable throwable = null;
                    Object var7_12 = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                        for (String string : list) {
                            file3 = new File(file, string);
                            fileOutputStream.write(("/* JS file " + file3.getCanonicalPath() + " */\n\n").getBytes(Utilities.UTF8));
                            fileOutputStream.write(Files.readAllBytes(file3.toPath()));
                            fileOutputStream.write(10);
                        }
                        break block46;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (InvalidPathException invalidPathException) {
                    if (file3 != null) {
                        throw new IOException("Invalid path \"" + file3.getPath() + "\"", invalidPathException);
                    }
                    throw new IOException("Invalid path", invalidPathException);
                }
            }
            boolean bl = list.size() == 1;
            File file4 = null;
            File file5 = null;
            File file6 = null;
            int n = 0;
            try {
                try {
                    Object object;
                    ProcessBuilder processBuilder;
                    ArrayList<String> arrayList;
                    file5 = File.createTempFile("iiziCompress-JS-stderr-", ".out");
                    StringBuilder stringBuilder = new StringBuilder();
                    if (bl) {
                        file4 = Utilities.getCanonicalFile((File)new File(list.get(0)));
                        arrayList = file4.getPath();
                        stringBuilder.append((String)((Object)arrayList));
                    } else {
                        file4 = Utilities.getCanonicalFile((File)File.createTempFile("izCompress-", ".js"));
                        arrayList = null;
                        processBuilder = null;
                        try {
                            object = new FileOutputStream(file4);
                            try {
                                ((FileOutputStream)object).write("(function(window,document,location,navigator){".getBytes(StandardCharsets.US_ASCII));
                                for (String object2 : list) {
                                    file6 = Utilities.getCanonicalFile((File)new File(file, object2));
                                    String string = file6.getPath();
                                    stringBuilder.append("\n - ").append(string);
                                    ((FileOutputStream)object).write(("\n/* JavaScript file \"" + string + "\" */\n").getBytes(Utilities.UTF8));
                                    ((FileOutputStream)object).write(Files.readAllBytes(file6.toPath()));
                                    ((FileOutputStream)object).write(10);
                                }
                                ((FileOutputStream)object).write("\n})(window,document,location,navigator);".getBytes(StandardCharsets.US_ASCII));
                            }
                            finally {
                                if (object != null) {
                                    ((FileOutputStream)object).close();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            if (arrayList == null) {
                                arrayList = throwable;
                            } else if (arrayList != throwable) {
                                ((Throwable)((Object)arrayList)).addSuppressed(throwable);
                            }
                            throw arrayList;
                        }
                    }
                    arrayList = new ArrayList<String>();
                    arrayList.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + SystemConfig.EXE_EXT);
                    arrayList.add("-Xmx400m");
                    arrayList.add("-jar");
                    arrayList.add(this.b);
                    arrayList.add("--charset");
                    arrayList.add("UTF8");
                    arrayList.add("--compilation_level");
                    arrayList.add(level.name());
                    arrayList.add("--language_out");
                    arrayList.add("ECMASCRIPT5");
                    arrayList.add("--js");
                    arrayList.add(file4.getPath());
                    if (bl) {
                        ILog.INFO(this.getClass(), (String)("Invoking JS compressor: " + String.join((CharSequence)" ", arrayList) + " for file: " + String.valueOf(stringBuilder)));
                    } else {
                        ILog.INFO(this.getClass(), (String)("Invoking JS compressor: " + String.join((CharSequence)" ", arrayList) + " for files:" + String.valueOf(stringBuilder)));
                    }
                    processBuilder = new ProcessBuilder(arrayList);
                    processBuilder.directory(file);
                    processBuilder.redirectOutput(file2);
                    processBuilder.redirectError(file5);
                    processBuilder.environment().clear();
                    object = processBuilder.start();
                    try {
                        ((Process)object).waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        ((Process)object).destroyForcibly();
                        try {
                            ((Process)object).waitFor();
                        }
                        catch (InterruptedException interruptedException2) {
                            // empty catch block
                        }
                        throw new IOException("Compress process interrupted", interruptedException);
                    }
                    n = ((Process)object).exitValue();
                    this.a("JS", n, file5);
                    if (n != 0) {
                        if (file2.length() > 0L) {
                            String string = file2.getAbsolutePath() + ".err";
                            new ProcessBuilder("write", string).start();
                            throw new IOException("Failed JS compression, return code " + n + ", see file contents of stderr in path " + string + " and JS code in " + String.valueOf(file4));
                        }
                        throw new IOException("Failed JS compression, return code " + n + ", see file contents in temp-file of JS code in " + String.valueOf(file4));
                    }
                }
                catch (IOException iOException) {
                    if (n != 0) {
                        file5 = null;
                        file4 = null;
                    }
                    throw iOException;
                }
                catch (InvalidPathException invalidPathException) {
                    if (file6 != null) {
                        throw new IOException("Invalid path \"" + String.valueOf(file6) + "\"", invalidPathException);
                    }
                    throw new IOException("Invalid path", invalidPathException);
                }
            }
            finally {
                if (!bl && file4 != null) {
                    file4.delete();
                }
                if (file5 != null) {
                    file5.delete();
                }
            }
        }
    }

    public static void compressHTML(File file, File file2, Charset charset) throws IOException {
        if (charset == null) {
            charset = Utilities.UTF8;
        }
        try {
            String string = Files.readString(file.toPath(), charset);
            String string2 = Compressor.compressHTML(string);
            string = null;
            Files.writeString(file2.toPath(), (CharSequence)string2, charset, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("Invalid path \"" + file.getPath() + "\"", invalidPathException);
        }
    }

    public static String compressHTML(String string) throws IOException {
        if (a) {
            return string;
        }
        try {
            HtmlCompressor htmlCompressor = new HtmlCompressor();
            htmlCompressor.setRemoveIntertagSpaces(true);
            htmlCompressor.setRemoveQuotes(true);
            htmlCompressor.setRemoveScriptAttributes(true);
            htmlCompressor.setRemoveStyleAttributes(true);
            htmlCompressor.setRemoveLinkAttributes(true);
            htmlCompressor.setRemoveFormAttributes(true);
            htmlCompressor.setRemoveInputAttributes(true);
            htmlCompressor.setSimpleBooleanAttributes(true);
            htmlCompressor.setRemoveJavaScriptProtocol(true);
            htmlCompressor.setRemoveSurroundingSpaces("br,p");
            htmlCompressor.setCompressCss(true);
            htmlCompressor.setCompressJavaScript(true);
            htmlCompressor.setYuiCssLineBreak(80);
            htmlCompressor.setYuiJsDisableOptimizations(true);
            htmlCompressor.setYuiJsLineBreak(-1);
            htmlCompressor.setYuiJsNoMunge(true);
            htmlCompressor.setYuiJsPreserveAllSemiColons(true);
            if (string == null) {
                throw new IOException("input HTML source is null");
            }
            String string2 = htmlCompressor.compress(string);
            if (string2 == null) {
                throw new IOException("compressedHtml is null");
            }
            return string2;
        }
        catch (Throwable throwable) {
            throw new IOException("Failed HTML compression:\n\n" + string, throwable);
        }
    }

    private void a(String string, int n, File file) {
        if (file.length() > 0L) {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Utilities.UTF8));){
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string2).append('\n');
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("...\n---\n");
                }
                stringBuilder.append("Error reading stderr file: " + String.valueOf(iOException));
            }
            if (n > 0) {
                ILog.SEVERE(this.getClass(), (String)("Failed " + string + " compression of file " + String.valueOf(file) + ", return code " + n + ":\n    " + stringBuilder.toString().replace("\n", "\n    ")));
            } else if (!stringBuilder.isEmpty()) {
                ILog.WARNING(this.getClass(), (String)(string + " compression resulted in warnings: " + String.valueOf(file) + "\n:    " + stringBuilder.toString().replace("\n", "\n    ")));
            }
        } else if (n > 0) {
            ILog.SEVERE(this.getClass(), (String)("Failed " + string + " compression of file " + String.valueOf(file) + ": return code " + n));
        }
    }

    public static enum Level {
        WHITESPACE_ONLY,
        SIMPLE;

    }
}

