/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.js.build.compressors;

import com.iizix.js.build.compressors.Compressor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlCompressor
implements Compressor {
    private boolean a = true;
    private boolean b = true;
    private boolean c = true;
    protected static final String tempCdataBlock = "%%%COMPRESS~CDATA~{0,number,#}%%%";
    protected static final Pattern cdataPattern = Pattern.compile("<!\\[CDATA\\[.*?\\]\\]>", 34);
    protected static final Pattern commentPattern = Pattern.compile("<!--.*?-->", 34);
    protected static final Pattern intertagPattern = Pattern.compile(">\\s+<", 34);
    protected static final Pattern tagEndSpacePattern = Pattern.compile("(<(?:[^>]+?))(?:\\s+?)(/?>)", 34);
    protected static final Pattern multispacePattern = Pattern.compile("\\s+(?=[^<]*?>)", 34);
    protected static final Pattern tagPropertyPattern = Pattern.compile("(\\s\\w+)\\s*=\\s*(?=[^<]*?>)", 2);
    protected static final Pattern tempCdataPattern = Pattern.compile("%%%COMPRESS~CDATA~(\\d+?)%%%", 34);

    @Override
    public String compress(String string) {
        if (!this.a || string == null || string.length() == 0) {
            return string;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        string = this.preserveBlocks(string, arrayList);
        string = this.processXml(string);
        string = this.returnBlocks(string, arrayList);
        return string.trim();
    }

    protected String preserveBlocks(String string, List<String> list) {
        Matcher matcher = cdataPattern.matcher(string);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            list.add(matcher.group(0));
            matcher.appendReplacement(stringBuffer, MessageFormat.format(tempCdataBlock, n++));
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        return string;
    }

    protected String returnBlocks(String string, List<String> list) {
        Matcher matcher = tempCdataPattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(list.get(Integer.parseInt(matcher.group(1)))));
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        return string;
    }

    protected String processXml(String string) {
        string = this.removeComments(string);
        string = this.removeIntertagSpaces(string);
        string = this.removeSpacesInsideTags(string);
        return string;
    }

    protected String removeSpacesInsideTags(String string) {
        string = multispacePattern.matcher(string).replaceAll(" ");
        string = tagPropertyPattern.matcher(string).replaceAll("$1=");
        string = tagEndSpacePattern.matcher(string).replaceAll("$1$2");
        return string;
    }

    protected String removeIntertagSpaces(String string) {
        if (this.c) {
            string = intertagPattern.matcher(string).replaceAll("><");
        }
        return string;
    }

    protected String removeComments(String string) {
        if (this.b) {
            string = commentPattern.matcher(string).replaceAll("");
        }
        return string;
    }

    public boolean isEnabled() {
        return this.a;
    }

    public void setEnabled(boolean bl) {
        this.a = bl;
    }

    public boolean isRemoveComments() {
        return this.b;
    }

    public void setRemoveComments(boolean bl) {
        this.b = bl;
    }

    public boolean isRemoveIntertagSpaces() {
        return this.c;
    }

    public void setRemoveIntertagSpaces(boolean bl) {
        this.c = bl;
    }
}

