/**
 * Callback variable pointing to a function.
 */
var izLinkCB;

/**
 * Modified plugin for hyperlink and image from original dijit/_editor/plugins/LinkDialog.
 */
define("dijit/_editor/plugins/LinkDialog",[
  "dojo/_base/declare", // declare
  "dojo/dom-attr", // domAttr.get
  "dojo/_base/lang", // lang.delegate lang.hitch lang.trim
  "dojo/_base/sniff", // has("ie")
  "dojo/_base/window", // win.withGlobal
  "../_Plugin",
  "../range",
  "../selection"],
 function(declare,domAttr,lang,has,win,_Plugin,rangeapi,selectionapi)
  {
  /**
   * This plugin provides the basis for an 'anchor' (link) dialog and an extension of it provides the image link dialog.
   *
   * Editor plugins: LinkDialog (for inserting links) and ImgLinkDialog (for inserting images)
   */
  var LinkDialog=declare("dijit._editor.plugins.LinkDialog",_Plugin,
    {
    // The command provided by this plugin is "createLink".
    // Override _Plugin.useDefaultCommand... processing is handled by this plugin, not by dijit.Editor.
    useDefaultCommand: false,

    // Tag used for the link type.
    tag: 'a',
    
    // Required attribute to be present at double-click.
    reqAttr: 'href',
  
    /**
     * Initiates the button.
     */
    _initButton: function()
      {
      var self=this;
      self.inherited(arguments);
      self._connectTagEvents();
      self.connect(self.button,'onClick',function()
        {
        self._onOpenDialog();
        });
      },

    /**
     * Connects the tag events.
     */
    _connectTagEvents: function()
      {
      // summary:
      //    Over-ridable function that connects tag specific events.
      this.editor.onLoadDeferred.addCallback(lang.hitch(this,function()
        {
        this.connect(this.editor.editNode,"ondblclick",this._onDblClick);
        }));
      },

    /**
     * Function to define a behavior on double clicks on the element
     * type this dialog edits to select it and pop up the editor dialog.
     */
    _onDblClick: function(e)
      {
      if ( e && e.target )
        {
        var self=this,editor=self.editor,t=e.target,tg=t.tagName? t.tagName.toLowerCase(): "";
        if ( tg===self.tag && domAttr.get(t,self.reqAttr) )
          {
          win.withGlobal(editor.window,"selectElement",selectionapi,[t]);
          editor.onDisplayChanged();
          self.button.set("disabled",false);
          self._onOpenDialog();
          }
        }
      },

    /**
     * Callback from the dialog when user presses "OK" button.
     */
    setValue: function(args)
      {
      var self=this,editor=self.editor;
      editor.focus(); // Make sure focus is present and selection gets there again.
      if ( has("ie")<9 )
        {
        var sel=rangeapi.getSelection(this.editor.window),
            range=sel.getRangeAt(0),
            a=range.endContainer;
        if ( a.nodeType===3 )
          {
          // Text node, may be the link contents, so check parent.
          // This plugin doesn't really support nested HTML elements
          // in the link, it assumes all link content is text.
          a=a.parentNode;
          }
        if ( a && (a.nodeName && a.nodeName.toLowerCase()!==this.tag) )
          {
          // Still nothing, one last thing to try on IE, as it might be 'img'
          // and thus considered a control.
          a=win.withGlobal(this.editor.window,"getSelectedElement",selectionapi,[this.tag]);
          }
        if ( a && (a.nodeName && a.nodeName.toLowerCase()===this.tag) )
          {
          // Okay, we do have a match. IE, for some reason, sometimes pastes before
          // instead of removing the targeted paste-over element, so we unlink the
          // old one first.  If we do not the <a> tag remains, but it has no content,
          // so isn't readily visible (but is wrong for the action).
          if ( editor.queryCommandEnabled("unlink") )
            {
            // Select all the link children, then unlink. The following insert will
            // then replace the selected text.
            win.withGlobal(this.editor.window,"selectElementChildren",selectionapi,[a]);
            editor.execCommand("unlink");
            }
          }
        }
      editor.execCommand('inserthtml',self.buildTag(args));
      },
      
    /**
     * Handler for when the dialog is opened.
     * If the caret is currently in a URL then get the URL's info.
     */
    _onOpenDialog: function()
      {
      var self=this,editor=self.editor,a;
      editor.focus(); // Make sure focus is present and selection gets there again.
      if ( has("ie")<9 )
        {
        // IE is difficult to select the element in, using the range unified
        // API seems to work reasonably well.
        var sel=rangeapi.getSelection(editor.window),
            range=sel.getRangeAt(0);
        a=range.endContainer;
        if ( a.nodeType===3 )
          {
          // Text node, may be the link contents, so check parent.
          // This plugin doesn't really support nested HTML elements
          // in the link, it assumes all link content is text.
          a=a.parentNode;
          }
        if ( a && (a.nodeName && a.nodeName.toLowerCase()!==self.tag) )
          {
          // Still nothing, one last thing to try on IE, as it might be 'img'
          // and thus considered a control.
          a=win.withGlobal(editor.window,"getSelectedElement",selectionapi,[self.tag]);
          }
        }
      else
        a=win.withGlobal(editor.window,"getAncestorElement",selectionapi,[self.tag]);

      // We're OK now. Request dialog box in Eclipse.
      self._doEclipseDialog(self._getCurrentValues(a));
      },

    /**
     * Builds the hyperlink tag.
     */
    buildTag: function(args)
      {
      var doc=this.editor.document,div=doc.createElement('div'),a=doc.createElement('a');
      div.appendChild(a);
      a.href=args.href;
      a.target=args.target;
      a.setAttribute('_izRealURL',args.href);
      a.appendChild(doc.createTextNode(args.innerText));
      return div.innerHTML;
      },
  
    /**
     * The anchor/link dialog box data.
     */
    _getCurrentValues: function(a)
      {
      var href,innerText,target;
      if ( a && a.tagName.toLowerCase()===this.tag )
        {
        href=a.getAttribute('_izRealURL') || a.href;
        target=a.target || '_blank';
        innerText=a.textContent || a.innerText;
        win.withGlobal(this.editor.window,"selectElement",selectionapi,[a,true]);
        }
      else
        text=win.withGlobal(this.editor.window,selectionapi.getSelectedText);
      return {href:href||'',innerText:innerText||'',target:target||''};
      },

    /**
     * Opens the Eclipse dialog.
     */
    _doEclipseDialog: function(p)
      {
      // Set callback to us, call Eclipse function 3.
      var self=this,editor=self.editor;
      izLinkCB=function(oper)
        {
        var innerText=izCallback(3,0),
            href     =izCallback(3,1),
            target   =izCallback(3,2);
//        alert('after eclipse dlg box: get values!'+innerText+','+href+','+target);
        self.setValue({href:href,innerText:innerText,target:target});
        };

      // Display edit dialog in Eclipse.
      try { izCallback(5,p.innerText,p.href,p.target); }
      catch(e)
        {
        console.log('Error EclipseCB(5): '+e);
        var innerText,href,target;
        if ( p.innerText==='' )
          {
          innerText='New hyperlink';
          href='http://google.com';
          target='_blank';
          }
        else
          {
          innerText=p.innerText;
          href='http://edit.it';
          target='OH';
          }
        self.setValue({href:href,innerText:innerText,target:target});
        }
      }
    });

  /**
   * This plugin extends LinkDialog and adds in a plugin for handling image links.
   * provides the image link dialog.
   */
  var ImgLinkDialog=declare("dijit._editor.plugins.ImgLinkDialog",[LinkDialog],
    {
    // The command provided by this plugin is "insertImage".
    // Tag used for the link type (img).
    tag: "img",

    // Required attribute to be present at double-click.
    reqAttr: 'src',
  
    /**
     * Connects tag specific events.
     */
    _connectTagEvents: function()
      {
      this.inherited(arguments);
      this.editor.onLoadDeferred.addCallback(lang.hitch(this,function()
        {
        // Use onmousedown instead of onclick. Seems that IE eats the first onclick
        // to wrap it in a selector box, then the second one acts as onclick.
        this.connect(this.editor.editNode,'onmousedown',this._selectTag);
        }));
      },

    /**
     * A simple event handler that lets me select an image if it is clicked on.
     * makes it easier to select images in a standard way across browsers. Otherwise
     * selecting an image for edit becomes difficult.
     */
    _selectTag: function(e)
      {
      if ( e && e.target )
        {
        var t=e.target,tg=t.tagName? t.tagName.toLowerCase(): "";
        if ( tg===this.tag )
          win.withGlobal(this.editor.window,"selectElement",selectionapi,[t]);
        }
      },

    /**
     * Builds the hyperlink tag.
     */
    buildTag: function(args)
      {
      var doc=this.editor.document,div=doc.createElement('div'),img=doc.createElement('img');
      div.appendChild(img);
      img.src=args.src;
      img.border=0;
      if ( args.width  && args.width !=='' ) try { img.width =parseInt(args.width ,10); } catch(e) {}
      if ( args.height && args.height!=='' ) try { img.height=parseInt(args.height,10); } catch(e) {}
      img.setAttribute('alt'    ,args.alt);
      img.setAttribute('realURL',args.realURL);
      return div.innerHTML;
      },

    /**
     * The anchor/link dialog box data.
     */
    _getCurrentValues: function(a)
      {
      var src,alt,width,height,realURL;
      if ( a && a.tagName.toLowerCase()===this.tag )
        {
        alt    =a.getAttribute('alt');
        realURL=a.getAttribute('realURL');
        src    =realURL || a.src;
        width  =String(a.width);
        height =String(a.height);
        win.withGlobal(this.editor.window,"selectElement",selectionapi,[a,true]);
        }
      //else
      //  text=win.withGlobal(this.editor.window,selectionapi.getSelectedText);
      return {src:src||'',realURL:realURL||'',width:width||'',height:height||'',alt:alt||''};
      },

    /**
     * Opens the Eclipse dialog.
     */
    _doEclipseDialog: function(p)
      {
      // Set callback to us, call Eclipse function 3.
      var self=this,editor=self.editor,src,realURL,width,height,alt;
      izLinkCB=function(oper)
        {
        src    =izCallback(3,0);
        realURL=izCallback(3,1);
        width  =izCallback(3,2);
        height =izCallback(3,3);
        alt    =izCallback(3,4);
        self.setValue({src:src,realURL:realURL,width:width,height:height,alt:alt});
        };

      // Display edit dialog in Eclipse.
      try { izCallback(6,p.realURL); }
      catch(e)
        {
        console.log('Error EclipseCB(5): '+e);
        if ( p.src==='' )
          {
          src=realURL='http://netphantom.com/docimage/welcome.jpg';
          width=height='';
          alt='First text';
          }
        else
          {
          src=realURL='http://netphantom.com/docimage/news.jpg';
          alt='Other text';
          width='99';
          height='50';
          }
        self.setValue({src:src,realURL:realURL,width:width,height:height,alt:alt});
        }
      }
    });

  // Register these plugins
  _Plugin.registry.createLink =function() { return new LinkDialog   ({command: "createLink" }); };
  _Plugin.registry.insertImage=function() { return new ImgLinkDialog({command: "insertImage"}); };

  // Export both LinkDialog and ImgLinkDialog
  LinkDialog.ImgLinkDialog=ImgLinkDialog;
  return LinkDialog;
  });
