/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jetty;

import com.iizix.ILog;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.jetty.IExternalBrowserPages;
import com.iizix.jetty.IWSFileProviderServer;
import com.iizix.jetty.RunConfigurationWebServer;
import com.iizix.jetty.WSHelper;
import com.iizix.jetty.WSJarResourceFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.content.FileMappingHttpContentFactory;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.http.content.PreCompressedHttpContentFactory;
import org.eclipse.jetty.http.content.ResourceHttpContent;
import org.eclipse.jetty.http.content.ValidatingCachingHttpContentFactory;
import org.eclipse.jetty.http.content.VirtualHttpContentFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class j
extends ResourceHandler {
    private static final Set<String> a = Set.of("D", "common", "jsc", "jsr", "css", "jquery");
    private final Map<String, File> a;
    private final Map<String, File> b;
    private final Map<File, File> c;
    private File a;
    private final IWSFileProviderServer a;
    private final IExternalBrowserPages a;
    private final File b;
    private final boolean a;
    private final ResourceHttpContent a;

    j(String string, boolean bl, Map<String, File> map, Map<String, File> map2, Map<File, File> map3, IWSFileProviderServer iWSFileProviderServer, IExternalBrowserPages iExternalBrowserPages) throws FileNotFoundException {
        this.a = iExternalBrowserPages;
        this.a = map;
        this.b = map2;
        this.c = map3;
        this.a = iWSFileProviderServer;
        File file = new File(string);
        this.b = new File(file, "iiziApp.html");
        if (!this.b.isFile()) {
            throw new FileNotFoundException("The iiziApp.html file is not found");
        }
        this.setBaseResource(WSHelper.a(file));
        this.setDirAllowed(bl);
        File file2 = new File(file, "iz/css/dir.css");
        if (!file2.isFile()) {
            throw new FileNotFoundException("The iz/css/dir.css stylesheet file is not found");
        }
        this.a = bl;
        Resource resource = WSHelper.a(file2);
        this.setStyleSheet(resource);
        this.a = new ResourceHttpContent(resource, "text/css", ByteBufferPool.SIZED_NON_POOLING);
        if (SystemConfig.isDevelopmentMode) {
            this.a = map2.get("iiziRunDevel.root");
        }
        this.setPrecompressedFormats(new CompressedContentFormat[]{CompressedContentFormat.GZIP});
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (WSHelper.a) {
            ILog.INFO(((Object)((Object)this)).getClass(), (String)"> Handle  request: \"{}\"", (Object)request.getHttpURI());
        }
        com.iizix.jetty.a.a(request, response);
        boolean bl = super.handle(request, response, callback);
        if (WSHelper.a) {
            ILog.INFO(((Object)((Object)this)).getClass(), (String)"< Handled request = \"{}\": \"{}\"", (Object[])new Object[]{bl, request.getHttpURI()});
        }
        return bl;
    }

    protected HttpContent.Factory newHttpContentFactory(ByteBufferPool.Sized sized) {
        a a2 = new a(this.getBaseResource(), this.getMimeTypes(), sized);
        int n = this.getMinMappedFileSize();
        if (n != 0) {
            a2 = new FileMappingHttpContentFactory((HttpContent.Factory)a2, n, this.getMaxMappedFileSize());
        }
        a2 = new VirtualHttpContentFactory((HttpContent.Factory)a2, this.getStyleSheet(), "text/css", sized);
        a2 = new PreCompressedHttpContentFactory((HttpContent.Factory)a2, this.getPrecompressedFormats());
        a2 = new ValidatingCachingHttpContentFactory((HttpContent.Factory)a2, Duration.ofSeconds(1L).toMillis(), sized);
        return a2;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class a
    implements HttpContent.Factory {
        private final MimeTypes a;
        private final ByteBufferPool.Sized a;

        private a(Resource resource, MimeTypes mimeTypes, ByteBufferPool.Sized sized) {
            this.a = Objects.requireNonNull(mimeTypes);
            this.a = sized;
        }

        public HttpContent getContent(String object) throws IOException {
            Resource resource;
            block11: {
                if (object == null) {
                    return null;
                }
                if (j.this.a != null) {
                    String string;
                    int n = 0;
                    if (((String)object).startsWith("/$iiziRunCustom.root$/")) {
                        n = RunConfigurationWebServer.a;
                    } else if (((String)object).startsWith("/$iiziRunCustomized.root$/")) {
                        n = RunConfigurationWebServer.b;
                    }
                    int n2 = ((String)object).indexOf(47, n);
                    if (n2 > 0 && a.contains(string = ((String)object).substring(n, n2))) {
                        object = "/$iiziRunDevel.root$/" + ((String)object).substring(n - 1);
                    }
                }
                try {
                    if (j.this.a && ((String)object).endsWith("/jetty-dir.css")) {
                        return j.this.a;
                    }
                    String string = Utilities.decodeSpecialURIChars((String)object);
                    if (WSHelper.a) {
                        ILog.INFO(this.getClass(), (String)("WSResourceHttpContentFactory.getContent: pathInContext = {}, decodedPath = {}" + (String)object), (Object)string);
                    }
                    if (!Resources.missing((Resource)(resource = this.a(string))) || !Resources.missing((Resource)(resource = this.b(string))) || !Resources.missing((Resource)(resource = this.b((String)object)))) break block11;
                    return null;
                }
                catch (Throwable throwable) {
                    InvalidPathException invalidPathException = new InvalidPathException((String)object, "Invalid PathInContext");
                    invalidPathException.initCause(throwable);
                    throw invalidPathException;
                }
            }
            resource = this.a(resource);
            return new ResourceHttpContent(resource, this.a.getMimeByExtension((String)object), this.a);
        }

        private Resource a(String string) {
            int n;
            if (WSHelper.a) {
                ILog.INFO(this.getClass(), (String)"getRedirectedDirectoryResource: path = {}", (Object)string);
            }
            if ((n = string.indexOf(126)) < 0) {
                return null;
            }
            String string2 = string.substring(1, n).replace('\\', '/');
            File file = (File)j.this.a.get(string2);
            if (file == null) {
                return null;
            }
            if (!file.exists()) {
                ILog.WARNING(this.getClass(), (String)"Redirected directory \"{}\" not found: \"{}\"", (Object[])new Object[]{string2, file});
                return null;
            }
            if (!file.isDirectory()) {
                ILog.WARNING(this.getClass(), (String)"Redirected directory \"{}\" is not a directory: \"{}\"", (Object[])new Object[]{string2, file});
                return null;
            }
            if (!file.canRead()) {
                return null;
            }
            String string3 = string.substring(n + 1).replace('\\', '/');
            if (string3.isEmpty() || string3.equals("/")) {
                return WSHelper.a(file);
            }
            if (string3.charAt(0) != '/') {
                return null;
            }
            Path path = file.toPath().normalize();
            Path path2 = path.resolve(string3.substring(1)).normalize();
            File file2 = path2.toFile();
            if (!file2.exists()) {
                ILog.INFO(this.getClass(), (String)"Redirected resource \"{}\" not found in directory \"{}\" from root path \"{}\"", (Object[])new Object[]{string3, file, string2});
                return null;
            }
            File file3 = file2;
            boolean bl = file3.equals(file);
            while (!bl) {
                File file4 = file3.getParentFile();
                if (file4 == null) {
                    ILog.WARNING(this.getClass(), (String)"Redirected resource \"{}\" not found in directory \"{}\" from root path \"{}\": cannot get the parent file of \"{}\"", (Object[])new Object[]{string3, file, string2, file3});
                    return null;
                }
                bl = file4.equals(file);
                file3 = file4;
            }
            if (!bl) {
                ILog.WARNING(this.getClass(), (String)"Redirected resource \"{}\" not found in directory \"{}\" from root path \"{}\": NOT A CHILD OF DIRECTORY!", (Object[])new Object[]{string3, file, string2});
                return null;
            }
            return WSHelper.a(file2);
        }

        public String toString() {
            return "WSResourceHttpContentFactory@" + this.hashCode();
        }

        private Resource b(String string) {
            if (WSHelper.a) {
                ILog.INFO(this.getClass(), (String)"getResource: path = {}", (Object)string);
            }
            if (string.indexOf(58) < 0 && !string.contains("..")) {
                int n;
                File file;
                while (string.contains("//")) {
                    string = string.replace("//", "/");
                }
                if (j.this.a != null && (file = j.this.a.getFileResourceFromExternalURL(string)) != null) {
                    return WSHelper.a(file);
                }
                if (string.startsWith("/$") && (n = string.indexOf(36, 2)) > 0) {
                    String string2 = string.substring(2, n);
                    if (n + 1 == string.length()) {
                        File file2 = j.this.b.get(string2);
                        if (file2 != null && file2.isFile()) {
                            return WSHelper.a(file2);
                        }
                    } else if (string.charAt(n + 1) == '/') {
                        Object object;
                        String string3 = string.substring(n + 2);
                        File file3 = j.this.b.get(string2);
                        if (file3 != null) {
                            if (!string3.isEmpty()) {
                                file3 = new File(file3, string3);
                            }
                            return WSHelper.a(file3);
                        }
                        if (!string3.isEmpty() && (object = j.this.a.getFileOrResource(string2, string3)) != null) {
                            if (object instanceof WSJarResourceFile) {
                                WSJarResourceFile wSJarResourceFile = (WSJarResourceFile)object;
                                return wSJarResourceFile.newResource();
                            }
                            if (object instanceof File) {
                                File file4 = (File)object;
                                return WSHelper.a(file4);
                            }
                            ILog.WARNING(this.getClass(), (String)"Resource \"{}\" at location \"{}\" is not URL or File", (Object[])new Object[]{string3, string2, object});
                            return null;
                        }
                    }
                }
                if (string.startsWith("/izc") && (file = j.this.b.get(string.substring(1))) != null) {
                    return WSHelper.a(file);
                }
            }
            return null;
        }

        private Resource a(Resource resource) {
            block7: {
                Path path = resource.getPath();
                if (path != null) {
                    try {
                        Resource resource2;
                        File file = path.toFile();
                        File file2 = j.this.c.get(file.getCanonicalFile());
                        if (file2 == null) break block7;
                        if (resource instanceof Closeable) {
                            Closeable closeable = (Closeable)resource;
                            try {
                                closeable.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (!Resources.missing((Resource)(resource2 = WSHelper.a(file2)))) {
                            resource = resource2;
                        }
                    }
                    catch (IOException | InvalidPathException exception) {
                        // empty catch block
                    }
                }
            }
            return resource;
        }
    }
}

