/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jdbc;

import com.iizix.IFileURLResolver;
import com.iizix.ILog;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.jdbc.DerbyImpl;
import com.iizix.jdbc.IDBConnectionPool;
import com.iizix.jdbc.UpdateJDBCDriversDirectory;
import com.iizix.jdbc.a;
import com.iizix.prop.PropCnr;
import com.iizix.util.XJarFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JDBCHelper {
    static IFileURLResolver a = new HashMap(3);
    private static final HashMap<String, String> a;
    private static HashMap<String, a> b;
    static File a;
    static boolean a;
    private static File b;
    private static boolean b;

    static {
        a.put("classpath", "jarList");
        a.put("driverClassName", "driverClass");
        a.put("url", "URL");
        b = new HashMap();
        a = SystemConfig.isDevelopmentMode;
    }

    public static String setUsePrivateDirectory(boolean bl) {
        File file = Utilities.getCanonicalFile((File)new File(System.getProperty("user.home"), ".iizi/jdbc-drivers"));
        if (!file.exists()) {
            if (!bl) {
                return "Private user directory for JDBC drivers \"" + String.valueOf(file) + "\" does not exist";
            }
            try {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            catch (IOException | InvalidPathException exception) {
                return "Failed creating user directory for JDBC drivers \"" + String.valueOf(file) + "\": " + exception.getMessage();
            }
        }
        if (!file.isDirectory()) {
            return "Private user directory for JDBC drivers \"" + String.valueOf(file) + "\" is not a directory but a file";
        }
        b = bl;
        b = file;
        return null;
    }

    public static File initialize(IFileURLResolver iFileURLResolver) throws IOException {
        block12: {
            Object object;
            block10: {
                File file;
                block11: {
                    if (a != null) break block12;
                    object = "The JDBC drivers directory \"jdbc-drivers\" cannot be located";
                    ClassLoader classLoader = JDBCHelper.class.getClassLoader();
                    URL uRL = classLoader.getResource("jdbc-drivers");
                    if (uRL == null) {
                        object = (String)object + ": URL resource not found";
                    } else {
                        file = null;
                        try {
                            file = iFileURLResolver.resolveURL(uRL);
                            if (!file.exists()) {
                                object = (String)object + ": resource \"" + file.getPath() + "\" is not found from URL " + String.valueOf(uRL);
                                break block10;
                            }
                            if (!file.isDirectory()) {
                                object = (String)object + ": resource \"" + file.getPath() + "\" is not a directory from URL " + String.valueOf(uRL);
                            }
                            break block11;
                        }
                        catch (Exception exception) {
                            object = (String)object + ": resource \"" + String.valueOf(file) + "\" is not found from URL " + String.valueOf(uRL);
                        }
                    }
                    break block10;
                }
                a = file;
                object = null;
            }
            if (object != null) {
                throw new IOException((String)object);
            }
            a = iFileURLResolver;
            if (b != null) {
                if (!b.isDirectory()) {
                    throw new FileNotFoundException("Private user directory for JDBC drivers \"" + String.valueOf(b) + "\" is not found");
                }
                if (b) {
                    UpdateJDBCDriversDirectory.copyJDBCDriversTo(b, iFileURLResolver);
                }
                a = b;
            }
        }
        return a;
    }

    public static URL[] getClassLoaderURLs(File file, String string) throws IOException {
        Path path = null;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (file != null) {
            if (!(file = Utilities.getCanonicalFile((File)file)).isDirectory()) {
                throw new FileNotFoundException("The 'dir' parameter " + file.getPath() + " is not a directory");
            }
            try {
                path = file.toPath();
            }
            catch (InvalidPathException invalidPathException) {
                throw new IOException("Invalid path \"" + file.getAbsolutePath() + "\"", invalidPathException);
            }
        }
        if (string == null || string.isEmpty()) {
            if (file != null) {
                try {
                    arrayList.add(JDBCHelper.a(file));
                }
                catch (Exception exception) {
                    throw new IOException("Invalid path \"" + file.getPath() + "\" for URL: " + exception.getMessage());
                }
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.isEmpty()) continue;
                File file2 = null;
                try {
                    File file3 = file2 = path != null ? Utilities.getCanonicalFile((File)path.resolve(string2).toFile()) : Utilities.getCanonicalFile((String)string2);
                    if (file2.isFile()) {
                        String string3 = file2.getName();
                        int n = string3.lastIndexOf(46);
                        if (n < 0 || !(string3 = string3.substring(n + 1)).equalsIgnoreCase("jar") && !string3.equalsIgnoreCase("zip")) {
                            throw new IOException("Path \"" + string2 + "\" (" + file2.getPath() + ") is not a Jar or a Zip file");
                        }
                    } else if (!file2.isDirectory()) {
                        throw new FileNotFoundException("Path \"" + string2 + "\" (" + file2.getPath() + ") is not found");
                    }
                    arrayList.add(JDBCHelper.a(file2));
                }
                catch (Exception exception) {
                    String string4 = "Invalid path \"" + string2 + "\" for URL";
                    if (file2 != null) {
                        string4 = string4 + " (" + file2.getPath() + ")";
                    }
                    throw new IOException(string4 + ": " + exception.getMessage());
                }
            }
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private static final URL a(File file) throws IOException {
        return (file = file.getCanonicalFile()).isFile() && file.getName().toLowerCase().endsWith(".jar") ? XJarFile.getJarFile((File)file).getURL() : file.toURI().toURL();
    }

    public static IDBConnectionPool from(String object, File file) throws IOException, SQLException {
        Properties properties = com.iizix.jdbc.a.a(file);
        Object object2 = properties.remove("description");
        if (object2 instanceof String) {
            object = (String)object + " - " + String.valueOf(object2);
        }
        return com.iizix.jdbc.a.a((String)object, file, properties, null);
    }

    public static IDBConnectionPool from(String object, DerbyImpl derbyImpl) throws IOException, SQLException {
        Properties properties;
        File file = a;
        try {
            File file2 = new File(file, "dbconf.properties");
            properties = file2.isFile() ? com.iizix.jdbc.a.a(file) : derbyImpl.a();
            Object object2 = properties.remove("description");
            if (object2 instanceof String) {
                object = (String)object + " - " + String.valueOf(object2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            properties = derbyImpl.a();
        }
        return com.iizix.jdbc.a.a((String)object, file, properties, derbyImpl);
    }

    public static IDBConnectionPool from(String string, PropCnr propCnr, Properties properties) throws SQLException, IOException {
        Object object;
        Properties properties2 = new Properties();
        for (Map.Entry entry : com.iizix.jdbc.a.a.entrySet()) {
            object = (String)entry.getKey();
            String string2 = object;
            Object v = entry.getValue();
            Object object2 = propCnr.getPropValue(string2);
            if (object2 != null) {
                if (a) {
                    if (((String)object).equals("password")) {
                        System.err.println(" * Found key 'password' --> '***** (hidden)'");
                    } else {
                        System.err.println(" * Found key '" + (String)object + "' --> " + String.valueOf(object2));
                    }
                }
            } else {
                string2 = (String)a.get(object);
                if (string2 == null || (object2 = propCnr.getPropValue(string2)) == null) continue;
                if (a) {
                    System.err.println(" * Found key " + (String)object + " --> " + String.valueOf(object2) + ", named " + string2 + " for the Eclipse Database properties");
                }
            }
            if (!v.getClass().equals(object2.getClass())) {
                ILog.SEVERE(JDBCHelper.class, (String)("Value for key \"" + string2 + "\" in property container (" + propCnr.getReferencePropName() + ") found, but wrong class: " + String.valueOf(object2.getClass()) + " != " + String.valueOf(v.getClass()) + " = " + String.valueOf(object2)));
                continue;
            }
            if (!(object2 instanceof String) && !(object2 instanceof Boolean) && !(object2 instanceof Integer) && !(object2 instanceof Long)) continue;
            properties2.put(object, object2);
        }
        if (a) {
            System.err.println("--- JDBC properties for pool " + string + " ---");
            for (Map.Entry<Object, Object> entry : properties2.entrySet()) {
                object = entry.getKey();
                if ("password".equals(object)) {
                    System.err.println(" - 'password' = '***** (hidden)'");
                    continue;
                }
                System.err.println(" - '" + String.valueOf(object) + "' = '" + String.valueOf(entry.getValue()) + "'");
            }
        }
        return com.iizix.jdbc.a.a(string, a, properties2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean a(a a2) {
        HashMap<String, a> hashMap = b;
        synchronized (hashMap) {
            Iterator<a> iterator = b.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (iterator.next() != a2);
            iterator.remove();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int disposeAll() {
        a[] aArray;
        Object object = b;
        synchronized (object) {
            aArray = b.values().toArray(new a[b.size()]);
            b.clear();
        }
        a[] aArray2 = aArray;
        int n = aArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = aArray2[n2];
            try {
                ((a)object).a(true);
            }
            catch (SQLException sQLException) {
                ILog.SEVERE(JDBCHelper.class, (String)"Failed disposing database connection pool", (Throwable)sQLException);
            }
            ++n2;
        }
        return aArray.length;
    }
}

