/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jdbc;

import com.iizix.ILog;
import com.iizix.Value;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class DefaultTableLoader
implements AutoCloseable {
    public static final Pattern nullPattern = Pattern.compile(" *(null) *", 2);
    public static final Pattern timePattern = Pattern.compile("([01]?\\d|2[0-3])[:.]([0-5]\\d)[:.]([0-5]\\d)");
    public static final Pattern datePattern = Pattern.compile("[12]\\d{3}[-/](0[1-9]|1[0-2])[-/](0[1-9]|[12]\\d|3[01])");
    public static final Pattern timestampPattern = Pattern.compile("[12]\\d{3}[-/](0?[1-9]|1[0-2])[-/](0?[1-9]|[12]\\d|3[01])\\s+([01]?\\d|2[0-3])[:.]([0-5]\\d)[:.]([0-5]\\d)(\\.[0-9]{1,9})?");
    public static final Pattern dateTimeSeparatorPattern = Pattern.compile("[-/:. ]+");
    public static final int DEFAULT_BATCH_COUNT = 1000;
    protected final CSVParser parser;
    protected final PreparedStatement insertStatement;
    protected final Connection conn;
    protected final String[] columns;
    private int[] a;

    public DefaultTableLoader(InputStream inputStream, Charset charset, Connection connection, String string, boolean bl, String ... stringArray) throws SQLException, IOException {
        this(new InputStreamReader(inputStream, charset), connection, string, bl, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultTableLoader(Reader reader, Connection connection, String string, boolean bl, String ... stringArray) throws SQLException, IOException {
        String string2;
        int n;
        block30: {
            Statement statement;
            Object var9_14;
            Throwable throwable;
            connection.setAutoCommit(true);
            n = stringArray.length;
            if (n == 0) {
                throw new IllegalArgumentException("No columns are specified");
            }
            this.a = new int[n];
            if (bl) {
                string2 = "DELETE FROM " + string;
                ILog.INFO(this.getClass(), (String)("Clearing table " + string + ", executing " + string2));
                try {
                    throwable = null;
                    var9_14 = null;
                    try {
                        statement = connection.createStatement();
                        try {
                            statement.execute(string2);
                            connection.commit();
                        }
                        finally {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (SQLException sQLException) {
                    ILog.SEVERE(this.getClass(), (String)("Failed clearing table " + string + ", SQL statement = [" + string2 + "]: " + sQLException.getMessage()));
                    throw sQLException;
                }
            }
            string2 = "SELECT " + String.join((CharSequence)",", stringArray) + " FROM " + string;
            try {
                throwable = null;
                var9_14 = null;
                try {
                    statement = connection.createStatement();
                    try {
                        try (ResultSet resultSet = statement.executeQuery(string2);){
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            int n2 = 0;
                            while (n2 < n) {
                                this.a[n2] = resultSetMetaData.getColumnType(n2 + 1);
                                ++n2;
                            }
                        }
                        if (statement == null) break block30;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (statement == null) throw throwable;
                        statement.close();
                        throw throwable;
                    }
                    statement.close();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (SQLException sQLException) {
                ILog.SEVERE(this.getClass(), (String)("Failed retrieving table " + string + " meta data, SQL statement = [" + string2 + "]: " + sQLException.getMessage()));
                throw sQLException;
            }
        }
        string2 = "INSERT INTO " + string + " (" + String.join((CharSequence)", ", stringArray) + ") VALUES (";
        int n3 = 0;
        while (true) {
            if (n3 >= n) {
                string2 = string2 + ")";
                ILog.INFO(this.getClass(), (String)("Insert rows in table " + string + " with " + string2));
                this.insertStatement = connection.prepareStatement(string2);
                this.conn = Objects.requireNonNull(connection);
                this.columns = stringArray;
                this.parser = this.createParser(new BufferedReader(reader));
                return;
            }
            string2 = string2 + (n3 == 0 ? "?" : ",?");
            ++n3;
        }
    }

    public CSVParser createParser(BufferedReader bufferedReader) throws IOException {
        return ((CSVParser.Builder)CSVParser.builder().setFormat(CSVFormat.ORACLE).setReader((Reader)bufferedReader)).get();
    }

    @Override
    public void close() throws IOException, SQLException {
        IOException iOException = null;
        try {
            this.parser.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.insertStatement.close();
        }
        catch (SQLException sQLException) {
            if (iOException != null) {
                sQLException.addSuppressed(sQLException);
            }
            throw sQLException;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public void processReader() throws IOException, SQLException {
        this.processReader(1000);
    }

    public void processReader(int n) throws IOException, SQLException {
        boolean bl = this.conn.getAutoCommit();
        this.conn.setAutoCommit(false);
        boolean bl2 = false;
        int n2 = 0;
        try {
            for (CSVRecord cSVRecord : this.parser) {
                this.processLine(cSVRecord);
                try {
                    this.insertStatement.addBatch();
                    bl2 = true;
                    if (++n2 != n) continue;
                    n2 = 0;
                    this.insertStatement.executeBatch();
                }
                catch (SQLException sQLException) {
                    ILog.SEVERE(this.getClass(), (String)"Failed adding record as new row", (Object[])new Object[]{cSVRecord, sQLException});
                    throw sQLException;
                }
            }
        }
        finally {
            if (n2 > 0) {
                this.insertStatement.executeBatch();
            }
            if (bl2) {
                this.conn.commit();
            }
            this.conn.setAutoCommit(bl);
        }
    }

    protected void processLine(CSVRecord cSVRecord) throws IOException, SQLException {
        int n = 0;
        for (String string : cSVRecord) {
            if (n == this.columns.length) {
                throw new IOException("End of record not found after last column, record = " + String.valueOf(cSVRecord));
            }
            int n2 = this.a[n++];
            try {
                if (string == null || nullPattern.matcher(string).find()) {
                    this.insertStatement.setNull(n, n2);
                    continue;
                }
                Object object = null;
                switch (n2) {
                    case -7: 
                    case 16: {
                        boolean bl = string.equalsIgnoreCase("true");
                        if (!bl && !string.equalsIgnoreCase("false")) {
                            try {
                                int n3 = Integer.parseInt(string);
                                if (n3 < 0 || n3 > 1) {
                                    object = "SQL data type " + Value.getSQLTypeName((int)n2) + " expected 1 or 0";
                                } else {
                                    bl = n3 == 1;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                object = "SQL data type " + Value.getSQLTypeName((int)n2) + " expected 1 or 0";
                            }
                        }
                        if (object != null) break;
                        this.insertStatement.setBoolean(n, bl);
                        break;
                    }
                    case -6: {
                        try {
                            short s = Short.parseShort(string);
                            if (s >= 0 && s <= 255) {
                                this.insertStatement.setShort(n, s);
                                break;
                            }
                            object = "SQL data type TINYINT, expected value 0 to 255";
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = "SQL data type TINYINT, expected Short value 0 to 255";
                        }
                        break;
                    }
                    case 5: {
                        try {
                            this.insertStatement.setShort(n, Short.parseShort(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = "SQL data type SMALLINT, expected Short value";
                        }
                        break;
                    }
                    case 4: {
                        try {
                            this.insertStatement.setInt(n, Integer.parseInt(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = "SQL data type INTEGER, got " + string;
                        }
                        break;
                    }
                    case -5: {
                        try {
                            this.insertStatement.setLong(n, Long.parseLong(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = "SQL data type BIGINT, expected Long value";
                        }
                        break;
                    }
                    case 6: 
                    case 8: {
                        try {
                            this.insertStatement.setDouble(n, Double.parseDouble(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = "SQL data type " + Value.getSQLTypeName((int)n2) + ", expected Double value";
                        }
                        break;
                    }
                    case 7: {
                        try {
                            this.insertStatement.setFloat(n, Float.parseFloat(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = "SQL data type REAL, expected Float value";
                        }
                        break;
                    }
                    case 2: 
                    case 3: {
                        try {
                            this.insertStatement.setBigDecimal(n, new BigDecimal(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = "SQL data type " + Value.getSQLTypeName((int)n2) + ", expected BigDecimal value";
                        }
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.insertStatement.setString(n, string);
                        break;
                    }
                    case 91: {
                        if (!datePattern.matcher(string).find()) {
                            object = "SQL data type DATE, expected DATE format value";
                            break;
                        }
                        try {
                            this.insertStatement.setDate(n, Date.valueOf(string.replace('/', '-')));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            object = "SQL data type DATE is illegal";
                        }
                        break;
                    }
                    case 92: {
                        if (!timePattern.matcher(string).find()) {
                            object = "SQL data type TIME, expected TIME format value";
                            break;
                        }
                        try {
                            this.insertStatement.setTime(n, Time.valueOf(string.replace('.', ':')));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            object = "SQL data type TIME is illegal";
                        }
                        break;
                    }
                    case 93: {
                        if (!timestampPattern.matcher(string).find()) {
                            object = "SQL data type TIMESTAMP, expected TIMESTAMP format value";
                            break;
                        }
                        String[] stringArray = dateTimeSeparatorPattern.split(string);
                        int n4 = stringArray.length;
                        if (n4 < 6 || n4 > 7) {
                            object = "SQL data type TIMESTAMP, expected 6 or 7 'parts', got " + n4;
                            break;
                        }
                        String string2 = stringArray[0] + "-" + stringArray[1] + "-" + stringArray[2] + " " + stringArray[3] + ":" + stringArray[4] + ":" + stringArray[5];
                        if (n4 == 7) {
                            string2 = string2 + "." + stringArray[6];
                        }
                        try {
                            this.insertStatement.setTimestamp(n, Timestamp.valueOf(string2));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            object = "SQL data type TIMESTAMP is illegal";
                        }
                        break;
                    }
                    case -16: 
                    case -15: 
                    case -9: {
                        this.insertStatement.setNString(n, string);
                        break;
                    }
                    case 2013: {
                        object = "TIME_WITH_TIMEZONE SQL type is not yet supported";
                        break;
                    }
                    case 2014: {
                        object = "TIMESTAMP_WITH_TIMEZONE SQL type is not yet supported";
                        break;
                    }
                    case 0: {
                        object = "NULL SQL type is not supported: NULL value was expected";
                        break;
                    }
                    default: {
                        object = "unsupported SQL data type " + Value.getSQLTypeName((int)n2);
                    }
                }
                if (object == null) continue;
                throw new IOException("Parsing error for column '" + this.columns[n - 1] + "': " + (String)object + ", value = " + string + ", CSV record = " + String.valueOf(cSVRecord));
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Throwable throwable) {
                throw new IOException("Internal error parsing record: '" + String.valueOf(cSVRecord) + "'", throwable);
            }
        }
        if (n != this.columns.length) {
            throw new IOException("End of record not found instead of column '" + this.columns[n] + "' value, record = " + String.valueOf(cSVRecord));
        }
    }
}

