/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.gyro;

import com.iizix.LocaleInfo;
import com.iizix.NotFoundException;
import com.iizix.SessionInfo;
import com.iizix.Size;
import com.iizix.Worker;
import com.iizix.api.IPrivateStorage;
import com.iizix.device.DeviceParameter;
import com.iizix.device.flash.IFlashlight;
import com.iizix.device.settings.IOpenNativeSettings;
import com.iizix.geo.ILocationService;
import com.iizix.gyro.HistoryRequest;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IClientSessionDisposeListener;
import com.iizix.gyro.IFocusEngine;
import com.iizix.gyro.ILockState;
import com.iizix.gyro.IMessageBox;
import com.iizix.gyro.IRuntimeImageCache;
import com.iizix.gyro.IScreenOrientationListener;
import com.iizix.gyro.IScreenSizeListener;
import com.iizix.gyro.IToaster;
import com.iizix.gyro.IUIPanelAnimation;
import com.iizix.gyro.IWindowCloseListener;
import com.iizix.gyro.ScreenOrientation;
import com.iizix.gyro.WindowOptions;
import com.iizix.gyro.history.IAppHistoryEntry;
import com.iizix.prop.EnvProps;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IPropMgrInfoProvider;
import com.iizix.prop.ui.IUIFocusComp;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.UIContextMenu;
import com.iizix.prop.ui.UIPanelBase;
import com.iizix.prop.vs.VirtualSpace;
import com.iizix.text.ILocaleString;
import com.iizix.text.KString;
import com.iizix.text.util.PrettyLocaledTexts;
import com.iizix.timeout.ITimerEngine;

public interface IClientSessionGyro
extends IPrivateStorage,
IMessageBox,
IRuntimeImageCache,
IToaster,
ILocaleString {
    public static final String STORAGE_NAME = "Ciz-" + IClientSessionGyro.class.getCanonicalName();

    public static IClientSessionGyro getSessionInstance() {
        return IClientSessionGyro.getSessionInstance(null);
    }

    public static IClientSessionGyro getSessionInstance(SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            sessionInfo = SessionInfo.getSessionInfo();
        }
        return sessionInfo != null ? sessionInfo.getPrivateData(STORAGE_NAME, IClientSessionGyro.class) : null;
    }

    public boolean addDisposeListener(IClientSessionDisposeListener var1);

    public boolean removeDisposeListener(IClientSessionDisposeListener var1);

    public boolean dispose();

    public boolean isDisposed();

    public IAppSessionGyro getAppSessionGyro();

    public SessionInfo getClientSessionInfo();

    public IFocusEngine getUIFocusEngine();

    public ITimerEngine getClientTimerEngine();

    public boolean synchronizeCurrentFocusWithVS();

    public void setPseudoActionFocusToVS(IUIFocusComp var1, IGProp<?> var2);

    public Worker getClientWorker();

    @Override
    public IPropMgrInfoProvider getKStringInfoProvider();

    public EnvProps getEnvironment();

    default public IOpenNativeSettings getOpenNativeSettings() throws NotFoundException {
        return IOpenNativeSettings.DEFAULT_IMPL;
    }

    public IFlashlight getFlashlight() throws NotFoundException;

    public ILocationService getLocationService();

    public PrettyLocaledTexts getPrettyLocaledTexts();

    public LocaleInfo setLocale(LocaleInfo var1);

    public String getLanguageCode();

    public UIPanelBase getTopmostPanel();

    public UIPanelBase[] getVirtualizedPanels();

    public UIPanelBase[] getMatchingPanels(VirtualSpace var1);

    public GProp<?> getVirtualizedPropFromReference(String var1);

    public String getClientContextMenuReference(UIContextMenu var1, boolean var2);

    public ILockState requestUILock();

    default public boolean isUILocked() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Client session is disposed of");
        }
        return this.getAppSessionGyro().isUILocked();
    }

    public void setBusy(KString var1, int var2, int var3);

    public void setReady();

    public boolean setReady(Runnable var1);

    public UIComp getCurrentFocus();

    public int getNextPanelAnimation();

    public int setNextPanelAnimation(int var1);

    default public int setNextPanelAnimation(IUIPanelAnimation.Type type, IUIPanelAnimation.Direction direction, IUIPanelAnimation.Speed speed) {
        return this.setNextPanelAnimation(IUIPanelAnimation.getAnimationValue(type, direction, speed));
    }

    public void enterClientLock(boolean var1);

    public void exitClientLock();

    public HistoryRequest getHistoryRequest();

    public IAppHistoryEntry addHistoryEntry();

    public int getScreenWidth();

    public int getScreenHeight();

    public Size getScreenSize();

    public boolean addScreenSizeListener(IScreenSizeListener var1);

    public boolean removeScreenSizeListener(IScreenSizeListener var1);

    public boolean isScreenOrientationLockSupported();

    public boolean addScreenOrientationListener(IScreenOrientationListener var1);

    public boolean removeScreenOrientationListener(IScreenOrientationListener var1);

    public ScreenOrientation getScreenOrientation();

    public boolean setScreenOrientation(ScreenOrientation var1);

    public boolean unlockScreenOrientation();

    public void sendStat(String var1, DeviceParameter ... var2);

    public boolean saveDeviceParameters(DeviceParameter ... var1);

    public boolean getDeviceParameters(DeviceParameter ... var1);

    default public boolean triggerRemoteOpenWindow(String string, String string2) {
        return this.triggerRemoteOpenWindow(string, string2, null, null);
    }

    @Deprecated
    default public boolean triggerRemoteOpenWindow(String string, String string2, Runnable runnable) {
        return runnable == null ? this.triggerRemoteOpenWindow(string, string2, null, null) : this.triggerRemoteOpenWindow(string, string2, null, bl -> runnable.run());
    }

    public boolean triggerRemoteOpenWindow(String var1, String var2, WindowOptions var3, IWindowCloseListener var4);

    default public boolean triggerRemoteCloseWindow() {
        return this.triggerRemoteCloseWindow(false);
    }

    public boolean triggerRemoteCloseWindow(boolean var1);

    public void restartRemoteClient();
}

