/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.NumberValue;
import java.text.ParseException;

public class ShortValue
extends NumberValue<Short> {
    private static final Short a = 0;

    @Override
    public final Value.Type getValueType() {
        return Value.Type.Short;
    }

    @Override
    public Class<Short> getValueClass() {
        return Short.class;
    }

    @Override
    public String getDescription() {
        return "Short value (range -32768 to 32767)";
    }

    @Override
    public Short createDefault() {
        return a;
    }

    @Override
    public Short parse(String string) throws NumberFormatException {
        return Short.valueOf(string);
    }

    @Override
    public Short convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            double d2 = number.doubleValue();
            if (d2 > 32767.0 || d2 < -32768.0) {
                throw new ArithmeticException("Value out of Short range: " + String.valueOf(object));
            }
            return number.shortValue();
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            if (l2 >= -32768L && l2 <= 32767L) {
                return (short)l2;
            }
            throw new ArithmeticException("Value range error when converting to Short for type " + object.getClass().getCanonicalName() + ": value = " + String.valueOf(object));
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return Short.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }
}

