/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.util;

import com.iizix.ILog;
import com.iizix.codepage.CodepageMapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class XFile {
    public static final String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String[] dayNames = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private String a;
    private BufferedInputStream a;
    private DataInputStream a;
    private byte[] a;
    private int a;

    public static byte[] loadFile(InputStream inputStream) throws IOException {
        return XFile.loadFile(new XFile(inputStream, "InputStream"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadFile(XFile xFile) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try {
                try {
                    while (true) {
                        byteArrayOutputStream.write(xFile.readByte());
                    }
                }
                catch (EOFException eOFException) {
                    return byteArrayOutputStream.toByteArray();
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ILog.SEVERE(XFile.class, "Out of memory loading file " + xFile.getFileName(), outOfMemoryError);
                xFile.close();
                return null;
            }
            catch (EOFException eOFException) {
                xFile.close();
                return byteArrayOutputStream.toByteArray();
            }
        }
        finally {
            xFile.close();
        }
    }

    public static byte[] loadFile(String string) throws IOException {
        return XFile.loadFile(new File(string));
    }

    public static byte[] loadFile(File file) throws IOException {
        try {
            if (!file.isFile()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            return Files.readAllBytes(file.toPath());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ILog.SEVERE(XFile.class, "Out of memory loading file " + String.valueOf(file), outOfMemoryError);
            return null;
        }
    }

    public static byte[] loadFile(JarFile jarFile, JarEntry jarEntry) throws IOException {
        FilterInputStream filterInputStream = null;
        try {
            long l2 = jarEntry.getSize();
            if (l2 > Integer.MAX_VALUE || l2 < 0L) {
                throw new IOException(jarFile.getName() + "!" + jarEntry.getName() + ": size invalid: " + l2);
            }
            byte[] byArray = new byte[(int)l2];
            filterInputStream = new DataInputStream(new BufferedInputStream(jarFile.getInputStream(jarEntry)));
            ((DataInputStream)filterInputStream).readFully(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ILog.SEVERE(XFile.class, "Out of memory loading file " + jarFile.getName() + "!" + jarEntry.getName(), outOfMemoryError);
            return null;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public XFile(String string) throws IOException {
        this.a(string);
    }

    public XFile(String string, boolean bl) throws IOException {
        String string2 = XFile.findFileInPath(string, bl);
        this.a(string2 != null ? string2 : string);
    }

    public XFile(String string, XFile xFile) throws IOException {
        this.a(string, xFile.a);
    }

    public XFile(String string, String string2) throws IOException {
        this.a(string, string2);
    }

    public XFile(XFile xFile, int n2) throws IOException {
        this(xFile.a);
        this.a.skipBytes(n2);
    }

    public XFile(byte[] byArray) {
        this(byArray, "MemoryFile");
    }

    public XFile(byte[] byArray, String string) {
        this.a = string;
        this.a = byArray;
        this.a();
    }

    public XFile(byte[] byArray, XFile xFile) {
        this.a = xFile.a;
        this.a = byArray;
        this.a();
    }

    private final void a() {
        this.a = new DataInputStream(new ByteArrayInputStream(this.a));
    }

    public XFile(InputStream inputStream) {
        this(inputStream, "InputStream");
    }

    public XFile(InputStream inputStream, String string) {
        this.a = string;
        this.a = new BufferedInputStream(inputStream);
        this.a = new DataInputStream(this.a);
    }

    public XFile(File file) throws FileNotFoundException {
        this.a = file.getPath();
        this.a = new BufferedInputStream(new FileInputStream(file));
        this.a = new DataInputStream(this.a);
    }

    public synchronized void close() {
        if (this.a != null) {
            try {
                this.a.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.a = null;
        }
        if (this.a != null) {
            try {
                this.a.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.a = null;
        }
    }

    private void a(String string) throws IOException {
        this.a = string;
        this.a = new BufferedInputStream(new FileInputStream(string));
        this.a = new DataInputStream(this.a);
    }

    private void a(String string, String string2) throws IOException {
        this.a(XFile.getFileNameFromAnother(string, string2));
    }

    public static String getFileNameFromAnother(String string, String string2) {
        if ((string = string.replace('\\', '/')).indexOf(58) >= 0 || string.length() > 0 && string.charAt(0) == '/') {
            return string;
        }
        int n2 = (string2 = string2.replace('\\', '/')).lastIndexOf(47);
        return n2 < 0 ? string : string2.substring(0, n2 + 1) + string;
    }

    public String getFileNameFromAnother(String string) {
        return XFile.getFileNameFromAnother(string, this.a);
    }

    public byte[] read(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        if (this.a != null) {
            if (this.a + n2 > this.a.length) {
                throw new EOFException();
            }
            System.arraycopy(this.a, this.a, byArray, 0, n2);
            this.a += n2;
        } else {
            this.a.readFully(byArray);
        }
        return byArray;
    }

    public String readString() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        if (this.a != null) {
            while (true) {
                byte by;
                if (this.a >= this.a.length) {
                    throw new EOFException();
                }
                if ((by = this.a[this.a++]) != 0) {
                    byteArrayOutputStream.write(by);
                    continue;
                }
                break;
            }
        } else {
            byte by;
            while ((by = this.a.readByte()) != 0) {
                byteArrayOutputStream.write(by);
            }
        }
        return CodepageMapper.convertAnsiToString(byteArrayOutputStream.toByteArray());
    }

    public String readString(int n2) throws IOException {
        byte[] byArray = this.read(n2);
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] == 0) {
                return n3 == 0 ? "" : CodepageMapper.convertAnsiToString(byArray, 0, n3);
            }
            ++n3;
        }
        return CodepageMapper.convertAnsiToString(byArray);
    }

    public String readOEMString() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        if (this.a != null) {
            while (true) {
                byte by;
                if (this.a >= this.a.length) {
                    throw new EOFException();
                }
                if ((by = this.a[this.a++]) != 0) {
                    byteArrayOutputStream.write(by);
                    continue;
                }
                break;
            }
        } else {
            byte by;
            while ((by = this.a.readByte()) != 0) {
                byteArrayOutputStream.write(by);
            }
        }
        return CodepageMapper.convertASCIIToString(byteArrayOutputStream.toByteArray());
    }

    public String readOEMString(int n2) throws IOException {
        byte[] byArray = this.read(n2);
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] == 0) {
                return n3 == 0 ? "" : CodepageMapper.convertASCIIToString(byArray, 0, n3);
            }
            ++n3;
        }
        return CodepageMapper.convertASCIIToString(byArray);
    }

    public String readUnicodeString(int n2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.readIntelUShort();
            if (n4 == 0) {
                this.skipBytes(2 * (n2 - n3 - 1));
                break;
            }
            stringBuilder.append((char)n4);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public String readUnicodeString() throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n2 = this.readIntelUShort()) != 0) {
            stringBuilder.append((char)n2);
        }
        return stringBuilder.toString();
    }

    public String readOEMBytes(int n2) throws IOException {
        return CodepageMapper.convertASCIIToString(this.read(n2));
    }

    public String readUnicodeChars(int n2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        while (n3 < n2) {
            stringBuilder.append((char)this.readIntelUShort());
            ++n3;
        }
        return stringBuilder.toString();
    }

    public int readByte() throws IOException {
        if (this.a != null) {
            if (this.a >= this.a.length) {
                throw new EOFException();
            }
            return this.a[this.a++] & 0xFF;
        }
        return this.a.readUnsignedByte();
    }

    public int readIntelUShort() throws IOException {
        int n2;
        int n3;
        if (this.a != null) {
            if (this.a + 2 > this.a.length) {
                throw new EOFException();
            }
            n3 = this.a[this.a++] & 0xFF;
            n2 = this.a[this.a++] & 0xFF;
        } else {
            n3 = this.a.readUnsignedByte();
            n2 = this.a.readUnsignedByte();
        }
        return n2 << 8 | n3;
    }

    public int readIntelShort() throws IOException {
        int n2 = this.readIntelUShort();
        if (n2 > 32768) {
            n2 -= 65536;
        }
        return n2;
    }

    public int readIntelLong() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.a != null) {
            if (this.a + 4 > this.a.length) {
                throw new EOFException();
            }
            n5 = this.a[this.a++] & 0xFF;
            n4 = this.a[this.a++] & 0xFF;
            n3 = this.a[this.a++] & 0xFF;
            n2 = this.a[this.a++] & 0xFF;
        } else {
            n5 = this.a.readUnsignedByte();
            n4 = this.a.readUnsignedByte();
            n3 = this.a.readUnsignedByte();
            n2 = this.a.readUnsignedByte();
        }
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public double readIntelDouble() throws IOException {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        if (this.a != null) {
            if (this.a + 8 > this.a.length) {
                throw new EOFException();
            }
            l9 = this.a[this.a++] & 0xFF;
            l8 = this.a[this.a++] & 0xFF;
            l7 = this.a[this.a++] & 0xFF;
            l6 = this.a[this.a++] & 0xFF;
            l5 = this.a[this.a++] & 0xFF;
            l4 = this.a[this.a++] & 0xFF;
            l3 = this.a[this.a++] & 0xFF;
            l2 = this.a[this.a++] & 0xFF;
        } else {
            l9 = this.a.readUnsignedByte();
            l8 = this.a.readUnsignedByte();
            l7 = this.a.readUnsignedByte();
            l6 = this.a.readUnsignedByte();
            l5 = this.a.readUnsignedByte();
            l4 = this.a.readUnsignedByte();
            l3 = this.a.readUnsignedByte();
            l2 = this.a.readUnsignedByte();
        }
        long l10 = l2 << 56 | l3 << 48 | l4 << 40 | l5 << 32 | l6 << 24 | l7 << 16 | l8 << 8 | l9;
        return Double.longBitsToDouble(l10);
    }

    public void skipBytes(int n2) throws IOException {
        if (this.a != null) {
            if (this.a + n2 > this.a.length) {
                throw new EOFException();
            }
            this.a += n2;
        } else {
            this.a.skipBytes(n2);
        }
    }

    public int getRemainingSize() {
        if (this.a != null) {
            return Math.max(0, this.a.length - this.a);
        }
        if (this.a != null) {
            try {
                return this.a.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getFileName() {
        return this.a;
    }

    public Vector<String> readOEMStringVector(boolean bl) throws IOException {
        return this.readOEMStringVector(bl, true, true);
    }

    public Vector<String> readOEMStringVector(boolean bl, boolean bl2) throws IOException {
        return this.readOEMStringVector(bl, bl2, bl2);
    }

    /*
     * Unable to fully structure code
     */
    public Vector<String> readOEMStringVector(boolean var1_1, boolean var2_2, boolean var3_3) throws IOException {
        block19: {
            var4_4 = new Vector<String>();
            try {
                block20: {
                    block21: {
                        var5_5 = new ByteArrayOutputStream(1024);
                        try {
                            while (true) {
                                var6_7 = this.readByte();
                                while (var6_7 == 10 || var6_7 == 13) {
                                    var7_9 = CodepageMapper.convertASCIIToString(var5_5.toByteArray());
                                    if (var2_2 || var3_3) {
                                        var8_11 = var5_5.size();
                                        var9_13 = 0;
                                        if (var2_2) {
                                            while (var9_13 < var8_11 && var7_9.charAt(var9_13) == ' ') {
                                                ++var9_13;
                                            }
                                        }
                                        if (var3_3) {
                                            while (var9_13 < var8_11 && var7_9.charAt(var8_11 - 1) == ' ') {
                                                --var8_11;
                                            }
                                        }
                                        if (var9_13 > 0 || var8_11 < var7_9.length()) {
                                            var7_9 = var7_9.substring(var9_13, var8_11);
                                        }
                                    }
                                    if (!var7_9.isEmpty() || !var1_1) {
                                        var4_4.addElement(var7_9);
                                    }
                                    var5_5.reset();
                                    var8_11 = var6_7;
                                    var6_7 = this.readByte();
                                    if (var6_7 != 10 && var6_7 != 13 || 23 - var6_7 != var8_11) continue;
                                    var6_7 = this.readByte();
                                }
                                var5_5.write(var6_7);
                            }
                        }
                        catch (EOFException var6_8) {
                            if (var5_5.size() <= 0) break block19;
                            var7_10 = CodepageMapper.convertASCIIToString(var5_5.toByteArray());
                            if (!var2_2 && !var3_3) break block20;
                            var8_12 = var7_10.length();
                            var9_14 = 0;
                            if (!var2_2) break block21;
                            ** while (var9_14 < var8_12 && var7_10.charAt((int)var9_14) == ' ')
                        }
lbl-1000:
                        // 1 sources

                        {
                            ++var9_14;
                            continue;
                        }
                    }
                    if (var3_3) {
                        while (var9_14 < var8_12 && var7_10.charAt(var8_12 - 1) == ' ') {
                            --var8_12;
                        }
                    }
                    if (var9_14 > 0 || var8_12 < var7_10.length()) {
                        var7_10 = var7_10.substring(var9_14, var8_12);
                    }
                }
                if (!var7_10.isEmpty() || !var1_1) {
                    var4_4.addElement(var7_10);
                }
            }
            catch (IOException var5_6) {
                var4_4 = null;
            }
        }
        if (var4_4 != null) {
            var4_4.trimToSize();
        }
        return var4_4;
    }

    public synchronized byte[] readByteLine() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            byteArrayOutputStream = new ByteArrayOutputStream(128);
            try {
                while (true) {
                    int n2;
                    if ((n2 = this.readByte()) == 13) {
                        if (this.a != null) {
                            int n3 = this.a;
                            n2 = this.readByte();
                            if (n2 != 10) {
                                this.a = n3;
                            }
                            break;
                        }
                        this.a.mark(1);
                        try {
                            n2 = this.a.readByte();
                        }
                        catch (EOFException eOFException) {
                            break;
                        }
                        if (n2 != 10) {
                            this.a.reset();
                        }
                        break;
                    }
                    if (n2 != 10) {
                        byteArrayOutputStream.write(n2);
                        continue;
                    }
                    break;
                }
            }
            catch (EOFException eOFException) {
                if (byteArrayOutputStream.size() != 0) break block10;
                return null;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String readOEMLine() throws IOException {
        byte[] byArray = this.readByteLine();
        if (byArray == null) {
            return null;
        }
        return CodepageMapper.convertASCIIToString(byArray);
    }

    public String readAnsiLine() throws IOException {
        byte[] byArray = this.readByteLine();
        if (byArray == null) {
            return null;
        }
        return CodepageMapper.convertAnsiToString(byArray);
    }

    public String readISOLine() throws IOException {
        byte[] byArray = this.readByteLine();
        if (byArray == null) {
            return null;
        }
        return new String(byArray, StandardCharsets.ISO_8859_1);
    }

    public byte getMemoryDataByte() {
        return this.a[this.a];
    }

    private static void a(ArrayList<String> arrayList, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!new File(string2).isDirectory() || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
    }

    public static String findFileInPath(String string) {
        return XFile.findFileInPath(string, true);
    }

    public static String findFileInPath(String string, boolean bl) {
        if ((string = string.replace('\\', '/')).indexOf(47) != -1) {
            bl = false;
        }
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(".");
            String string2 = System.getProperty("java.home").replace('\\', '/');
            XFile.a(arrayList, string2);
            if (string2.endsWith("/jre")) {
                XFile.a(arrayList, string2 + "/bin");
                XFile.a(arrayList, string2 + "/../bin");
            } else if (string2.endsWith("/jre/bin")) {
                XFile.a(arrayList, string2 + "/../../bin");
            } else if (!string2.endsWith("/bin")) {
                XFile.a(arrayList, string2 + "/bin");
                XFile.a(arrayList, string2 + "/jre/bin");
            }
            XFile.a(arrayList, System.getProperty("java.class.path"));
            XFile.a(arrayList, System.getProperty("java.library.path"));
            for (String string3 : arrayList) {
                File file = new File(string3, string);
                if (!file.isFile()) continue;
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return file.getName();
                }
            }
        }
        return null;
    }

    public static String findFileInDirectory(String object, String string, boolean bl) {
        int n2 = 0;
        while ((n2 = ((String)object).indexOf(37)) >= 0) {
            String string2;
            int n3;
            block6: {
                n3 = ((String)object).indexOf(37, n2 + 1);
                if (n3 < 0) {
                    return null;
                }
                String string3 = ((String)object).substring(n2 + 1, n3);
                if (string3.isEmpty()) {
                    return null;
                }
                try {
                    string2 = System.getenv(string3);
                    if (string2 != null) break block6;
                    return null;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            object = ((String)object).substring(0, n2) + string2 + ((String)object).substring(n3 + 1);
        }
        return XFile.findFileInDirectory(new File((String)object), string, bl);
    }

    public static String findFileInDirectory(File file, String string, boolean bl) {
        if (!file.isDirectory()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            String string2;
            File file2;
            File[] fileArray2 = fileArray;
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                file2 = fileArray2[n3];
                if (file2.isFile() && (string.equals(string2 = file2.getName()) || !bl && string.equalsIgnoreCase(string2))) {
                    try {
                        return file2.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return file2.getAbsolutePath();
                    }
                }
                ++n3;
            }
            fileArray2 = fileArray;
            n2 = fileArray.length;
            n3 = 0;
            while (n3 < n2) {
                file2 = fileArray2[n3];
                if (file2.isDirectory() && (string2 = XFile.findFileInDirectory(file2, string, bl)) != null) {
                    return string2;
                }
                ++n3;
            }
        }
        return null;
    }

    public static int findFilesInDirectory(String object, ArrayList<String> arrayList, boolean bl) {
        int n2 = 0;
        while ((n2 = ((String)object).indexOf(37)) >= 0) {
            String string;
            int n3;
            block6: {
                n3 = ((String)object).indexOf(37, n2 + 1);
                if (n3 < 0) {
                    return 0;
                }
                String string2 = ((String)object).substring(n2 + 1, n3);
                if (string2.isEmpty()) {
                    return 0;
                }
                try {
                    string = System.getenv(string2);
                    if (string != null) break block6;
                    return 0;
                }
                catch (Throwable throwable) {
                    return 0;
                }
            }
            object = ((String)object).substring(0, n2) + string + ((String)object).substring(n3 + 1);
        }
        return XFile.findFilesInDirectory(new File((String)object), arrayList, bl);
    }

    public static int findFilesInDirectory(File file, ArrayList<String> arrayList, boolean bl) {
        int n2 = arrayList.size();
        int n3 = 0;
        for (String string : arrayList) {
            if (string.indexOf(47) < 0 && string.indexOf(92) < 0) continue;
            ++n3;
        }
        if (n3 == n2) {
            return n3;
        }
        if (!file.isDirectory() && !file.isHidden()) {
            return 0;
        }
        int n4 = 0;
        int n5 = arrayList.size();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File file2;
            File[] fileArray2 = fileArray;
            int n6 = fileArray.length;
            int n7 = 0;
            while (n7 < n6) {
                file2 = fileArray2[n7];
                if (file2.isFile() && !file2.isHidden()) {
                    String string = file2.getName();
                    int n8 = 0;
                    while (n8 < n5) {
                        String string2 = arrayList.get(n8);
                        if (string2.indexOf(47) < 0 && string2.indexOf(92) < 0 && (string2.equals(string) || !bl && string2.equalsIgnoreCase(string))) {
                            try {
                                string2 = file2.getCanonicalPath();
                            }
                            catch (IOException iOException) {
                                string2 = file2.getAbsolutePath();
                            }
                            arrayList.set(n8, string2);
                            if (++n4 + n3 == n2) {
                                return n4;
                            }
                        }
                        ++n8;
                    }
                }
                ++n7;
            }
            fileArray2 = fileArray;
            n6 = fileArray.length;
            n7 = 0;
            while (n7 < n6) {
                file2 = fileArray2[n7];
                if (file2.isDirectory() && (n4 += XFile.findFilesInDirectory(file2, arrayList, bl)) + n3 == n2) break;
                ++n7;
            }
        }
        return n4;
    }

    public long lastModified() {
        long l2 = 0L;
        try {
            l2 = new File(this.a).lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l2;
    }

    public static String getFileTimestamp(String string) {
        long l2 = 0L;
        try {
            l2 = new File(string).lastModified();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return XFile.getFileTimestamp(l2);
    }

    public String getFileTimestamp() {
        return XFile.getFileTimestamp(this.lastModified());
    }

    public static String getFileTimestamp(long l2) {
        Date date = new Date(l2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = calendar.get(5);
        int n3 = calendar.get(2);
        int n4 = calendar.get(1);
        int n5 = calendar.get(7);
        switch (n5) {
            case 1: {
                n5 = 6;
                break;
            }
            case 3: {
                n5 = 1;
                break;
            }
            case 4: {
                n5 = 2;
                break;
            }
            case 5: {
                n5 = 3;
                break;
            }
            case 6: {
                n5 = 4;
                break;
            }
            case 7: {
                n5 = 5;
                break;
            }
            default: {
                n5 = 0;
            }
        }
        char[] cArray = new char[]{(char)(48 + n4 / 1000), (char)(48 + n4 / 100 % 10), (char)(48 + n4 / 10 % 10), (char)(48 + n4 % 10)};
        String string = new String(cArray);
        int n6 = calendar.get(11);
        int n7 = calendar.get(12);
        int n8 = calendar.get(13);
        char[] cArray2 = new char[]{(char)(48 + n6 / 10), (char)(48 + n6 % 10)};
        char[] cArray3 = new char[]{(char)(48 + n7 / 10), (char)(48 + n7 % 10)};
        char[] cArray4 = new char[]{(char)(48 + n8 / 10), (char)(48 + n8 % 10)};
        String string2 = new String(cArray2);
        String string3 = new String(cArray3);
        String string4 = new String(cArray4);
        String string5 = n2 < 10 ? "  " : " ";
        return dayNames[n5] + " " + monthNames[n3] + string5 + n2 + " " + string2 + ":" + string3 + ":" + string4 + " " + string;
    }

    public static String getBaseName(String string) {
        int n2 = (string = string.replace('\\', '/')).lastIndexOf(47);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        if ((n2 = string.indexOf(58)) >= 0) {
            string = string.substring(n2 + 1);
        }
        if ((n2 = string.indexOf(46)) >= 0) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public static boolean isSameFile(String string, String string2) {
        return XFile.isSameFile(new File(string), new File(string2));
    }

    public static boolean isSameFile(File file, File file2) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return file.getPath().equals(file2.getPath());
    }

    public static String getRelativeFileName(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, FileNotFoundException {
        string = XFile.getFileNameFromAnother(string, string2);
        File file = new File(string);
        if (bl3 && !file.exists()) {
            throw new FileNotFoundException("File " + string + " is not found");
        }
        if (bl4 && !file.isFile()) {
            throw new FileNotFoundException("File " + string + " is not a file");
        }
        string = file.getCanonicalPath();
        File file2 = new File(string2);
        if (!file2.exists()) {
            throw new FileNotFoundException("File " + string2 + " is not found");
        }
        string2 = file2.getCanonicalPath();
        int n2 = string2.lastIndexOf(File.separatorChar);
        if (bl) {
            if (n2 < 0) {
                throw new IOException("Reference file " + string2 + " doesn't contain a directory separator (" + File.separatorChar + ")");
            }
            if (!string.toUpperCase().startsWith(string2.substring(0, n2 + 1).toUpperCase())) {
                return null;
            }
            if (bl2) {
                string = string.substring(n2 + 1);
            }
        } else if (bl2) {
            string = n2 >= 0 && string.toUpperCase().startsWith(string2.substring(0, n2 + 1).toUpperCase()) ? string.substring(n2 + 1) : XFile.getRelativeFileName(string, string2);
        }
        return string;
    }

    private static List<String> a(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file2 = file.getCanonicalFile();
        while (file2 != null) {
            arrayList.add(file2.getName());
            file2 = file2.getParentFile();
        }
        return arrayList;
    }

    private static String a(List<String> list, List<String> list2) {
        int n2 = list.size() - 1;
        int n3 = list2.size() - 1;
        while (n2 >= 0 && n3 >= 0 && list.get(n2).equals(list2.get(n3))) {
            --n2;
            --n3;
        }
        Object object = "";
        while (n2 >= 0) {
            object = (String)object + ".." + File.separator;
            --n2;
        }
        while (n3 >= 1) {
            object = (String)object + list2.get(n3) + File.separator;
            --n3;
        }
        object = (String)object + list2.get(n3);
        return object;
    }

    public static String getRelativePath(File file, File file2) throws IOException {
        return XFile.a(XFile.a(file), XFile.a(file2));
    }

    public static String getRelativeFileName(String string, String string2) {
        File file = new File(string2);
        if (file.isFile() && (file = file.getParentFile()) == null) {
            return string;
        }
        try {
            return XFile.getRelativePath(file, new File(string));
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static boolean listDirectory(String string, ArrayList<File> arrayList) {
        return XFile.listDirectory(new File(string), arrayList, false);
    }

    public static boolean listDirectory(String string, ArrayList<File> arrayList, boolean bl) {
        return XFile.listDirectory(new File(string), arrayList, bl);
    }

    public static boolean listDirectory(File file, ArrayList<File> arrayList) {
        return XFile.listDirectory(file, arrayList, false);
    }

    public static boolean listDirectory(File file, ArrayList<File> arrayList, boolean bl) {
        File[] fileArray;
        if (!file.isDirectory()) {
            return false;
        }
        if (bl) {
            arrayList.add(file);
        }
        if ((fileArray = file.listFiles()) == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                XFile.listDirectory(file2, arrayList, bl);
            } else {
                arrayList.add(file2);
            }
            ++n2;
        }
        return true;
    }

    public static boolean deleteFileAndChildren(File file) {
        File[] fileArray;
        boolean bl = true;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            File[] fileArray2 = fileArray;
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                File file2 = fileArray2[n3];
                bl &= XFile.deleteFileAndChildren(file2);
                ++n3;
            }
        }
        return bl & file.delete();
    }

    public static String getFileExtension(File file) {
        return XFile.getFileExtension(file.getName());
    }

    public static String getFileExtension(String string) {
        int n2 = Math.max(string.lastIndexOf(92), string.lastIndexOf(47));
        int n3 = string.lastIndexOf(46);
        if (n3 >= 0 && n3 > n2) {
            return string.substring(n3 + 1);
        }
        return null;
    }

    public static boolean hasFileExtension(File file, boolean bl, String ... stringArray) {
        return XFile.hasFileExtension(file.getName(), bl, stringArray);
    }

    public static boolean hasFileExtension(String string, boolean bl, String ... stringArray) {
        block6: {
            String string2 = XFile.getFileExtension(string);
            if (string2 == null) break block6;
            if (bl) {
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string3 = stringArray2[n3];
                    if (string3.equals(string2)) {
                        return true;
                    }
                    ++n3;
                }
            } else {
                String[] stringArray3 = stringArray;
                int n4 = stringArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    String string4 = stringArray3[n5];
                    if (string4.equalsIgnoreCase(string2)) {
                        return true;
                    }
                    ++n5;
                }
            }
        }
        return false;
    }

    public static boolean isJarOrZipFile(String string) {
        return XFile.hasFileExtension(string, false, "jar", "zip");
    }

    public static boolean isJarOrZipFile(File file) {
        return XFile.hasFileExtension(file, false, "jar", "zip");
    }
}

