/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.urn;

import com.iizix.ILog;
import com.iizix.urn.IURNProvider;
import com.iizix.urn.NID;
import com.iizix.urn.NIDException;
import com.iizix.urn.URN;
import com.iizix.urn.URNException;
import com.iizix.urn.UnknownNIDException;
import com.iizix.urn.svg.SVG_URNFactory;
import com.iizix.urn.url.URL_URNFactory;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class URNFactory {
    private static URNFactory a;
    private final Map<NID, IURNProvider> a;
    private final ServiceLoader<IURNProvider> a = ServiceLoader.loadInstalled(IURNProvider.class);

    static {
        URNFactory uRNFactory = URNFactory.getInstance();
        SVG_URNFactory.initialize(uRNFactory);
        URL_URNFactory.initialize(uRNFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URNFactory getInstance() {
        URNFactory uRNFactory = a;
        if (uRNFactory != null) return uRNFactory;
        Class<URNFactory> clazz = URNFactory.class;
        synchronized (URNFactory.class) {
            uRNFactory = a;
            if (uRNFactory != null) return uRNFactory;
            a = new URNFactory();
            return a;
        }
    }

    private URNFactory() {
    }

    public boolean register(IURNProvider iURNProvider) {
        NID nID = iURNProvider.getNID();
        IURNProvider iURNProvider2 = this.a.put(nID, iURNProvider);
        if (iURNProvider2 == null) {
            return true;
        }
        if (iURNProvider2 == iURNProvider) {
            return false;
        }
        String string = "Cannot register URN provider, NID " + String.valueOf((Object)nID) + " is already registered by another provider";
        ILog.SEVERE(this.getClass(), string, (Object)iURNProvider);
        throw new RuntimeException(string);
    }

    public IURNProvider getProvider(NID nID) {
        IURNProvider iURNProvider = (IURNProvider)this.a.get((Object)nID);
        if (iURNProvider == null) {
            Iterator iterator = ((ServiceLoader)((Object)this.a)).iterator();
            while (iterator.hasNext()) {
                IURNProvider iURNProvider2 = (IURNProvider)iterator.next();
                if (iURNProvider2.getNID() != nID) continue;
                iURNProvider = iURNProvider2;
                this.a.put(nID, iURNProvider);
            }
        }
        return iURNProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URN from(String string) throws URNException {
        int n2 = string.indexOf(58);
        if (n2 != 3 || !string.substring(0, 3).equalsIgnoreCase("urn")) {
            throw new URNException("Illegal URN specification", string);
        }
        n2 = string.indexOf(58, 4);
        if (n2 < 0) {
            throw new URNException("Illegal URN specification; missing Naming ID", string);
        }
        String string2 = string.substring(4, n2);
        NID nID = NID.from(string2);
        if (nID == null) {
            throw new UnknownNIDException(string, string2);
        }
        IURNProvider iURNProvider = this.getProvider(nID);
        if (iURNProvider == null) {
            throw new NIDException("Provider not found", string, string2);
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = string.substring(n2 + 1);
        if ((n2 = string6.indexOf(35)) >= 0) {
            string5 = URLDecoder.decode(string6.substring(n2 + 1), StandardCharsets.UTF_8);
            string6 = string6.substring(0, n2);
        }
        if ((n2 = string6.indexOf("?+")) < 0) {
            int n3 = string6.indexOf("?=");
            if (n3 < 0) {
                string3 = URLDecoder.decode(string6.substring(0, n2), StandardCharsets.UTF_8);
            } else {
                if (n3 <= n2) throw new URNException("Illegal URN specification; required '?+' must preceed query response '?='", string);
                string3 = URLDecoder.decode(string6.substring(0, n3), StandardCharsets.UTF_8);
                string4 = URLDecoder.decode(string6.substring(n3 + 2, n2), StandardCharsets.UTF_8);
            }
        } else {
            n2 = string6.indexOf("?=");
            if (n2 >= 0) {
                string4 = URLDecoder.decode(string6.substring(n2 + 2), StandardCharsets.UTF_8);
            }
        }
        if (string5 == null) return iURNProvider.parse(string, string6, string3, string4, string5);
        if (string5.indexOf(63) >= 0) {
            throw new URNException("Illegal URN specification: invalid '?' part", string);
        }
        string5 = URLDecoder.decode(string5, StandardCharsets.UTF_8);
        return iURNProvider.parse(string, string6, string3, string4, string5);
    }
}

