/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.Utilities;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.PropValidateException;

public class StringProp
extends GProp<String> {
    private static final Class<?>[] a = new Class[]{String.class, StringBuilder.class, StringBuffer.class, char[].class, byte[].class, Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class, Character.class};

    protected StringProp() {
    }

    public StringProp(Atom atom) {
        super(atom);
    }

    public StringProp(Atom atom, String string) throws PropValidateException {
        super(atom);
        this.setPropValue(string);
    }

    @Override
    public StringProp clone() {
        try {
            return (StringProp)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    public boolean setPropValue(String string) throws PropValidateException {
        try {
            return super.setPropValue(string);
        }
        catch (PropException propException) {
            if (propException instanceof PropValidateException) {
                throw (PropValidateException)propException;
            }
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof String)) {
            throw new PropTypeException(this, "newValue not a String");
        }
    }

    public String getString() {
        return (String)this.getPropValue();
    }

    public String getString(String string) {
        String string2 = (String)this.getPropValue();
        return string2 == null ? string : string2;
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        String string = (String)object;
        sendTransaction.appendString(string == null ? "" : string);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        return this.setPropValue((Object)readTransaction.readString(), propMgr);
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        String string = (String)object;
        switch (n2) {
            case 1: {
                return new StringBuilder(string);
            }
            case 2: {
                return new StringBuffer(string);
            }
            case 3: {
                return string.toCharArray();
            }
            case 4: {
                return Utilities.getBytes(string);
            }
            case 5: {
                return Long.valueOf(string);
            }
            case 6: {
                return Integer.valueOf(string);
            }
            case 7: {
                return Short.valueOf(string);
            }
            case 8: {
                return Byte.valueOf(string);
            }
            case 9: {
                return Double.valueOf(string);
            }
            case 10: {
                return Float.valueOf(string);
            }
            case 11: {
                int n3 = string.length();
                if (n3 != 1) {
                    throw new IllegalArgumentException("string length != 1: " + n3);
                }
                return Character.valueOf(string.charAt(0));
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return ((StringBuilder)object).toString();
            }
            case 2: {
                return ((StringBuffer)object).toString();
            }
            case 3: {
                return new String((char[])object);
            }
            case 4: {
                return Utilities.createString((byte[])object);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return object.toString();
            }
            case 11: {
                return ((Character)object).toString();
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }
}

