/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.NumberValue;
import java.text.ParseException;

public class IntegerValue
extends NumberValue<Integer> {
    private static final Integer a = 0;

    @Override
    public final Value.Type getValueType() {
        return Value.Type.Integer;
    }

    @Override
    public Class<Integer> getValueClass() {
        return Integer.class;
    }

    @Override
    public String getDescription() {
        return "Integer value (32 bit)";
    }

    @Override
    public Integer createDefault() {
        return a;
    }

    @Override
    public Integer parse(String string) throws NumberFormatException {
        return Integer.valueOf(string);
    }

    @Override
    public Integer convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            double d2 = number.doubleValue();
            if (d2 > 2.147483647E9 || d2 < -2.147483648E9) {
                throw new ArithmeticException("Value out of Integer range: " + String.valueOf(object));
            }
            return number.intValue();
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            if (l2 >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE) {
                return (int)l2;
            }
            throw new ArithmeticException("Value range error when converting to Integer for type " + object.getClass().getCanonicalName() + ": value = " + String.valueOf(object));
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }
}

