/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.vs;

import com.iizix.ILog;
import com.iizix.event.GEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropReference;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropReference;
import com.iizix.prop.PropValidateException;
import com.iizix.prop.vs.IVSColumnListener;
import com.iizix.prop.vs.IVSTableColumnReferenceOwner;
import com.iizix.prop.vs.VSColumnHeader;
import com.iizix.prop.vs.VSReference;
import com.iizix.prop.vs.VSRelativeReference;
import com.iizix.prop.vs.VSTable;
import com.iizix.prop.vs.VSTableReference;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class VSTableColumnReference
extends VSRelativeReference<VSColumnHeader> {
    private IVSColumnListener a;

    public VSTableColumnReference() {
    }

    public VSTableColumnReference(Atom atom) {
        super(atom);
    }

    public VSTableColumnReference(Atom atom, String string) {
        super(atom, string);
    }

    @Override
    public VSTableColumnReference clone() {
        VSTableColumnReference vSTableColumnReference = (VSTableColumnReference)super.clone();
        vSTableColumnReference.a = null;
        return vSTableColumnReference;
    }

    public String getColumnName() {
        return this.getString();
    }

    public int getColumnIndex() {
        VSColumnHeader vSColumnHeader = this.getVSColumnHeader();
        return vSColumnHeader != null ? vSColumnHeader.getColumnIndex() : -1;
    }

    @Override
    public void resolve(boolean bl, GEvent gEvent) {
        PropReference propReference = this.reference;
        if (propReference == null) {
            this.createReference(gEvent);
        } else {
            if (bl) {
                VSTable vSTable;
                PropCnr propCnr = this.getParent();
                VSTable vSTable2 = vSTable = propCnr instanceof IVSTableColumnReferenceOwner ? ((IVSTableColumnReferenceOwner)((Object)propCnr)).getVSTable(this) : null;
                if (vSTable == null) {
                    this.setInvalid();
                    return;
                }
            }
            this.resolve(propReference, bl, gEvent);
        }
    }

    @Override
    public String getReference() {
        VSTable vSTable;
        String string = this.getString();
        if (string == null) {
            return null;
        }
        PropReference propReference = this.reference;
        if (propReference != null) {
            return propReference.getName();
        }
        PropCnr propCnr = this.getParent();
        VSTable vSTable2 = vSTable = propCnr instanceof IVSTableColumnReferenceOwner ? ((IVSTableColumnReferenceOwner)((Object)propCnr)).getVSTable(this) : null;
        if (vSTable == null) {
            return "???/" + string;
        }
        return vSTable.getReferencePropName() + "/$header/" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onVSReferenceChanged(GEvent gEvent) {
        PropReference propReference;
        VSTable vSTable;
        if (!(gEvent.getSource() instanceof VSTableReference)) {
            return;
        }
        PropCnr propCnr = this.getParent();
        if (propCnr == null) {
            this.setInvalid();
            return;
        }
        VSTable vSTable2 = vSTable = propCnr instanceof IVSTableColumnReferenceOwner ? ((IVSTableColumnReferenceOwner)((Object)propCnr)).getVSTable(this) : null;
        if (vSTable == null) {
            this.setInvalid();
            return;
        }
        String string = this.getString();
        if (string == null) {
            this.vsRefBase = null;
            this.clearError();
            return;
        }
        VSTableColumnReference vSTableColumnReference = this;
        synchronized (vSTableColumnReference) {
            propReference = this.reference;
            if (propReference != null) {
                this.vsRefBase = vSTable.getReferencePropName() + "/$header/";
                propReference.setName(this.vsRefBase + string);
            }
        }
        if (propReference == null) {
            this.createReference(gEvent);
        } else {
            this.resolve(propReference, false, gEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setInvalid() {
        String string;
        VSTableColumnReference vSTableColumnReference = this;
        synchronized (vSTableColumnReference) {
            this.vsRefBase = null;
            string = this.getString();
        }
        if (string == null) {
            this.clearError();
        } else {
            this.addError("Invalid VS Table reference");
        }
        this.targetChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createReference(GEvent gEvent) {
        String string = this.getString();
        if (string == null) {
            this.clearError();
            this.targetChanged(null);
        } else if (this.isPropReferenceTreeValid()) {
            VSTable vSTable;
            VSReference vSReference = this.getVSReference(this.getPropAtom());
            if (vSReference == null || !vSReference.isValid()) {
                this.setInvalid();
                return;
            }
            PropCnr propCnr = this.getParent();
            VSTable vSTable2 = vSTable = propCnr instanceof IVSTableColumnReferenceOwner ? ((IVSTableColumnReferenceOwner)((Object)propCnr)).getVSTable(this) : null;
            if (vSTable != null) {
                PropReference propReference;
                VSTableColumnReference vSTableColumnReference = this;
                synchronized (vSTableColumnReference) {
                    propReference = this.reference;
                    if (propReference == null) {
                        this.vsRefBase = vSTable.getReferencePropName() + "/$header/";
                        propReference = this.reference = new PropReference(this, this.vsRefBase + string, null, this);
                    }
                }
                this.resolve(propReference, false, gEvent);
            }
        }
    }

    @Override
    public void onReferenceEvent(PropReference propReference, IPropReference.ReferenceChangeEvent referenceChangeEvent, GEvent gEvent) {
        String string = propReference.getName();
        switch (referenceChangeEvent) {
            case FOUND: {
                this.clearError();
                this.targetChanged(propReference.getProperty());
                break;
            }
            case FOUND_WRONG_CLASS: {
                this.addError("Invalid reference '" + string + "' type: must be VS Column Header");
                this.targetChanged(null);
                break;
            }
            case BROKEN: {
                this.addError("Reference '" + string + "' not found");
                this.targetChanged(null);
                break;
            }
            case RENAMED: 
            case MOVED: {
                try {
                    int n2 = string.lastIndexOf(47);
                    assert (n2 >= 0) : "Invalid table column reference: " + string;
                    this.clearError();
                    this.setPropValue(string.substring(n2 + 1));
                }
                catch (PropValidateException propValidateException) {
                    ILog.SEVERE(this.getClass(), "onReferenceEvent.setPropValue(referenceName)", propValidateException);
                }
                break;
            }
            case DISPOSED: {
                this.addError("Reference '" + string + "' not found, disposed");
                this.targetChanged(null);
            }
        }
    }

    public VSColumnHeader getVSColumnHeader() {
        GProp<?> gProp;
        PropReference propReference = this.reference;
        if (propReference != null && (gProp = propReference.getProperty()) != null && !gProp.isDisposed() && this.isReferenceValid(gProp)) {
            return (VSColumnHeader)gProp;
        }
        return null;
    }

    @Override
    public boolean isReferenceValid(GProp<?> gProp) {
        PropCnr propCnr;
        if (gProp instanceof VSColumnHeader && (propCnr = this.getParent()) instanceof IVSTableColumnReferenceOwner) {
            VSTable vSTable = ((IVSTableColumnReferenceOwner)((Object)propCnr)).getVSTable(this);
            VSTable vSTable2 = ((VSColumnHeader)gProp).getTable();
            if (vSTable2 == vSTable) {
                return true;
            }
            if (vSTable != null && vSTable2 != null) {
                String string = vSTable.getReferencePropName();
                String string2 = vSTable2.getReferencePropName();
                return string.equals(string2);
            }
        }
        return false;
    }

    @Override
    public IPropReference.IRefType getReferenceType() {
        return IPropReference.RefType.VSTableColumn;
    }

    @Override
    public Class<? extends GProp<?>> getPropertyClass() {
        return VSColumnHeader.class;
    }

    protected IVSColumnListener getCurrentListener() {
        return this.a;
    }

    @Override
    protected void onResolved(VSColumnHeader vSColumnHeader) {
        PropCnr propCnr = this.getParent();
        if (propCnr instanceof IVSColumnListener) {
            IVSColumnListener iVSColumnListener;
            this.a = iVSColumnListener = (IVSColumnListener)((Object)propCnr);
            vSColumnHeader.addListener(iVSColumnListener);
            iVSColumnListener.onResolved(this, vSColumnHeader);
        }
    }

    @Override
    protected void onRemoved(VSColumnHeader vSColumnHeader) {
        IVSColumnListener iVSColumnListener = this.a;
        if (iVSColumnListener != null) {
            vSColumnHeader.removeListener(iVSColumnListener);
            this.a = null;
            iVSColumnListener.onBroken(this, vSColumnHeader);
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",currentListener=" + String.valueOf(this.a);
    }
}

