/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.prop.Atom;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.SSLCommProps;

public class SocketCommProps
extends PropCnr {
    private transient String a;

    public SocketCommProps() {
    }

    public SocketCommProps(Atom atom) {
        super(atom);
    }

    @Override
    public SocketCommProps clone() {
        try {
            SocketCommProps socketCommProps = (SocketCommProps)super.clone();
            socketCommProps.a = null;
            return socketCommProps;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public void setVerbose(boolean bl) {
        this.setBool("verbose", bl);
    }

    public boolean isVerbose() {
        return this.getBool("verbose");
    }

    public String getHost() {
        return this.getString(Atom.HOST);
    }

    public int getPort() {
        return this.getInt(Atom.PORT);
    }

    public String getBindAddress() {
        return this.getString(Atom.BIND);
    }

    public boolean isSecure() {
        return this.getBool(Atom.SSL);
    }

    public void setSecure(boolean bl) {
        this.setBool(Atom.SSL, bl);
    }

    public String getProxyHost() {
        return this.getString(Atom.PROXYHOST);
    }

    public int getProxyPort() {
        return this.getInt(Atom.PROXYPORT);
    }

    public int getProxyType() {
        return this.getInt(Atom.PROXYTYPE);
    }

    public boolean useWebSocket() {
        return this.getBool(Atom.WEBSOCKET);
    }

    public String getProxyUser() {
        return this.getString(Atom.USER);
    }

    public String getProxyPW() {
        return this.a;
    }

    public void setHost(String string) {
        if (string == null) {
            throw new NullPointerException("host = null");
        }
        this.setString(Atom.HOST, string);
    }

    public void setPort(int n2) {
        if (n2 < 1 || n2 > 65535) {
            throw new IllegalArgumentException("port not 1-65535: " + n2);
        }
        this.setInt(Atom.PORT, n2);
    }

    public void setBindAddress(String string) {
        this.setString(Atom.BIND, string);
    }

    public void setSecureProps(SSLCommProps sSLCommProps) throws PropException {
        Atom atom = Atom.get("SSLProps");
        if (sSLCommProps == null) {
            this.removeProp(atom);
        } else {
            if (!atom.equals(sSLCommProps.getPropAtom())) {
                sSLCommProps.a(atom);
            }
            this.setProp(sSLCommProps);
        }
    }

    public SSLCommProps getSecureProps() throws PropException {
        return this.getProp("SSLProps", SSLCommProps.class);
    }

    public SSLCommProps createSecureProps() throws PropException {
        Atom atom = Atom.get("SSLProps");
        SSLCommProps sSLCommProps = this.getProp(atom, SSLCommProps.class);
        if (sSLCommProps == null) {
            sSLCommProps = new SSLCommProps(atom);
            this.addProp(sSLCommProps);
        }
        return sSLCommProps;
    }

    public void setProxyHost(String string) {
        this.setString(Atom.PROXYHOST, string);
    }

    public void setProxyPort(int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("port range 0-65535: " + n2);
        }
        this.setInt(Atom.PROXYPORT, n2);
    }

    public void setProxyType(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("proxyType not 0-2: " + n2);
        }
        this.setInt(Atom.PROXYTYPE, n2);
    }

    public void setWebSocket(boolean bl) {
        this.setBool(Atom.WEBSOCKET, bl);
    }

    public void setProxyUser(String string) {
        this.setString(Atom.USER, string);
    }

    public void getProxyPW(String string) {
        this.a = string;
    }

    public void setResolveHostNames(boolean bl) {
        this.setBool(Atom.RESOLVE, bl);
    }

    public boolean doResolveHostNames() {
        return this.getBool(Atom.RESOLVE);
    }
}

