/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.security;

import com.iizix.ILog;
import com.iizix.SystemConfig;
import com.iizix.security.IX509CertificateFromEclipseBundle;
import com.iizix.selector.LanguageMatch;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.CodeSource;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CertificateHelper {
    public static final X509Certificate[] EMPTY_ARRAY = new X509Certificate[0];
    private static CertificateFactory a;
    private static IX509CertificateFromEclipseBundle a;
    private static final String[] a;

    static {
        a = new String[]{"Manifest-Version: 1.0", "Sealed: true", "Trusted-Only: true", "Permissions: all-permissions", "Codebase: *", "Application-Name: iiziApp"};
    }

    public static synchronized CertificateFactory getCertificateFactory() throws CertificateException {
        if (a == null) {
            a = CertificateFactory.getInstance("X.509");
        }
        return a;
    }

    public static X509Certificate loadCertificate(String string) throws CertificateException, FileNotFoundException, IOException {
        return CertificateHelper.loadCertificate(new File(string));
    }

    public static X509Certificate[] loadCertificates(String string) throws CertificateException, FileNotFoundException, IOException {
        return CertificateHelper.loadCertificates(new File(string));
    }

    public static final X509Certificate loadCertificate(File file) throws CertificateException, FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            return CertificateHelper.loadCertificate(bufferedInputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final X509Certificate[] loadCertificates(File file) throws CertificateException, FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            return CertificateHelper.loadCertificates(bufferedInputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final X509Certificate loadCertificate(InputStream inputStream) throws CertificateException {
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
    }

    public static X509Certificate[] loadCertificates(byte[] byArray) throws CertificateException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                return CertificateHelper.loadCertificates(byteArrayInputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new CertificateException("I/O error", iOException);
        }
    }

    public static final X509Certificate[] loadCertificates(InputStream inputStream) throws CertificateException {
        CertPath certPath = CertificateHelper.getCertificateFactory().generateCertPath(inputStream);
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = 0;
        X509Certificate[] x509CertificateArray = new X509Certificate[list.size()];
        for (Certificate certificate : list) {
            if (!(certificate instanceof X509Certificate)) {
                throw new CertificateException("Non-X.509 certificate encountered");
            }
            x509CertificateArray[n2++] = (X509Certificate)certificate;
        }
        return x509CertificateArray;
    }

    public static byte[] toBytes(X509Certificate[] x509CertificateArray) throws CertificateException {
        return CertificateHelper.getCertificateFactory().generateCertPath(List.of(x509CertificateArray)).getEncoded();
    }

    public static void writeCertificates(File file, X509Certificate[] x509CertificateArray) throws CertificateException, FileNotFoundException, IOException {
        byte[] byArray = CertificateHelper.toBytes(x509CertificateArray);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(byArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static X500Principal createX500Principal(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        ArrayList<Rdn> arrayList = new ArrayList<Rdn>();
        arrayList.add(CertificateHelper.a("CN", "Common name", string));
        arrayList.add(CertificateHelper.a("O", "Organization/Company", string3));
        arrayList.add(CertificateHelper.a("OU", "Organizational unit", string2));
        arrayList.add(CertificateHelper.a("L", "Locality or City", string4));
        arrayList.add(CertificateHelper.a("ST", "State or Province", string5));
        if (string6.length() != 2) {
            throw new Exception("The certificate (C) value for Country code is not a valid, it must be two characters");
        }
        if (LanguageMatch.countryNames.get(string6 = string6.toUpperCase()) == null) {
            throw new Exception("The certificate (C) value for Country code is not a valid country code");
        }
        arrayList.add(CertificateHelper.a("C", "Country code", string6));
        LdapName ldapName = new LdapName(arrayList);
        return new X500Principal(ldapName.toString());
    }

    private static Rdn a(String string, String string2, String string3) throws Exception {
        if (string3 == null) {
            throw new Exception("The certificate (" + string + ") value for " + string2 + " is null");
        }
        if (string3.isEmpty()) {
            throw new Exception("The certificate (" + string + ") value for " + string2 + " is empty");
        }
        try {
            return new Rdn(string, string3);
        }
        catch (Exception exception) {
            throw new Exception("The certificate (" + string + ") value for " + string2 + " is invalid");
        }
    }

    public static void assignCertificateFromEclipseBundle(IX509CertificateFromEclipseBundle iX509CertificateFromEclipseBundle) {
        if (iX509CertificateFromEclipseBundle == null) {
            throw new NullPointerException("eclipseCertsResolver is null");
        }
        if (a != null && a != iX509CertificateFromEclipseBundle) {
            throw new IllegalStateException("Already assigned!");
        }
        a = iX509CertificateFromEclipseBundle;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate[] getCodeSigningCertificates(Class<?> clazz) {
        try {
            X509Certificate[] x509CertificateArray;
            int n2;
            Certificate[] certificateArray;
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource != null && (certificateArray = codeSource.getCertificates()) != null && (n2 = certificateArray.length) >= 2) {
                Object object;
                Certificate[] certificateArray2 = certificateArray;
                int n3 = certificateArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = certificateArray2[n4];
                    if (!(object instanceof X509Certificate)) {
                        return null;
                    }
                    ++n4;
                }
                object = new X509Certificate[n2];
                while (--n2 >= 0) {
                    object[n2] = (X509Certificate)certificateArray[n2];
                }
                return object;
            }
            if (a != null && (x509CertificateArray = a.getCertificates(clazz)) != null && x509CertificateArray.length >= 2) {
                return x509CertificateArray;
            }
        }
        catch (Throwable throwable) {
            ILog.SEVERE(CertificateHelper.class, "Failed retrieving code signing certificates for class " + clazz.getName(), throwable);
            return null;
        }
        if (!SystemConfig.isDevelopmentMode) {
            ILog.SEVERE(CertificateHelper.class, "Failed calling getProtectionDomain().getCodeSource() for class " + clazz.getName());
        }
        return null;
    }

    public static X509Certificate[] getJarCertificates(JarFile jarFile) throws IOException {
        Object object;
        Cloneable cloneable;
        Object object22;
        Manifest manifest;
        Serializable serializable;
        try {
            serializable = null;
            Object object32 = null;
            try (InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/MANIFEST.MF"));){
                manifest = new Manifest(inputStream);
            }
            catch (Throwable throwable) {
                if (serializable == null) {
                    serializable = throwable;
                } else if (serializable != throwable) {
                    ((Throwable)serializable).addSuppressed(throwable);
                }
                throw serializable;
            }
        }
        catch (Throwable throwable) {
            throw new IOException("Failed loading manifest", throwable);
        }
        serializable = new HashSet();
        block14: for (Map.Entry entry : manifest.getEntries().entrySet()) {
            for (Object object22 : ((Attributes)entry.getValue()).keySet()) {
                if (!(object22 instanceof Attributes.Name) || ((Attributes.Name)object22).toString().indexOf("-Digest") < 0) continue;
                ((HashSet)serializable).add((String)entry.getKey());
                continue block14;
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        object22 = jarFile.entries();
        while (object22.hasMoreElements()) {
            cloneable = object22.nextElement();
            if (((ZipEntry)cloneable).isDirectory()) continue;
            object = ((ZipEntry)cloneable).getName();
            if (object.startsWith("META-INF/")) {
                bl |= object.endsWith(".SF");
                continue;
            }
            hashSet.add((String)object);
        }
        if (!bl) {
            return null;
        }
        object22 = new HashSet(hashSet);
        ((AbstractSet)object22).removeAll((Collection<?>)((Object)serializable));
        if (!((HashSet)object22).isEmpty()) {
            throw new IOException("Found " + ((HashSet)object22).size() + " unsigned files in the Jar file: " + Arrays.toString(((HashSet)object22).toArray()));
        }
        cloneable = new HashSet(serializable);
        cloneable.removeAll(hashSet);
        object = cloneable.iterator();
        while (object.hasNext()) {
            if (!((String)object.next()).startsWith("META-INF/")) continue;
            object.remove();
        }
        if (!cloneable.isEmpty()) {
            throw new IOException("Found " + cloneable.size() + " signed entries in manifest, but the files are missing in the Jar file: " + Arrays.toString(((HashSet)object22).toArray()));
        }
        object = null;
        Iterator iterator = ((HashSet)serializable).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry == null) {
                return null;
            }
            Object[] objectArray = null;
            Object var12_20 = null;
            try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
                int n2;
                while ((n2 = inputStream.available()) > 0) {
                    inputStream.skip(n2);
                }
            }
            catch (Throwable object3) {
                if (objectArray == null) {
                    objectArray = object3;
                } else if (objectArray != object3) {
                    objectArray.addSuppressed((Throwable)object3);
                }
                throw objectArray;
            }
            objectArray = jarEntry.getCertificates();
            if (objectArray == null) {
                return null;
            }
            if (object == null) {
                int n3 = objectArray.length;
                if (n3 == 0) {
                    throw new IOException("The certificate chain is empty");
                }
                object = new X509Certificate[n3];
                while (--n3 >= 0) {
                    try {
                        object[n3] = (X509Certificate)objectArray[n3];
                    }
                    catch (Throwable throwable) {
                        throw new IOException("Found non-X.509 certificate in certificate chain at index " + n3 + " for Jar entry " + string);
                    }
                }
                continue;
            }
            if (Arrays.equals(object, objectArray)) continue;
            throw new IOException("More than one certificate chain encountered, Jar file entry " + string);
        }
        return object != null || !hashSet.isEmpty() ? object : new X509Certificate[]{};
    }

    private static boolean a(JarFile jarFile) throws IOException {
        return CertificateHelper.getJarCertificates(jarFile) != null;
    }

    public static String verifyManifest(Manifest manifest) {
        if (manifest == null) {
            return "Manifest not found";
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return "Failed to find the main manifest attributes";
        }
        String[] stringArray = a;
        int n2 = a.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            int n4 = string.indexOf(58);
            String string2 = string.substring(0, n4);
            String string3 = string.substring(n4 + 2);
            if (!string3.equals(string = attributes.getValue(string2))) {
                return "Main Jar manifest seal/permission/codebase attribute '" + string2 + "' is not '" + string3 + "' but '" + string;
            }
            ++n3;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJarSigned(String string) {
        try {
            Throwable throwable = null;
            Object var2_6 = null;
            try (JarFile jarFile = new JarFile(string, true);){
                String string2 = CertificateHelper.verifyManifest(jarFile.getManifest());
                if (string2 == null) return CertificateHelper.a(jarFile);
                ILog.WARNING(CertificateHelper.class, "Check iiziApp Jar file \"" + string + "\": " + string2);
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            ILog.WARNING(CertificateHelper.class, "Error checking iiziApp Jar file \"" + string + "\" certificates: " + iOException.getMessage());
            return false;
        }
        catch (SecurityException securityException) {
            ILog.SEVERE(CertificateHelper.class, "Error checking iiziApp Jar file \"" + string + "\" certificates", securityException);
            return false;
        }
        catch (Throwable throwable) {
            ILog.SEVERE(CertificateHelper.class, "Internal Error", throwable);
            return false;
        }
    }
}

