/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.license.history;

import com.iizix.ILog;

public enum LicensingHistoryEvent {
    CREATED(1, "License created"),
    TRIAL_BEGIN(2, "Trial period started"),
    TRIAL_EXTENDED(3, "Trial period extended"),
    TRIAL_END(4, "Trial period end"),
    ACTIVATED(5, "License activated"),
    TIME_CHANGED(10, "System time changed"),
    HARDWARE_CHANGED(11, "Hardware change"),
    INSTALLATION_CHANGED(12, "Installation/hardware change"),
    VERSION_CHANGED(13, "Version change"),
    LICENSE_TIMESTAMP(14, "License timestamp change"),
    DEACTIVATED(20, "License deactivated"),
    USER_LOGOUT(21, "User logout"),
    USER_LOGIN(22, "User login"),
    USER_CHANGE(23, "Change of user"),
    USER_REVOKED(30, "User has revoked the license"),
    SYSTEM_REVOKED(31, "License revoked by system"),
    BROKEN(90, "Broken license"),
    HARDWARE_ERROR(91, "Hardware error"),
    RESTORED(1000, "License restored from backup"),
    _UNKNOWN_(-1, "Unknown event");

    public final int value;
    protected final String text;

    private LicensingHistoryEvent(int n3, String string2) {
        this.value = n3;
        this.text = string2;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public static LicensingHistoryEvent from(int n2) {
        LicensingHistoryEvent[] licensingHistoryEventArray = LicensingHistoryEvent.values();
        int n3 = licensingHistoryEventArray.length;
        int n4 = 0;
        while (n4 < n3) {
            LicensingHistoryEvent licensingHistoryEvent = licensingHistoryEventArray[n4];
            if (licensingHistoryEvent.value == n2) {
                return licensingHistoryEvent;
            }
            ++n4;
        }
        ILog.SEVERE(LicensingHistoryEvent.class, "LicensingHistoryEvent value not found: " + n2 + ", returning " + String.valueOf((Object)_UNKNOWN_), new Exception("StackTrace"));
        return _UNKNOWN_;
    }
}

