/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.urn.file;

import com.iizix.Utilities;
import com.iizix.urn.MalformedURNException;
import com.iizix.urn.URNResource;
import com.iizix.urn.URNResourceType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;

public class FileURN
extends URNResource
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -3148469232027352642L;
    private final String a;

    public static FileURN fromExternalFile(String string) throws FileNotFoundException, IOException {
        return FileURN.fromExternalFile(new File(string));
    }

    public static FileURN fromExternalFile(File file) throws MalformedURLException, FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        if (!(file = file.getCanonicalFile()).exists()) {
            throw new FileNotFoundException("File \"" + String.valueOf(file) + "\" does not exist");
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("File \"" + String.valueOf(file) + "\" is not a file");
        }
        return FileURN.fromExternalFile(file.toURI());
    }

    public static FileURN fromExternalFile(URI uRI) throws MalformedURLException {
        if (uRI == null) {
            throw new NullPointerException("uriFile is null");
        }
        String string = uRI.toURL().toExternalForm();
        String string2 = Utilities.encodeURIComponent(string);
        URNResourceType uRNResourceType = URNResourceType.EXTERNAL_FILES;
        String string3 = "urn:iz-file:" + uRNResourceType.nss + ":" + string2;
        return new FileURN(string3, uRNResourceType, null, string);
    }

    public static FileURN fromFileResource(URNResourceType uRNResourceType, Object object, String string) throws MalformedURLException, MalformedURNException {
        if (uRNResourceType == null) {
            throw new NullPointerException("type is null");
        }
        String string2 = "urn:iz-file:" + uRNResourceType.nss + ":";
        Class<?> clazz = object.getClass();
        if (!clazz.equals(uRNResourceType.idClass)) {
            throw new IllegalArgumentException("id class must be " + uRNResourceType.idClass.getCanonicalName() + " but is " + clazz.getCanonicalName());
        }
        string2 = object instanceof Long ? string2 + object.toString() : string2 + Utilities.encodeURIComponent(object.toString());
        if (string == null) {
            throw new NullPointerException("fileName is null");
        }
        string2 = string2 + ":" + Utilities.encodeURIComponent(string);
        return new FileURN(string2, uRNResourceType, object, string);
    }

    protected FileURN(String string, URNResourceType uRNResourceType, Object object, String string2) {
        super(string, uRNResourceType, object);
        this.a = string2;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.a.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.a.equals(((FileURN)object).a);
    }

    @Override
    public String getParamString() {
        return super.getParamString() + ",fileName=" + this.a;
    }

    @Override
    public String getURL() throws IOException {
        return super.getURL() + "/" + Utilities.encodeURIComponent(this.a);
    }
}

