/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.comm.client;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.ServerConstants;
import com.iizix.SessionInfo;
import com.iizix.Utilities;
import com.iizix.Worker;
import com.iizix.comm.TransactionComm;
import com.iizix.comm.TransactionCommListener;
import com.iizix.comm.client.IClientInstanceListener;
import com.iizix.comm.client.b;
import com.iizix.event.EventListener;
import com.iizix.prop.Atom;
import com.iizix.prop.ClientProps;
import com.iizix.prop.PropFactory;
import com.iizix.prop.PropMgr;
import com.iizix.prop.SSLCommProps;
import com.iizix.prop.TransactionCommProps;
import com.iizix.virtual.VirtualThreads;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLEngine;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ClientInstance {
    private final IClientInstanceListener a;
    private final PropFactory a;
    private final String a;
    private final int a;
    private final SSLEngine a;
    private final String b;
    private final SessionInfo a;
    private final Worker a;
    private boolean a;
    private int b;
    private int c;
    private int d;
    private TransactionComm a;
    private PropMgr a;
    private ClientProps a;
    private boolean b;
    private boolean c;
    private final TransactionCommListener a;
    private final Runnable a;
    private final EventListener a = gEvent -> {
        if (!gEvent.isRemoteInduced()) {
            this.b();
        }
    };
    private boolean d;

    public ClientInstance(PropFactory propFactory, String string, int n2, String string2, SSLCommProps sSLCommProps, boolean bl, IClientInstanceListener iClientInstanceListener) throws IOException, UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, CertificateException, KeyStoreException, NoSuchProviderException {
        if (propFactory == null) {
            throw new NullPointerException("propFactory is null");
        }
        this.a = bl;
        this.a = propFactory;
        this.a = string;
        this.a = n2;
        this.b = string2;
        this.a = iClientInstanceListener;
        String string3 = sSLCommProps != null ? "wss://" : "ws://";
        String string4 = string3 + string + ":" + n2 + string2;
        InetAddress inetAddress = InetAddress.getByName(string);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
        this.a = new SessionInfo(inetSocketAddress);
        this.a.assignServerSessionID(SessionInfo.getNextID());
        int n3 = string.lastIndexOf(46);
        if (n3 >= 0) {
            this.a.assignRemoteAddress(inetSocketAddress, string.substring(n3 + 1), string.substring(0, n3), n2, sSLCommProps != null);
        } else {
            this.a.assignRemoteAddress(inetSocketAddress, string, string, n2, sSLCommProps != null);
        }
        this.a = sSLCommProps != null ? sSLCommProps.createClientSSLEngine(string4) : null;
        this.a = new Worker(this.a);
        this.a.setVerbose(bl);
        VirtualThreads.getVirtualThreads().startThread(() -> this.a.process(), "Worker-" + string4);
    }

    public boolean isVerbose() {
        return this.a;
    }

    public void setVerbose(boolean bl) {
        this.a = bl;
        this.a.setVerbose(bl);
    }

    public void setWriteCacheParams(int n2, int n3, int n4) {
        if (n4 == 0) {
            n2 = 0;
            n3 = 0;
        } else if (n3 <= n2 || n2 < 7 || n3 > 1024 || n4 < 10 || n4 > 2048) {
            throw new IllegalArgumentException("Arguments not valid");
        }
        this.b = n2;
        this.c = n3;
        this.d = n4;
    }

    public boolean isConnected() {
        TransactionComm transactionComm = this.a;
        return transactionComm != null && transactionComm.isConnected();
    }

    public boolean isDisconnected() {
        return this.a == null;
    }

    public String getState() {
        TransactionComm transactionComm = this.a;
        if (transactionComm == null) {
            return "Disconnected";
        }
        if (transactionComm.isConnected()) {
            return "Connected";
        }
        if (this.b) {
            return "Disconnecting";
        }
        return "Connecting";
    }

    public void connect() throws IOException {
        this.connect(false);
    }

    public void connect(boolean bl) throws IOException {
        TransactionComm transactionComm = this.a;
        if (transactionComm != null) {
            throw new IllegalStateException("Already connected");
        }
        if (this.a) {
            System.err.println("Connect " + String.valueOf(this) + " " + this.b + " @" + Utilities.formatCurrentDate());
        }
        TransactionCommProps transactionCommProps = new TransactionCommProps(Atom.SYSTEM);
        transactionCommProps.setHost(this.a);
        transactionCommProps.setPort(this.a);
        transactionCommProps.setRequestURI(this.b);
        transactionCommProps.setSubProtocols(ServerConstants.WS_PROTOCOLS);
        transactionCommProps.doFailForUnsupportedSubProtocol(true);
        transactionCommProps.setVerbose(this.a);
        transactionCommProps.setCacheParams(this.b, this.c, this.d);
        int n2 = this.a.getProgramType();
        this.a = this.a.createPropertyManager(n2, n2 == 1 ? null : (n2 == 0 ? this.a.createClientClassNameMap(false) : this.a.createEditorServerClassNameMap()));
        this.a.setOwner(new b(this));
        if (this.a) {
            System.err.println("Opened " + String.valueOf(this) + " " + this.b + " @" + Utilities.formatCurrentDate());
        }
        this.a = transactionComm = new TransactionComm(transactionCommProps, this.a, this.a, this.a);
        transactionComm.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispose() {
        Object object = this;
        synchronized (object) {
            block5: {
                if (!this.c) break block5;
                return false;
            }
            this.c = true;
        }
        object = this.a;
        if (object != null) {
            ((TransactionComm)object).close(1000, "Normal close");
        }
        this.a();
        return true;
    }

    private void a() {
        ClientProps clientProps = this.a;
        if (clientProps != null) {
            clientProps.removePropListener(this.a);
            clientProps.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        ClientInstance clientInstance = this;
        synchronized (clientInstance) {
            if (this.d) {
                return;
            }
            this.d = true;
        }
        this.a.post(this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendBinaryData(int n2, String string, byte[] byArray) throws IOException {
        TransactionComm transactionComm;
        Object object = this;
        synchronized (object) {
            if (this.c) {
                throw new EOFException("Communication with License System is disposed of");
            }
            transactionComm = this.a;
            if (transactionComm == null) {
                throw new EOFException("Connection is closed");
            }
        }
        object = new SendTransaction();
        ((SendTransaction)object).appendByte(11);
        ((SendTransaction)object).appendLong(byArray.length);
        ((SendTransaction)object).appendUnsigned(n2);
        ((SendTransaction)object).appendString(string);
        ((SendTransaction)object).append(byArray);
        return transactionComm.send((SendTransaction)object, true);
    }

    private void a(ReadTransaction readTransaction) {
        ReadTransaction readTransaction2;
        while ((readTransaction2 = readTransaction.readTransaction()) != null) {
            int n2;
            int n3 = readTransaction2.readByte();
            if (this.a) {
                System.err.println("processTransaction: transaction code = " + n3 + " - " + this.getInfoString() + " @" + Utilities.formatCurrentDate());
            }
            switch (n3) {
                case 0: {
                    this.a.readPropMgrData(readTransaction2);
                    break;
                }
                case 3: {
                    this.a.processUpdateTrans(this.a, readTransaction2);
                    break;
                }
                case 6: {
                    this.a.processRemoveEvent(readTransaction2);
                    break;
                }
                case 11: {
                    n2 = readTransaction2.readLong();
                    int n4 = readTransaction2.readUnsigned();
                    String string = readTransaction2.readString();
                    byte[] byArray = readTransaction2.readBytes(n2);
                    this.a.onBinaryData(n4, string, byArray);
                    break;
                }
                default: {
                    if (this.a.processTransaction(n3, readTransaction)) break;
                    ILog.SEVERE(this.getClass(), "Unknown transaction code " + n3 + " - " + this.getInfoString());
                }
            }
            if ((n2 = readTransaction2.getRemainingReadSize()) <= 0) continue;
            ILog.SEVERE(this.getClass(), "Unread data size " + n2 + " in inbound transaction");
        }
    }

    public SessionInfo getSessionInfo() {
        return this.a;
    }

    public String getInfoString() {
        return SessionInfo.getConnectionIDString(this.a);
    }

    public String toString() {
        return SessionInfo.getConnectionIDString(this.a);
    }
}

