/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.NumberValue;
import java.text.ParseException;

public class ByteValue
extends NumberValue<Byte> {
    private static final Byte a = 0;

    @Override
    public final Value.Type getValueType() {
        return Value.Type.Byte;
    }

    @Override
    public Class<Byte> getValueClass() {
        return Byte.class;
    }

    @Override
    public String getDescription() {
        return "Byte value (range -128 to 127)";
    }

    @Override
    public Byte createDefault() {
        return a;
    }

    @Override
    public Byte parse(String string) throws NumberFormatException {
        return Byte.valueOf(string);
    }

    @Override
    public Byte convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            double d2 = number.longValue();
            if (d2 > 127.0 || d2 < -128.0) {
                throw new ArithmeticException("Value out of Byte range: " + String.valueOf(object));
            }
            return number.byteValue();
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            if (l2 >= -128L && l2 <= 127L) {
                return (byte)l2;
            }
            throw new ArithmeticException("Value range error when converting to Byte for type " + object.getClass().getCanonicalName() + ": value = " + String.valueOf(object));
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return Byte.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }
}

