/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;

public class BoolProp
extends GProp<Boolean> {
    private static final Class<?>[] a = new Class[]{Boolean.class, Long.class, Integer.class, Short.class, Byte.class, Float.class, Double.class, String.class, Character.class};

    protected BoolProp() {
    }

    public BoolProp(Atom atom) {
        super(atom);
    }

    public BoolProp(Atom atom, boolean bl) {
        super(atom);
        this.setPropValue(bl);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    public boolean setPropValue(boolean bl) {
        try {
            return super.setPropValue(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (PropException propException) {
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    public boolean setPropValue(boolean bl, IGProp<?> iGProp) {
        try {
            return super.setPropValue((Object)(bl ? Boolean.TRUE : Boolean.FALSE), iGProp);
        }
        catch (PropException propException) {
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof Boolean)) {
            throw new PropTypeException(this, "newValue not Boolean");
        }
    }

    public boolean getBool() {
        return this.getBool(false);
    }

    public boolean getBool(boolean bl) {
        Boolean bl2 = (Boolean)this.getPropValue();
        return bl2 == null ? bl : bl2;
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        Boolean bl = (Boolean)object;
        sendTransaction.appendBoolean(bl == null ? false : bl);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        return this.setPropValue((Object)readTransaction.readBoolean(), propMgr);
    }

    public static boolean getBool(GProp<?> gProp, String string) throws PropException {
        if (string.equals("1") || string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equals("0") || string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new PropException(gProp, "Cannot convert (" + string + ") to boolean");
    }

    public static boolean getBool(GProp<?> gProp, String string, boolean bl) {
        if (string.equals("1") || string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equals("0") || string.equalsIgnoreCase("false")) {
            return false;
        }
        return bl;
    }

    @Override
    public Object fromElementString(String string) throws PropException {
        return BoolProp.getBool(this, string) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        int n3 = object.equals(Boolean.TRUE) ? 1 : 0;
        switch (n2) {
            case 1: {
                return (long)n3;
            }
            case 2: {
                return n3;
            }
            case 3: {
                return (short)n3;
            }
            case 4: {
                return (byte)n3;
            }
            case 5: {
                return Float.valueOf(n3);
            }
            case 6: {
                return (double)n3;
            }
            case 7: {
                return this.toElementString(object);
            }
            case 8: {
                return Character.valueOf((char)n3);
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        boolean bl;
        switch (n2) {
            case 1: {
                bl = (Long)object != 0L;
                break;
            }
            case 2: {
                bl = (Integer)object != 0;
                break;
            }
            case 3: {
                bl = (Short)object != 0;
                break;
            }
            case 4: {
                bl = (Byte)object != 0;
                break;
            }
            case 5: {
                bl = ((Float)object).floatValue() != 0.0f;
                break;
            }
            case 6: {
                bl = (Double)object != 0.0;
                break;
            }
            case 7: {
                return this.fromElementString((String)object);
            }
            case 8: {
                bl = ((Character)object).charValue() != '\u0000';
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid index: " + n2);
            }
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }
}

