/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.app.builder;

import com.iizix.ILog;
import com.iizix.RunMode;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.app.BuildException;
import com.iizix.app.CancelException;
import com.iizix.app.builder.ApplicationDistributor;
import com.iizix.prop.Atom;
import com.iizix.prop.EnvProps;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropFactory;
import com.iizix.prop.PropMgr;
import com.iizix.server.IAppLoader;
import com.iizix.server.PluginLoader;
import com.iizix.server.app.AppFactory;
import com.iizix.text.DefaultInfoHolder;
import com.iizix.text.IKStringInfoProviderHolder;
import com.iizix.text.ValidationKStringInfoProviderHolder;
import com.iizix.util.XJarFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ApplicationDistributorCommandLine {
    private static PropFactory a;
    private static PropMgr a;
    private static PluginLoader a;
    private static boolean a;

    static {
        a = true;
    }

    public static void main(String[] stringArray) {
        long l = System.nanoTime();
        int n = 0;
        if (stringArray.length == 0) {
            ApplicationDistributorCommandLine.b();
        }
        if (stringArray[0].toLowerCase().equals("-silent")) {
            a = false;
            ++n;
            if (stringArray.length < 2) {
                ApplicationDistributorCommandLine.b();
            }
        }
        if (a) {
            ApplicationDistributorCommandLine.a();
        }
        if (!SystemConfig.HAS_UNLIMITED_CRYPTO) {
            System.err.println("Java Unlimited Cryptography is missing or cannot be configured!\nApplicationDistributor does not function if the Java Unlimited JCE Policy is not installed\nin JRE/JDK lib/security directory.\n\nPlease download it from the Oracle Java site\nand install it before continuing.\n\niiziServer cannot start.\n");
            System.exit(9);
        }
        ApplicationDistributorCommandLine.c();
        int n2 = 0;
        Throwable throwable = null;
        Object var6_6 = null;
        try (ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(24, 256, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());){
            while (n < stringArray.length) {
                if (a) {
                    System.out.println("\nProcessing '" + stringArray[n] + "':\n");
                }
                File file = new File(stringArray[n++]);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!file.isDirectory()) {
                    System.out.println(" - Directory does not exist: " + file.getPath());
                    ++n2;
                    continue;
                }
                if (ApplicationDistributorCommandLine.a(file, threadPoolExecutor) == 0) continue;
                ++n2;
            }
            threadPoolExecutor.shutdown();
            try {
                if (!threadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    System.err.println("Executor service failed to shutdown within 5 seconds");
                }
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Executor service shutdown was interrupted");
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (a) {
            System.out.println("\nDone, elapsed time " + Utilities.formatDurationNanos((long)(System.nanoTime() - l)) + ".\n");
        }
        if (n2 != 0) {
            System.exit(n2);
        }
    }

    private static void a() {
        System.out.println("\niiziApp Distribution builder (version " + SystemConfig.VERSION_BUILD + "):\n========================================" + "================================".substring(0, SystemConfig.VERSION_BUILD.length()) + "\n\n(C) Copyright Mindus SARL, 2025.\nAll rights reserved.");
    }

    private static void b() {
        ApplicationDistributorCommandLine.a();
        System.out.println("\nSyntax: java -ea -server -Xmx256m -classpath ... com.iizix.app.builder.ApplicationDistributorCommandLine [-silent] project-dir-1 ... project-dir-N\n\nNote 1: Java sources are NOT compiled, all the class files must be compiled before invoking the iiziApp Distribution builder.\nNote 2: Any plugins such as Database, Terminal or Web Services must include the appropriate Jar files in the classpath.\n");
        System.exit(99);
    }

    private static void c() {
        RunMode.setRunMode((RunMode)RunMode.DESIGNER, runnable -> {});
        ILog.setLogLevel((int)3);
        ClassLoader classLoader = ApplicationDistributorCommandLine.class.getClassLoader();
        a = new PropFactory(1, classLoader);
        try {
            a.loadPropDefinitions();
        }
        catch (IOException iOException) {
            System.out.println("\nFailed loading the property framework\n");
            iOException.printStackTrace(System.out);
            System.exit(100);
        }
        a = a.createPropertyManager(1, null);
        a = new PluginLoader(a, classLoader);
    }

    private static int a(File file, ThreadPoolExecutor threadPoolExecutor) {
        try {
            long l = System.nanoTime();
            System.out.println("Building project " + file.getPath());
            ApplicationDistributorCommandLine.a(file, threadPoolExecutor);
            if (a) {
                System.out.println("Done, in " + Utilities.formatDurationNanos((long)(System.nanoTime() - l)));
            }
            return 0;
        }
        catch (CancelException cancelException) {
            return 9;
        }
        catch (BuildException buildException) {
            System.out.println("\n* Build failure: " + buildException.getMessage());
            return 1;
        }
        catch (PropException propException) {
            System.out.println("\n* Build failure: " + propException.getMessage());
            propException.printStackTrace(System.out);
            GProp gProp = propException.getProperty();
            PropCnr propCnr = gProp.getParent();
            if (propCnr != null) {
                gProp = propCnr;
            }
            gProp.list(System.out);
            return 1;
        }
        catch (IOException | InvalidPathException exception) {
            System.out.println("\n* Build failure: " + exception.getMessage());
            exception.printStackTrace(System.out);
            if (exception.getCause() instanceof PropException) {
                GProp gProp = ((PropException)exception.getCause()).getProperty();
                PropCnr propCnr = gProp.getParent();
                if (propCnr != null) {
                    gProp = propCnr;
                }
                gProp.list(System.out);
            }
            return 2;
        }
        catch (Throwable throwable) {
            System.out.println("\n* Build failure:\n");
            throwable.printStackTrace(System.out);
            return 3;
        }
    }

    private static void a(File file, ThreadPoolExecutor threadPoolExecutor) throws IOException, PropException, CancelException, InvalidPathException {
        boolean bl = true;
        ApplicationDistributor applicationDistributor = new ApplicationDistributor(a, a, a, threadPoolExecutor, a);
        try {
            String string4;
            Comparable<File> comparable;
            String string2;
            if (a) {
                System.out.println(" - Loading application distribution configuration for Module project '" + file.getName() + "'");
            }
            applicationDistributor.loadApplicationDefinition(file);
            if (a) {
                System.out.println(" - Verifying");
            }
            if ((string2 = applicationDistributor.verifyModules()) != null) {
                throw new IOException(string2);
            }
            if (a) {
                System.out.println(" - Resolving references");
            }
            DefaultInfoHolder.setKStringInfoProviderHolder((IKStringInfoProviderHolder)new ValidationKStringInfoProviderHolder((GProp)applicationDistributor.appCnr, null));
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            applicationDistributor.resolveReferences(arrayList, arrayList2);
            int n = arrayList2.size();
            if (n > 0) {
                StringBuilder stringBuilder = new StringBuilder("Application contains ").append(n).append(n > 1 ? " errors" : " error");
                int n2 = arrayList.size();
                if (n2 > 0) {
                    stringBuilder.append(" and ").append(n2).append(n2 > 1 ? " warnings" : " warning");
                }
                stringBuilder.append(':');
                for (String string3 : arrayList2) {
                    stringBuilder.append("\n - [ERROR]\t").append(string3);
                }
                for (String string3 : arrayList) {
                    stringBuilder.append("\n - [WARNING]\t").append(string3);
                }
                throw new BuildException(stringBuilder.toString());
            }
            if (a && (n = arrayList.size()) > 0) {
                comparable = new StringBuilder("Application contains ").append(n).append(n > 1 ? " warnings:" : " warning:");
                for (String string4 : arrayList) {
                    ((StringBuilder)comparable).append("\n - [WARNING]\t").append(string4);
                }
                if (a) {
                    System.out.println(((StringBuilder)comparable).append('\n').toString());
                }
            }
            if (a) {
                System.out.println(" - Creating file operations");
            }
            applicationDistributor.createResourceOperations(null);
            if (a) {
                System.out.println(" - Creating temporary application Jar");
            }
            comparable = applicationDistributor.createJar(null);
            applicationDistributor.dispose();
            bl = false;
            string4 = null;
            try {
                if (a) {
                    System.out.println(" - Verifying application Jar file");
                }
                XJarFile.clearLoadedFilesList();
                string4 = new AppFactory("TEST", null, (IAppLoader)applicationDistributor, comparable, null);
                EnvProps envProps = new EnvProps(Atom.ENV);
                string4.getAppRoot().initialize((AppFactory)string4, envProps);
                HashSet hashSet = new HashSet();
                int n3 = string4.prepare(null, hashSet);
                XJarFile.clearLoadedFilesList();
                if (n3 > 0) {
                    throw new BuildException("The application distribution failed with " + n3 + " error" + (n3 > 1 ? "s" : ""));
                }
                File file2 = applicationDistributor.getDestinationJar(file);
                if (a) {
                    System.out.println(" - Copying temporary Jar to destination file '" + file2.getPath() + "'");
                }
                Files.copy(((File)comparable).toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (string4 != null) {
                    string4.dispose();
                }
                ((File)comparable).delete();
            }
        }
        finally {
            if (bl) {
                applicationDistributor.dispose();
            }
        }
    }
}

