/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.image.prop;

import com.iizigo.Activator;
import com.iizigo.font.prop.EditorFontFiles;
import com.iizigo.image.prop.IEditorImage;
import com.iizigo.navigator.IViewerComparator;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.PropertyEditorSetup;
import com.iizix.Position;
import com.iizix.Size;
import com.iizix.prop.PropCnr;
import com.iizix.prop.image.AbstractImageDefinition;
import com.iizix.prop.image.AbstractImageResolution;
import com.iizix.prop.image.IImageLocation;
import com.iizix.prop.image.IImageSize;
import com.iizix.prop.image.IImageStyle;
import java.util.Comparator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ImageDesignerProp
extends DesignerProp {
    public static final ImageComparator IMAGE_COMPARATOR = new ImageComparator();

    ImageDesignerProp(PropCnr propCnr) {
        super(propCnr);
    }

    @Override
    protected PropertyEditorSetup getPropertyEditorSetup() {
        return Activator.setupImage;
    }

    @Override
    public Image getCNImage(int n2) {
        PropCnr propCnr = this.propertyContainer;
        if (propCnr instanceof IEditorImage) {
            IEditorImage iEditorImage = (IEditorImage)propCnr;
            return iEditorImage.getCNImage();
        }
        return super.getCNImage(n2);
    }

    @Override
    public int getCNCategory() {
        if (this.propertyContainer instanceof AbstractImageResolution) {
            return -1;
        }
        return 0;
    }

    @Override
    public IViewerComparator getCNComparator() {
        return IMAGE_COMPARATOR;
    }

    @Override
    public String getCNText(int n2) {
        PropCnr propCnr = this.propertyContainer;
        if (propCnr instanceof IEditorImage) {
            IEditorImage iEditorImage = (IEditorImage)propCnr;
            return iEditorImage.getCNText(0);
        }
        return super.getCNText(n2);
    }

    @Override
    public StyledString getCNStyledText(int n2) {
        String string = this.getCNText(0);
        if (string != null) {
            return new StyledString(string);
        }
        return super.getCNStyledText(n2);
    }

    @Override
    public String getCNText(int n2, int n3) {
        String string;
        PropCnr propCnr = this.propertyContainer;
        if (propCnr instanceof IEditorImage) {
            IEditorImage iEditorImage = (IEditorImage)propCnr;
            string = iEditorImage.getCNText(n2);
        } else {
            string = "";
        }
        return string;
    }

    @Override
    public String getCNDescriptionType() {
        PropCnr propCnr = this.propertyContainer;
        if (propCnr instanceof IEditorImage) {
            IEditorImage iEditorImage = (IEditorImage)propCnr;
            return iEditorImage.getCNType();
        }
        return super.getCNDescriptionType();
    }

    @Override
    public String canPerform(int n2) {
        switch (n2) {
            case 2: {
                if (this.propertyContainer instanceof AbstractImageDefinition) {
                    return "Cannot delete the Image Definition container";
                }
                if (this.propertyContainer instanceof EditorFontFiles) {
                    return "Cannot delete the Font Icon Files container";
                }
                return null;
            }
            case 1: {
                if (this.propertyContainer instanceof AbstractImageDefinition) {
                    return "Cannot move the Image Definition container";
                }
                if (this.propertyContainer instanceof EditorFontFiles) {
                    return "Cannot move the Font Icon Files container";
                }
                return null;
            }
        }
        return super.canPerform(n2);
    }

    @Override
    public boolean hasCNToolTip(ViewerCell viewerCell) {
        return !this.propertyContainer.isDisposed();
    }

    @Override
    public Point getCNToolTipShift(ViewerCell viewerCell) {
        return null;
    }

    @Override
    public int getCNToolTipTimeDisplayed(ViewerCell viewerCell) {
        return -1;
    }

    @Override
    public Composite createCNToolTip(Event event, ViewerCell viewerCell, Composite composite) {
        Composite composite2;
        if (this.propertyContainer.isDisposed()) {
            return null;
        }
        PropCnr propCnr = this.propertyContainer;
        if (propCnr instanceof IEditorImage) {
            IEditorImage iEditorImage = (IEditorImage)propCnr;
            v0 = iEditorImage.createTooltip(composite);
        } else {
            v0 = composite2 = null;
        }
        if (composite2 != null) {
            this.appendTooltipPropErrors(composite2);
        }
        return composite2;
    }

    public static class ImageComparator
    implements IViewerComparator,
    Comparator<Object> {
        @Override
        public int compare(Viewer viewer, Object object, Object object2) {
            return this.compare(object, object2);
        }

        @Override
        public int compare(Object object, Object object2) {
            IPropDesigner iPropDesigner;
            DesignerProp designerProp;
            ImageDesignerProp imageDesignerProp;
            IPropDesigner iPropDesigner2;
            DesignerProp designerProp2;
            ImageDesignerProp imageDesignerProp2;
            if (object instanceof ImageDesignerProp) {
                ImageDesignerProp imageDesignerProp3;
                imageDesignerProp2 = imageDesignerProp3 = (ImageDesignerProp)object;
            } else if (object instanceof IPropDesigner && (designerProp2 = (iPropDesigner2 = (IPropDesigner)object).getDesigner()) instanceof ImageDesignerProp) {
                ImageDesignerProp imageDesignerProp4;
                imageDesignerProp2 = imageDesignerProp4 = (ImageDesignerProp)designerProp2;
            } else {
                return -1;
            }
            if (object2 instanceof ImageDesignerProp) {
                ImageDesignerProp imageDesignerProp5;
                imageDesignerProp = imageDesignerProp5 = (ImageDesignerProp)object2;
            } else if (object2 instanceof IPropDesigner && (designerProp = (iPropDesigner = (IPropDesigner)object2).getDesigner()) instanceof ImageDesignerProp) {
                ImageDesignerProp imageDesignerProp6;
                imageDesignerProp = imageDesignerProp6 = (ImageDesignerProp)designerProp;
            } else {
                return 1;
            }
            int n2 = Integer.compare(imageDesignerProp2.getCNCategory(), imageDesignerProp.getCNCategory());
            if (n2 == 0) {
                PropCnr propCnr = imageDesignerProp2.getPropCnr();
                PropCnr propCnr2 = imageDesignerProp.getPropCnr();
                if (propCnr instanceof AbstractImageResolution) {
                    AbstractImageResolution abstractImageResolution = (AbstractImageResolution)propCnr;
                    if (propCnr2 instanceof AbstractImageResolution) {
                        AbstractImageResolution abstractImageResolution2 = (AbstractImageResolution)propCnr2;
                        n2 = Double.compare(abstractImageResolution.getDevicePixelRatio(), abstractImageResolution2.getDevicePixelRatio());
                    }
                }
                if (n2 == 0) {
                    if (propCnr instanceof IImageSize) {
                        IImageSize iImageSize = (IImageSize)propCnr;
                        if (propCnr2 instanceof IImageSize) {
                            IImageSize iImageSize2 = (IImageSize)propCnr2;
                            n2 = Size.compareWidthThenHeight((Size)iImageSize.getImageSize(), (Size)iImageSize2.getImageSize());
                        }
                    }
                    if (n2 == 0) {
                        if (propCnr instanceof IImageLocation) {
                            IImageLocation iImageLocation = (IImageLocation)propCnr;
                            if (propCnr2 instanceof IImageLocation) {
                                IImageLocation iImageLocation2 = (IImageLocation)propCnr2;
                                n2 = Position.compare((Position)iImageLocation.getLocation(), (Position)iImageLocation2.getLocation());
                            }
                        }
                        if (n2 == 0 && propCnr instanceof IImageStyle) {
                            IImageStyle iImageStyle = (IImageStyle)propCnr;
                            if (propCnr2 instanceof IImageStyle) {
                                IImageStyle iImageStyle2 = (IImageStyle)propCnr2;
                                n2 = Integer.compare(iImageStyle.getMatchMasks(), iImageStyle2.getMatchMasks());
                            }
                        }
                    }
                }
            }
            return n2;
        }
    }
}

