/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.selector.prop;

import com.iizigo.ApplicationUI;
import com.iizigo.EditorStyleRange;
import com.iizigo.java.JavaHelper;
import com.iizigo.prop.DesignerProp;
import com.iizigo.selector.prop.EditorSelector;
import com.iizix.prop.EnvProps;
import com.iizix.prop.ISelectorExpression;
import com.iizix.prop.SelectorExpression;
import com.iizix.selector.DeviceMatch;
import com.iizix.selector.LanguageMatch;
import com.iizix.util.WindowsLikeFilenameFilter;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.custom.StyleRange;

public class EditorSelectorExpression
extends SelectorExpression {
    public EditorSelectorExpression(String string) {
        super(string);
    }

    public SelectorExpression.TokenData getToken(int n2) {
        block3: for (SelectorExpression.TokenData tokenData : this.tokens) {
            switch (tokenData.token) {
                case DEVICE: 
                case LANGUAGE: 
                case SELECTOR: 
                case WILD_CARD: 
                case REG_EXP: 
                case JAVA_CLASS: {
                    if (n2 < tokenData.pos[0] || n2 > tokenData.pos[tokenData.pos.length - 1]) continue block3;
                    return tokenData;
                }
            }
        }
        return null;
    }

    public Object getTooltipObject(int n2, DesignerProp designerProp) {
        block12: for (SelectorExpression.TokenData tokenData : this.tokens) {
            switch (tokenData.token) {
                case DEVICE: 
                case LANGUAGE: 
                case SELECTOR: 
                case WILD_CARD: 
                case REG_EXP: 
                case JAVA_CLASS: {
                    if (n2 < tokenData.pos[0] || n2 > tokenData.pos[tokenData.pos.length - 1]) continue block12;
                    Object object = null;
                    switch (tokenData.token) {
                        case DEVICE: {
                            String string = DeviceMatch.getDescription((String)tokenData.text);
                            if (string == null) {
                                object = "Device '" + tokenData.text + "' is unknown";
                                break;
                            }
                            object = string + (DeviceMatch.match((EnvProps)designerProp.getPropCnr().getEnvironment(), (String)tokenData.text) ? "\nMatches" : "\nDoes not match");
                            break;
                        }
                        case LANGUAGE: {
                            String string = LanguageMatch.getDescription((String)tokenData.text);
                            if (string == null) {
                                object = "Language '" + tokenData.text + "' is unknown";
                                break;
                            }
                            object = string + (LanguageMatch.match((EnvProps)designerProp.getPropCnr().getEnvironment(), (String)tokenData.text) ? "\nMatches" : "\nDoes not match");
                            break;
                        }
                        case SELECTOR: {
                            object = designerProp.getPropCnr().getPropFromReference(tokenData.text);
                            if (object instanceof EditorSelector) {
                                object = ((EditorSelector)object).getDesigner();
                                break;
                            }
                            object = object == null ? "Selector '" + tokenData.text + "' is not found" : "Reference '" + tokenData.text + "' is not a Selector";
                            break;
                        }
                        case JAVA_CLASS: {
                            try {
                                IType iType = designerProp.getModel().getJavaProject().findType(tokenData.text);
                                if (iType == null) {
                                    object = "Class '" + tokenData.text + "' is not found";
                                    break;
                                }
                                object = JavaHelper.validateClass(iType, ISelectorExpression.class.getName());
                                if (object != null) break;
                                object = iType;
                            }
                            catch (JavaModelException javaModelException) {}
                            break;
                        }
                        case WILD_CARD: 
                        case REG_EXP: {
                            String string = designerProp.getPropCnr().getEnvironment().getClientEnv().getValue(tokenData.text);
                            String string2 = "Environment variable '" + tokenData.text + "'";
                            if (string == null) {
                                object = string2 + " is not found in the current Browser environment";
                                break;
                            }
                            String string3 = tokenData.match;
                            String string4 = string3.replace("'", "''");
                            string2 = string2 + " = '" + string + "'\n";
                            object = tokenData.token == SelectorExpression.Token.WILD_CARD ? string2 + "Wild card string '" + string4 + "' " + (WindowsLikeFilenameFilter.isMatching((String)string, (String)string3, (boolean)true, (boolean)false) ? "matches" : "does not match") : (tokenData.pattern == null ? string2 + "Regular expression '" + string4 + "' cannot be parsed" : string2 + "Regular expression '" + string4 + "' " + (tokenData.pattern.matcher(string).matches() ? "matches" : "does not match"));
                        }
                    }
                    return object;
                }
            }
        }
        return null;
    }

    public StyleRange[] getStyleRanges(EditorSelector editorSelector) {
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
        Map map = editorSelector.getEnvironment().getClientEnv().getHashMap();
        for (SelectorExpression.TokenData tokenData : this.tokens) {
            switch (tokenData.token) {
                case NOT: {
                    StyleRange styleRange = EditorStyleRange.createStyleRange(6);
                    styleRange.start = tokenData.pos[0];
                    styleRange.length = tokenData.pos[tokenData.pos.length - 1] - styleRange.start + 1;
                    arrayList.add(styleRange);
                    break;
                }
                case OR: 
                case AND: {
                    StyleRange styleRange = EditorStyleRange.createStyleRange(7);
                    styleRange.start = tokenData.pos[0];
                    styleRange.length = 2;
                    arrayList.add(styleRange);
                    break;
                }
                case OPEN: 
                case CLOSE: {
                    StyleRange styleRange = EditorStyleRange.createStyleRange(8);
                    styleRange.start = tokenData.pos[0];
                    styleRange.length = 1;
                    arrayList.add(styleRange);
                    break;
                }
                case DEVICE: 
                case LANGUAGE: 
                case SELECTOR: 
                case JAVA_CLASS: {
                    String string;
                    StyleRange styleRange = EditorStyleRange.createStyleRange(1);
                    styleRange.start = tokenData.pos[0];
                    styleRange.length = 1;
                    arrayList.add(styleRange);
                    styleRange = EditorStyleRange.createStyleRange(2);
                    styleRange.start = tokenData.pos[1];
                    styleRange.length = tokenData.token.length;
                    arrayList.add(styleRange);
                    styleRange = EditorStyleRange.createStyleRange(3);
                    styleRange.start = tokenData.pos[2];
                    styleRange.length = 1;
                    arrayList.add(styleRange);
                    styleRange = EditorStyleRange.createStyleRange(5);
                    switch (tokenData.token) {
                        case DEVICE: {
                            if (DeviceMatch.exists((String)tokenData.text)) break;
                            styleRange.foreground = applicationUI.errorForeground;
                            styleRange.background = applicationUI.errorBackground;
                            break;
                        }
                        case LANGUAGE: {
                            if (LanguageMatch.exists((String)tokenData.text)) break;
                            styleRange.foreground = applicationUI.errorForeground;
                            styleRange.background = applicationUI.errorBackground;
                            break;
                        }
                        case SELECTOR: {
                            string = editorSelector.getPropFromReference(tokenData.text);
                            if (string instanceof EditorSelector && (!(string instanceof EditorSelector) || !string.hasPropError())) break;
                            styleRange.foreground = applicationUI.errorForeground;
                            styleRange.background = applicationUI.errorBackground;
                            break;
                        }
                        case JAVA_CLASS: {
                            try {
                                IType iType = editorSelector.getDesigner().getModel().getJavaProject().findType(tokenData.text);
                                if (iType != null && JavaHelper.validateClass(iType, ISelectorExpression.class.getName()) == null) break;
                                if (iType == null) {
                                    styleRange.foreground = applicationUI.errorForeground;
                                    styleRange.background = applicationUI.errorBackground;
                                    break;
                                }
                                styleRange.foreground = applicationUI.warningForeground;
                                styleRange.background = applicationUI.warningBackground;
                                break;
                            }
                            catch (JavaModelException javaModelException) {
                                // empty catch block
                            }
                        }
                    }
                    styleRange.start = tokenData.pos[3];
                    styleRange.length = tokenData.getQuotedStringLength();
                    arrayList.add(styleRange);
                    styleRange = EditorStyleRange.createStyleRange(1);
                    styleRange.start = tokenData.pos[4];
                    styleRange.length = 1;
                    arrayList.add(styleRange);
                    break;
                }
                case WILD_CARD: 
                case REG_EXP: {
                    StyleRange styleRange = EditorStyleRange.createStyleRange(1);
                    styleRange.start = tokenData.pos[0];
                    styleRange.length = 1;
                    arrayList.add(styleRange);
                    styleRange = EditorStyleRange.createStyleRange(2);
                    styleRange.start = tokenData.pos[1];
                    styleRange.length = tokenData.token.length;
                    arrayList.add(styleRange);
                    styleRange = EditorStyleRange.createStyleRange(3);
                    styleRange.start = tokenData.pos[2];
                    styleRange.length = 1;
                    arrayList.add(styleRange);
                    styleRange = EditorStyleRange.createStyleRange(4);
                    String string = (String)map.get(tokenData.text);
                    if (string == null) {
                        styleRange.foreground = applicationUI.warningForeground;
                        styleRange.background = applicationUI.warningBackground;
                    }
                    styleRange.start = tokenData.pos[3];
                    styleRange.length = tokenData.text.length();
                    arrayList.add(styleRange);
                    styleRange = EditorStyleRange.createStyleRange(3);
                    styleRange.start = tokenData.pos[4];
                    styleRange.length = 1;
                    arrayList.add(styleRange);
                    styleRange = EditorStyleRange.createStyleRange(5);
                    if (string != null) {
                        boolean bl;
                        boolean bl2 = tokenData.token == SelectorExpression.Token.WILD_CARD ? WindowsLikeFilenameFilter.isMatching((String)string, (String)tokenData.match, (boolean)true, (boolean)false) : (bl = tokenData.pattern != null && tokenData.pattern.matcher(string).matches());
                        if (!bl) {
                            styleRange.foreground = applicationUI.warningForeground;
                            styleRange.background = applicationUI.warningBackground;
                        }
                    }
                    styleRange.start = tokenData.pos[5];
                    styleRange.length = tokenData.getQuotedStringLength();
                    arrayList.add(styleRange);
                    styleRange = EditorStyleRange.createStyleRange(1);
                    styleRange.start = tokenData.pos[6];
                    styleRange.length = 1;
                    arrayList.add(styleRange);
                }
            }
        }
        return arrayList.toArray(new StyleRange[arrayList.size()]);
    }
}

