/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.IPropertyEditorController;
import com.iizigo.prop.PropertyEditorInfo;
import com.iizigo.prop.editor.IEntryValidator;
import com.iizix.prop.PropCnr;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.zone.ZoneRulesException;

public class TimeZoneValidator
implements IEntryValidator {
    @Override
    public String validate(IPropertyEditorController iPropertyEditorController, PropertyEditorInfo propertyEditorInfo, PropCnr[] propCnrArray, String string, String[] stringArray) {
        if (string == null || string.isEmpty() || string == "GMT") {
            return null;
        }
        try {
            ZoneId.of(string);
            return null;
        }
        catch (ZoneRulesException zoneRulesException) {
            return "The zone ID is a region ID that cannot be found";
        }
        catch (DateTimeException dateTimeException) {
            return "The zone ID has an invalid format";
        }
    }

    @Override
    public String getDescription(IPropertyEditorController iPropertyEditorController, PropertyEditorInfo propertyEditorInfo, PropCnr[] propCnrArray, String[] stringArray) {
        return "Enter a Zone ID such as:\n - 'Z', resulting in UTC or GMT\n - Zone starting with with '+' or '-', the ID is parsed as a Zone Offset\n - 'Z', 'GMT', 'UTC' or 'UT' are all the same as UTC or GMT\n - Zone starting with 'UTC+', 'UTC-', 'GMT+', 'GMT-', 'UT+' or 'UT-'then the ID is a prefixed offset-based ID. The ID is split in two, witha two or three letter prefix and a suffix starting with the sign.The suffix is parsed as a ZoneOffset.The result will be a ZoneId with the specified UTC/GMT/UT prefixand the normalized offset ID as per Zone Offset\n - All zone IDs are parsed as region-based zone IDs.\n   Region IDs must match the regular expression [A-Za-z][A-Za-z0-9~/._+-].\n   Detailed format of the region ID depends on the group supplying the data.\n   The default set of data is supplied by the IANA Time Zone Database (TZDB).\n   This has region IDs of the form '{area}/{city}', such as 'Europe/Paris' or 'America/New_York'.";
    }
}

