/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.BaseEditor;
import com.iizigo.prop.editor.dialog.StringMapPropDialog;
import com.iizix.prop.StringMapProp;
import com.iizix.swt.widget.IZ_Label;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public class StringMapPropEditor
extends BaseEditor<StringMapProp, Map<String, String>> {
    private IZ_Label a;

    @Override
    protected void create() {
        this.createGridLayout(2, 0);
        this.createMoreButton("Open String map editor");
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 2;
        this.a = new IZ_Label(this.parent, 16384);
        this.a.setBackground(this.appUI.propEditorBackground);
        this.a.setLayoutData(gridData);
        this.a.addListener(8, event -> this.onMore());
    }

    @Override
    protected void setColors(Control ... controlArray) {
        super.setColors(new Control[]{this.a});
    }

    @Override
    public void onMore() {
        this.more.setFocus();
        LinkedHashMap<String, String> linkedHashMap = (LinkedHashMap<String, String>)this.getCurrentValue();
        linkedHashMap = new StringMapPropDialog(this.shell, (Map<String, String>)linkedHashMap).open();
        if (linkedHashMap != null) {
            this.setCurrentValue(linkedHashMap);
        }
        this.more.setFocus();
    }

    @Override
    public void onUndefined() {
        this.onUpdate(null);
    }

    @Override
    public void onUpdate(Map<String, String> map) {
        if (map == null) {
            this.a.setText("(undefined)");
            this.a.setForeground(this.appUI.gray);
            this.a.setToolTipText(null);
        } else {
            int n2 = map.size();
            this.a.setText((String)(n2 == 0 ? "[empty]" : (n2 == 1 ? "one entry" : Integer.toString(n2) + " entries")));
            this.a.setForeground(null);
            this.a.setToolTipText(this.getToolTipText());
        }
    }

    @Override
    protected String getToolTipText() {
        Map map = (Map)this.getCurrentValue();
        if (map == null) {
            return "String map: (undefined)";
        }
        int n2 = map.size();
        StringBuilder stringBuilder = new StringBuilder("String map - ").append((String)(n2 == 0 ? "[empty]" : (n2 == 1 ? "one entry" : Integer.toString(n2) + " entries")));
        for (Map.Entry entry : map.entrySet()) {
            stringBuilder.append("\n - ").append((String)entry.getKey()).append('=').append((String)entry.getValue());
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<String, String> getDefaultValue() {
        return new LinkedHashMap<String, String>();
    }

    @Override
    protected Map<String, String> getValue(String string) throws Exception {
        throw new Exception("never used");
    }

    @Override
    public String formatValue(Map<String, String> map) {
        return map.toString();
    }
}

