/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.editor;

import com.iizigo.editor.j;
import com.iizigo.editor.k;
import com.iizigo.project.ModuleFolder;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.IPropDesigner;
import com.iizix.prop.GProp;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;

public class MovePropertyResources {
    public static String validateMoveProperties(GProp<?>[] gPropArray, DesignerProp designerProp) {
        return MovePropertyResources.a(gPropArray, designerProp);
    }

    private static String a(GProp<?>[] gPropArray, DesignerProp designerProp) {
        IResource iResource = designerProp.getIResource();
        if (!(iResource instanceof IFolder)) {
            return "Target is not a folder";
        }
        IFolder iFolder = (IFolder)iResource;
        ModuleFolder moduleFolder = designerProp.getFolder();
        if (moduleFolder == null) {
            return "Target is not in IIZI Module Folder";
        }
        String string = moduleFolder.extension;
        GProp<?>[] gPropArray2 = gPropArray;
        int n2 = gPropArray.length;
        int n3 = 0;
        while (n3 < n2) {
            GProp<?> gProp = gPropArray2[n3];
            if (gProp.isPropReadOnly()) {
                return "Property is read-only";
            }
            if (!(gProp instanceof IPropDesigner)) {
                return "Property not instanceof IPropDesigner";
            }
            IPropDesigner iPropDesigner = (IPropDesigner)gProp;
            DesignerProp designerProp2 = iPropDesigner.getDesigner();
            if (designerProp2.isRoot) {
                return "Module Root cannot be moved";
            }
            if (designerProp2.isFolder) {
                return "Module Folder cannot be moved";
            }
            iResource = designerProp2.getIResource();
            if (iResource == null) {
                return "No resource for property";
            }
            String string2 = iResource.getName();
            if (!string.isEmpty() && !string2.endsWith(string)) {
                return "Invalid resource name extension";
            }
            if (iResource instanceof IFile) {
                if (iFolder.getFile(string2).exists()) {
                    return "Resource already exists for source file";
                }
            } else if (iResource instanceof IFolder) {
                if (iFolder.getFolder(string2).exists()) {
                    return "Resource already exists for source folder";
                }
            } else {
                return "Source is not a file or a folder";
            }
            ++n3;
        }
        return null;
    }

    public static String performMoveProperties(Shell shell, GProp<?>[] gPropArray, DesignerProp designerProp) {
        GProp<?> gProp;
        String string = MovePropertyResources.a(gPropArray, designerProp);
        if (string != null) {
            return string;
        }
        int n2 = gPropArray.length;
        IResource[] iResourceArray = new IResource[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            iResourceArray[n3] = ((IPropDesigner)gPropArray[n3]).getDesigner().getIResource();
        }
        HashSet<IProject> hashSet = new HashSet<IProject>();
        IProject iProject = designerProp.getIResource().getProject();
        if (iProject != null) {
            hashSet.add(iProject);
        }
        GProp<?>[] gPropArray2 = gPropArray;
        int n4 = gPropArray.length;
        int n5 = 0;
        while (n5 < n4) {
            IPropDesigner iPropDesigner;
            IResource iResource;
            gProp = gPropArray2[n5];
            if (gProp instanceof IPropDesigner && (iResource = (iPropDesigner = (IPropDesigner)gProp).getDesigner().getIResource()) != null && (iProject = iResource.getProject()) != null) {
                hashSet.add(iProject);
            }
            ++n5;
        }
        gProp = n2 > 0 ? "Move Elements" : "Move Element";
        j j2 = new j(iResourceArray, designerProp.getIResource().getFullPath(), (String)gProp, hashSet);
        k k2 = new k((String)gProp, j2, shell, (String)gProp);
        k2.setUser(true);
        k2.schedule();
        return null;
    }
}

