/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.server.launch;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.editor.PropEditorPart;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ProjectManager;
import com.iizigo.server.launch.DevelServerLaunchConfigurationTab;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DevelServerLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection iSelection, String string) {
        this.a(this.getLaunchConfigurations(iSelection), string);
    }

    public void launch(IEditorPart iEditorPart, String string) {
        this.a(this.getLaunchConfigurations(iEditorPart), string);
    }

    private void a(ILaunchConfiguration[] iLaunchConfigurationArray, String string) {
        block8: {
            Shell shell;
            block9: {
                if (iLaunchConfigurationArray == null) {
                    Activator.openError("IIZI Development Server Launch", "This operation is only valid on IIZI Module projects.");
                    return;
                }
                shell = Activator.getSomeShell();
                if (iLaunchConfigurationArray.length != 0) break block9;
                if (!MessageDialog.openQuestion((Shell)shell, (String)"IIZI Development Server Launch", (String)"No configured IIZI Development Server configuration is found.\n\nDo you wish to configure one now?")) break block8;
                ILaunchGroup[] iLaunchGroupArray = DebugUITools.getLaunchGroups();
                int n2 = iLaunchGroupArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    ILaunchGroup iLaunchGroup = iLaunchGroupArray[n3];
                    if (iLaunchGroup.getMode().equals(string) && iLaunchGroup.getCategory() == null) {
                        ILaunchConfigurationType iLaunchConfigurationType = DevelServerLaunchShortcut.a();
                        StructuredSelection structuredSelection = iLaunchConfigurationType != null ? new StructuredSelection((Object)iLaunchConfigurationType) : null;
                        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)shell, (IStructuredSelection)structuredSelection, (String)iLaunchGroup.getIdentifier());
                        break block8;
                    }
                    ++n3;
                }
                break block8;
            }
            ILaunchConfiguration iLaunchConfiguration = DevelServerLaunchShortcut.a(shell, iLaunchConfigurationArray, string, true);
            if (iLaunchConfiguration == null) break block8;
            if (DevelServerLaunchConfigurationTab.isConfigurationValid(iLaunchConfiguration)) {
                DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
            } else if (MessageDialog.openQuestion((Shell)shell, (String)"IIZI Development Server Launch", (String)"Problems were detected in the configuration.\n\nDo you wish to configure it now?")) {
                ILaunchGroup[] iLaunchGroupArray = DebugUITools.getLaunchGroups();
                int n4 = iLaunchGroupArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    ILaunchGroup iLaunchGroup = iLaunchGroupArray[n5];
                    if (iLaunchGroup.getMode().equals(string) && iLaunchGroup.getCategory() == null) {
                        StructuredSelection structuredSelection = new StructuredSelection((Object)iLaunchConfiguration);
                        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)shell, (IStructuredSelection)structuredSelection, (String)iLaunchGroup.getIdentifier());
                        break;
                    }
                    ++n5;
                }
            }
        }
    }

    public IResource getLaunchableResource(ISelection iSelection) {
        return Activator.getSelectedProject(iSelection);
    }

    public IResource getLaunchableResource(IEditorPart iEditorPart) {
        IProject iProject;
        PropEditorPart propEditorPart;
        ModuleModel moduleModel;
        if (iEditorPart instanceof PropEditorPart && (moduleModel = (propEditorPart = (PropEditorPart)iEditorPart).getModuleModel()) != null && (iProject = moduleModel.getProject()) != null) {
            return iProject;
        }
        return (IResource)iEditorPart.getEditorInput().getAdapter(IResource.class);
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection iSelection) {
        return DevelServerLaunchShortcut.a(Activator.getSelectedProject(iSelection));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart iEditorPart) {
        IResource iResource = this.getLaunchableResource(iEditorPart);
        return iResource != null ? DevelServerLaunchShortcut.a(iResource.getProject()) : null;
    }

    private static ILaunchConfiguration[] a(IProject iProject) {
        if (iProject == null) {
            return null;
        }
        if (!ProjectManager.getInstance().isRegistered(iProject)) {
            return new ILaunchConfiguration[0];
        }
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("com.iizigo.develserver");
        if (iLaunchConfigurationType == null) {
            return null;
        }
        try {
            String string = iProject.getName();
            ArrayList<ILaunchConfiguration> arrayList = new ArrayList<ILaunchConfiguration>();
            ILaunchConfiguration[] iLaunchConfigurationArray = iLaunchManager.getLaunchConfigurations(iLaunchConfigurationType);
            int n2 = iLaunchConfigurationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n3];
                if (string.equals(iLaunchConfiguration.getAttribute("com.iizigo.moduleProject", ""))) {
                    arrayList.add(iLaunchConfiguration);
                }
                ++n3;
            }
            return arrayList.toArray(new ILaunchConfiguration[arrayList.size()]);
        }
        catch (CoreException coreException) {
            Activator.openError("Failed Launch Configuration", coreException);
            return new ILaunchConfiguration[0];
        }
    }

    private static ILaunchConfigurationType a() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.iizigo.develserver");
    }

    private static ILaunchConfiguration a(Shell shell, ILaunchConfiguration[] iLaunchConfigurationArray, String string, boolean bl) {
        String string2;
        ILaunchConfiguration iLaunchConfiguration;
        if (iLaunchConfigurationArray == null || iLaunchConfigurationArray.length == 0) {
            return null;
        }
        if (iLaunchConfigurationArray.length == 1) {
            return iLaunchConfigurationArray[0];
        }
        if (bl && (iLaunchConfiguration = DebugUITools.getLastLaunch((String)string)) != null) {
            string2 = iLaunchConfiguration.getName();
            ILaunchConfiguration[] iLaunchConfigurationArray2 = iLaunchConfigurationArray;
            int n2 = iLaunchConfigurationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ILaunchConfiguration iLaunchConfiguration2 = iLaunchConfigurationArray2[n3];
                if (string2.equals(iLaunchConfiguration2.getName())) {
                    return iLaunchConfiguration2;
                }
                ++n3;
            }
        }
        if (shell == null) {
            shell = Activator.getSomeShell();
        }
        iLaunchConfiguration = DebugUITools.newDebugModelPresentation();
        try {
            string2 = new ElementListSelectionDialog(shell, (ILabelProvider)iLaunchConfiguration);
            string2.setImage(ApplicationUI.getInstance().imageIizi);
            string2.setTitle("Select Configuration");
            string2.setMessage("&Select IIZI Development Server configuration to launch:");
            string2.setMultipleSelection(false);
            string2.setElements((Object[])iLaunchConfigurationArray);
            int n4 = string2.open();
            ILaunchConfiguration iLaunchConfiguration3 = n4 == 0 ? (ILaunchConfiguration)string2.getFirstResult() : null;
            return iLaunchConfiguration3;
        }
        finally {
            iLaunchConfiguration.dispose();
        }
    }
}

