/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.project;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.ImageRegistry;
import com.iizigo.editor.CreateResourcesFromProperties;
import com.iizigo.editor.PropEditorPart;
import com.iizigo.editor.PropHelper;
import com.iizigo.editor.complex.ComplexOperation;
import com.iizigo.font.CSSFontDefinition;
import com.iizigo.font.CSSFontIcon;
import com.iizigo.font.prop.EditorFontFiles;
import com.iizigo.image.prop.EditorFontIconDefinition;
import com.iizigo.image.prop.EditorFontIconsDefinition;
import com.iizigo.panel.PanelEditor;
import com.iizigo.panel.prop.EUILabel;
import com.iizigo.panel.prop.EUIPanel;
import com.iizigo.plugin.PluginDescriptor;
import com.iizigo.project.FileExtension;
import com.iizigo.project.Folder;
import com.iizigo.project.ModuleFolderPropCnr;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ModuleNature;
import com.iizigo.project.ProjectManager;
import com.iizigo.prop.EditorFolderSettingsProp;
import com.iizigo.prop.FilePropCnr;
import com.iizigo.selector.prop.EditorSelector;
import com.iizigo.selector.prop.EditorSelectorReference;
import com.iizigo.setup.UIFeedBack;
import com.iizigo.validator.ControlValidator;
import com.iizigo.validator.IValidationMessage;
import com.iizigo.validator.ValidatorManager;
import com.iizigo.vs.prop.EditorVirtualSpace;
import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.js.JSFiles;
import com.iizix.prop.Atom;
import com.iizix.prop.IComplexOperation;
import com.iizix.prop.IGProp;
import com.iizix.prop.KStringProp;
import com.iizix.prop.ModuleApp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.ReferenceString;
import com.iizix.prop.ui.device.GSimpleDevice;
import com.iizix.prop.ui.device.GThemes;
import com.iizix.prop.ui.device.ThemesProp;
import com.iizix.prop.vs.IVSParticipant;
import com.iizix.prop.vs.VSReference;
import com.iizix.text.KString;
import com.iizix.text.KStringException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class NewModuleProjectWizardStartupPage1
extends WizardPage
implements IValidationMessage {
    private static final String[] a = new String[]{"phone", "tablet", "desktop"};
    private final Runnable a;
    private final int a;
    private ValidatorManager a;
    public boolean hasDesktop = true;
    public boolean hasTablet = true;
    public boolean hasPhone = true;
    public boolean useTextTables = true;
    private final ArrayList<IFile> a;
    private IFile a;
    private IFile b;
    private IFile c;
    private List<EUIPanel> a;
    private Button a;
    private Button b;
    private Button c;
    private String a;
    private Text a;
    private IProject a = new ArrayList();

    public NewModuleProjectWizardStartupPage1(int n2) {
        this(n2, null);
    }

    public NewModuleProjectWizardStartupPage1(int n2, Runnable runnable) {
        super(NewModuleProjectWizardStartupPage1.class.getName(), "Create IIZI Module Project", ImageRegistry.getInstance().get("large/new_iizi_module.png"));
        this.a = runnable;
        this.a = n2;
        this.setDescription("Enter project name and select options.");
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.a != null) {
            this.a.setFocus();
        }
    }

    public void createControl(Composite composite) {
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        GridLayout gridLayout = new GridLayout(2, false);
        if (this.a != null) {
            gridLayout.marginWidth = gridLayout.marginHeight = applicationUI.s10();
        }
        int n2 = gridLayout.horizontalSpacing = applicationUI.s15();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        this.setControl((Control)composite2);
        this.setPageComplete(false);
        GridData gridData = new GridData(4, 128, true, false, 2, 1);
        gridData.widthHint = this.a;
        Label label = new Label(composite2, 64);
        label.setLayoutData((Object)gridData);
        label.setText("Choose what to create in a ready-made project containing panels, text tables with automatic translation in order to get you started quickly.");
        new Label(composite2, 0).setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.a = new ValidatorManager(this);
        label = new Label(composite2, 0);
        label.setText("Project name: ");
        this.a = new Text(composite2, 2052);
        this.a.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ControlValidator controlValidator2 = this.a.newValidator(this.a, "Project", true);
        controlValidator2.setValidatorCallback((controlValidator, string) -> {
            this.a = string;
            String string2 = Atom.validateName((String)string, (boolean)false);
            if (string2 != null) {
                controlValidator.setErrorMessage("Project name " + string2);
                return false;
            }
            File file = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            File file2 = new File(file, this.a);
            try {
                file2 = Utilities.getCanonicalFile((File)file2).toPath().toFile();
                if (file2.exists()) {
                    controlValidator.setErrorMessage("Project '" + file2.getName() + "' already exists");
                    return false;
                }
            }
            catch (InvalidPathException invalidPathException) {
                controlValidator.setErrorMessage("Project '" + file2.getName() + "' is not valid: " + invalidPathException.getMessage());
                return false;
            }
            return true;
        });
        gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
        gridData.verticalIndent = 15;
        label = new Label(composite2, 0);
        label.setLayoutData((Object)gridData);
        label.setText("Choose the device types that your app targets:");
        gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
        int n3 = gridData.horizontalIndent = applicationUI.s20();
        this.a = new Button(composite2, 32);
        this.a.setLayoutData((Object)gridData);
        this.a.setText("Phone");
        this.a.setSelection(this.hasPhone);
        this.a.addListener(13, event -> {
            this.hasPhone = this.a.getSelection();
            this.a();
        });
        gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
        gridData.horizontalIndent = n3;
        this.b = new Button(composite2, 32);
        this.b.setLayoutData((Object)gridData);
        this.b.setText("Tablet");
        this.b.setSelection(this.hasTablet);
        this.b.addListener(13, event -> {
            this.hasTablet = this.b.getSelection();
            this.a();
        });
        gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
        gridData.horizontalIndent = n3;
        this.c = new Button(composite2, 32);
        this.c.setLayoutData((Object)gridData);
        this.c.setText("Desktop");
        this.c.setSelection(this.hasDesktop);
        this.c.addListener(13, event -> {
            this.hasDesktop = this.c.getSelection();
            this.a();
        });
        gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
        gridData.verticalIndent = n2;
        label = new Label(composite2, 0);
        label.setLayoutData((Object)gridData);
        label.setText("Does your app target multiple languages?");
        gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
        gridData.horizontalIndent = n3;
        Button button = new Button(composite2, 32);
        button.setLayoutData((Object)gridData);
        button.setText("Create text tables with automatic translation");
        button.setSelection(this.useTextTables);
        button.addListener(13, event -> {
            this.useTextTables = button.getSelection();
            this.a();
        });
        if (this.a != null) {
            gridData = new GridData(4, 0x1000000, true, false, 2, 1);
            gridData.verticalIndent = n3;
            label = new Label(composite2, 258);
            label.setLayoutData((Object)gridData);
            gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
            gridData.verticalIndent = n3;
            Button button2 = new Button(composite2, 8);
            button2.setLayoutData((Object)gridData);
            button2.setText("     Skip project creation     ");
            button2.addListener(13, event -> {
                if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Confirm skip project creation", (String)"Please confirm that you do not wish to create a project.")) {
                    this.a.run();
                }
            });
        }
    }

    private void a() {
        this.a.validate();
    }

    @Override
    public void onValidate(boolean bl) {
        this.setPageComplete(bl && (this.hasDesktop || this.hasTablet || this.hasPhone));
        IWizardContainer iWizardContainer = this.getContainer();
        if (iWizardContainer != null) {
            iWizardContainer.updateButtons();
        }
    }

    IProject a(UIFeedBack<String> uIFeedBack, String string, Map<Atom, KString> map, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        this.a.clear();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        this.a = iWorkspaceRoot.getProject(this.a);
        this.a.create(iProgressMonitor);
        this.a.open(iProgressMonitor);
        IFolder iFolder = this.a.getFolder("src");
        iFolder.create(false, true, iProgressMonitor);
        IFolder iFolder2 = this.a.getFolder("bin");
        iFolder2.create(false, true, iProgressMonitor);
        IProjectDescription iProjectDescription = this.a.getDescription();
        iProjectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        this.a.setDescription(iProjectDescription, iProgressMonitor);
        IJavaProject iJavaProject = JavaCore.create((IProject)this.a);
        iJavaProject.setOutputLocation(iFolder2.getFullPath(), iProgressMonitor);
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        arrayList.add(JavaRuntime.getDefaultJREContainerEntry());
        IPackageFragmentRoot iPackageFragmentRoot = iJavaProject.getPackageFragmentRoot((IResource)iFolder);
        arrayList.add(JavaCore.newSourceEntry((IPath)iPackageFragmentRoot.getPath()));
        iJavaProject.setRawClasspath(arrayList.toArray(new IClasspathEntry[arrayList.size()]), iProgressMonitor);
        ModuleNature.associateNature(this.a, new PluginDescriptor[0], iProgressMonitor);
        iProgressMonitor.worked(1);
        ModuleModel moduleModel = ProjectManager.getInstance().getModuleModel(this.a);
        ArrayList<EditorSelector> arrayList2 = new ArrayList<EditorSelector>();
        if (this.hasPhone) {
            arrayList2.addAll(EditorSelector.createDefaultSelectorsForPhone(true, moduleModel));
        }
        if (this.hasTablet) {
            arrayList2.addAll(EditorSelector.createDefaultSelectorsForTablet(true, moduleModel));
        }
        if (this.hasDesktop) {
            arrayList2.addAll(EditorSelector.createDefaultSelectorsForDesktop(true, moduleModel));
        }
        for (EditorSelector iPropDesigner2 : arrayList2) {
            object = (FilePropCnr)iPropDesigner2.getParent();
            this.a.add(((FilePropCnr)object).getIFile());
        }
        iProgressMonitor.worked(1);
        ModuleFolderPropCnr moduleFolderPropCnr = moduleModel.getPanelModuleFolder().getContainer();
        IFolder iFolder3 = moduleFolderPropCnr.getIFolder();
        object = this.getClass();
        String string2 = ((Class)object).getName();
        string2 = string2.substring(0, string2.lastIndexOf(46)).replace('.', '/');
        ClassLoader classLoader = ((Class)object).getClassLoader();
        ClassLoader classLoader2 = JSFiles.class.getClassLoader();
        if (this.hasPhone) {
            this.a = this.a(classLoader, string2, iFolder3, "phone", "MainPhone", true, string, map, iProgressMonitor);
        }
        if (this.hasTablet) {
            this.b = this.a(classLoader, string2, iFolder3, "tablet", "MainTablet", true, string, map, iProgressMonitor);
        }
        if (this.hasDesktop) {
            this.c = this.a(classLoader, string2, iFolder3, "desktop", "MainDesktop", false, string, map, iProgressMonitor);
        }
        iProgressMonitor.worked(1);
        String string3 = "creating VirtualSpace";
        try {
            this.a(moduleModel, classLoader, string2, iProgressMonitor);
            iProgressMonitor.worked(1);
            string3 = "create IIZI Module App settings";
            this.b(moduleModel, classLoader, string2, iProgressMonitor);
            iProgressMonitor.worked(1);
            string3 = "creating FontAwesome font";
            this.a(uIFeedBack.getDialogShell(), moduleModel, classLoader2, iProgressMonitor);
            iProgressMonitor.worked(1);
        }
        catch (PropException | IOException | ExecutionException throwable) {
            String string4 = "Failed " + string3;
            ILog.SEVERE(this.getClass(), (String)string4, (Throwable)throwable);
            throw new CoreException((IStatus)Activator.createErrorStatus(string4, throwable));
        }
        return this.a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(Shell shell, ModuleModel moduleModel, ClassLoader classLoader, IProgressMonitor iProgressMonitor) throws IOException, ExecutionException {
        Object object;
        Object object2;
        Object object3;
        InputStream inputStream;
        CSSFontDefinition cSSFontDefinition;
        Object object4;
        File file;
        String string;
        block41: {
            String string2 = "js/root/common/font-awesome/";
            string = "fontawesome-webfont";
            String string3 = string2 + string;
            URL uRL = classLoader.getResource(string2 + "font-awesome.css");
            URL uRL2 = classLoader.getResource(string3 + ".eot");
            URL uRL3 = classLoader.getResource(string3 + ".svg");
            URL uRL4 = classLoader.getResource(string3 + ".ttf");
            URL uRL5 = classLoader.getResource(string3 + ".woff");
            URL uRL6 = classLoader.getResource(string3 + ".woff2");
            file = File.createTempFile("font-awesome", ".css");
            File file2 = file.getParentFile();
            object4 = null;
            cSSFontDefinition = null;
            try {
                inputStream = uRL.openStream();
                try {
                    Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (object4 == null) {
                    object4 = throwable;
                    throw object4;
                }
                if (object4 == throwable) throw object4;
                ((Throwable)object4).addSuppressed(throwable);
                throw object4;
            }
            object4 = null;
            cSSFontDefinition = null;
            try {
                inputStream = uRL2.openStream();
                try {
                    block40: {
                        object3 = uRL3.openStream();
                        try {
                            block39: {
                                object2 = uRL4.openStream();
                                try {
                                    block38: {
                                        object = uRL5.openStream();
                                        try {
                                            try (InputStream inputStream2 = uRL6.openStream();){
                                                Files.copy(inputStream, new File(file2, string + ".eot").toPath(), StandardCopyOption.REPLACE_EXISTING);
                                                Files.copy((InputStream)object3, new File(file2, string + ".svg").toPath(), StandardCopyOption.REPLACE_EXISTING);
                                                Files.copy((InputStream)object2, new File(file2, string + ".ttf").toPath(), StandardCopyOption.REPLACE_EXISTING);
                                                Files.copy((InputStream)object, new File(file2, string + ".woff").toPath(), StandardCopyOption.REPLACE_EXISTING);
                                                Files.copy(inputStream2, new File(file2, string + ".woff2").toPath(), StandardCopyOption.REPLACE_EXISTING);
                                            }
                                            if (object == null) break block38;
                                        }
                                        catch (Throwable throwable) {
                                            if (object4 == null) {
                                                object4 = throwable;
                                            } else if (object4 != throwable) {
                                                ((Throwable)object4).addSuppressed(throwable);
                                            }
                                            if (object == null) throw object4;
                                            ((InputStream)object).close();
                                            throw object4;
                                        }
                                        ((InputStream)object).close();
                                    }
                                    if (object2 == null) break block39;
                                }
                                catch (Throwable throwable) {
                                    if (object4 == null) {
                                        object4 = throwable;
                                    } else if (object4 != throwable) {
                                        ((Throwable)object4).addSuppressed(throwable);
                                    }
                                    if (object2 == null) throw object4;
                                    ((InputStream)object2).close();
                                    throw object4;
                                }
                                ((InputStream)object2).close();
                            }
                            if (object3 == null) break block40;
                        }
                        catch (Throwable throwable) {
                            if (object4 == null) {
                                object4 = throwable;
                            } else if (object4 != throwable) {
                                ((Throwable)object4).addSuppressed(throwable);
                            }
                            if (object3 == null) throw object4;
                            ((InputStream)object3).close();
                            throw object4;
                        }
                        ((InputStream)object3).close();
                    }
                    if (inputStream == null) break block41;
                }
                catch (Throwable throwable) {
                    if (object4 == null) {
                        object4 = throwable;
                    } else if (object4 != throwable) {
                        ((Throwable)object4).addSuppressed(throwable);
                    }
                    if (inputStream == null) throw object4;
                    inputStream.close();
                    throw object4;
                }
                inputStream.close();
            }
            catch (Throwable throwable) {
                if (object4 == null) {
                    object4 = throwable;
                    throw object4;
                }
                if (object4 == throwable) throw object4;
                ((Throwable)object4).addSuppressed(throwable);
                throw object4;
            }
        }
        object4 = CSSFontDefinition.parse(file, null, true);
        cSSFontDefinition = (CSSFontDefinition)object4.get(0);
        inputStream = moduleModel.getAssetsModuleFolder().getDirectory().getFolder(string);
        object3 = new EditorFontIconsDefinition(Atom.DATA_CONTAINER);
        object3.setString("$default", cSSFontDefinition.getIconCSS());
        object2 = ((EditorFontIconsDefinition)object3).getFontFiles();
        object = this.a + ":/assets/fontawesome-webfont/";
        cSSFontDefinition.initializeFontFiles((EditorFontFiles)object2, (String)object);
        CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = cSSFontDefinition.icons.entrySet().iterator();
        while (true) {
            Object object5;
            if (!copyFilesAndFoldersOperation.hasNext()) {
                CreateFolderOperation createFolderOperation = new CreateFolderOperation((IFolder)inputStream, null, "Create assets folder");
                createFolderOperation.execute(iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
                copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(shell);
                copyFilesAndFoldersOperation.copyFilesInCurrentThread(cSSFontDefinition.getRequireFontFileNames(), (IContainer)inputStream, iProgressMonitor);
                object5 = string + Folder.IMAGE.fileExtension.extension;
                CreateResourcesFromProperties.createFile(null, "Create font icon file " + string, (IContainer)moduleModel.getImageDefinitionModuleFolder().getDirectory(), (PropCnr)object3, (String)object5, false);
                return;
            }
            Map.Entry<String, CSSFontIcon> entry = copyFilesAndFoldersOperation.next();
            object5 = entry.getKey();
            EditorFontIconDefinition editorFontIconDefinition = new EditorFontIconDefinition(object3.createUniqueAtom(Atom.createValidName((String)object5, (boolean)false)));
            editorFontIconDefinition.addProp2((IGProp)new KStringProp(Atom.TEXT, entry.getValue().contents));
            object3.addProp2((IGProp)editorFontIconDefinition);
        }
    }

    private void a(ModuleModel moduleModel, ClassLoader classLoader, String string, IProgressMonitor iProgressMonitor) throws PropException, IOException {
        URL uRL = classLoader.getResource(string + "/startup/VirtualSpace.iiziVS");
        EditorVirtualSpace editorVirtualSpace = (EditorVirtualSpace)Activator.loadPropertiesFile(uRL);
        ModuleFolderPropCnr moduleFolderPropCnr = moduleModel.getVirtualSpaceModuleFolder().getContainer();
        moduleFolderPropCnr.addProp((IGProp)editorVirtualSpace);
        IFolder iFolder = moduleFolderPropCnr.getIFolder();
        ModuleFolderPropCnr moduleFolderPropCnr2 = moduleModel.getPanelModuleFolder().getContainer();
        ComplexOperation complexOperation = new ComplexOperation("Set VirtualSpace", null, null);
        for (EUIPanel eUIPanel : this.a) {
            moduleFolderPropCnr2.addProp((IGProp)eUIPanel.getParent());
            editorVirtualSpace.getParticipantsHolder().add((IVSParticipant)eUIPanel, (IComplexOperation)complexOperation);
        }
        CreateResourcesFromProperties.createFile(null, "Create VirtualSpace", (IContainer)iFolder, (PropCnr)editorVirtualSpace, this.a + FileExtension.VIRTUAL_SPACE.extension, false, false);
    }

    private void b(ModuleModel moduleModel, ClassLoader classLoader, String string, IProgressMonitor iProgressMonitor) throws CoreException, PropException, IOException {
        URL uRL = classLoader.getResource(string + "/startup/ModuleApp.iiziModuleProject");
        PropCnr propCnr = Activator.loadPropertiesFile(uRL);
        VSReference vSReference = (VSReference)((ModuleApp)propCnr.getProp(Atom.MODULE_APP)).getProp(Atom.VIRTUALSPACE);
        vSReference.setPropValue((Object)new ReferenceString(moduleModel.getVirtualSpaceModuleFolder().getContainer().getReferencePropName() + "/" + this.a));
        IFile iFile = this.a.getFile(".iiziModuleProject");
        Activator.savePropertiesFile(propCnr, iFile, iProgressMonitor);
    }

    private IFile a(ClassLoader classLoader, String string, IFolder iFolder, String string2, String string3, boolean bl, String string4, Map<Atom, KString> map, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        IFolder iFolder2 = iFolder.getFolder(string2 + FileExtension.PANEL.extension);
        iFolder2.create(true, true, iProgressMonitor);
        EditorFolderSettingsProp editorFolderSettingsProp = new EditorFolderSettingsProp(Atom.SETTINGS);
        editorFolderSettingsProp.setString(Atom.DESCR, "Folder with Selector for panels of type " + string2);
        EditorSelectorReference editorSelectorReference = new EditorSelectorReference(Atom.SELECTOR, iFolder.getProject().getName() + ":/" + Folder.SELECTOR.folderName + "/" + string2);
        editorSelectorReference.setPropPrivate(true);
        editorFolderSettingsProp.addProp2((IGProp)editorSelectorReference);
        ThemesProp themesProp = new ThemesProp(Atom.THEMES, bl ? GThemes.DEFAULT_MOBILE : GThemes.DEFAULT_DESKTOP);
        editorFolderSettingsProp.addProp2((IGProp)themesProp);
        String string5 = CreateResourcesFromProperties.createFile(null, "Create " + string2 + " folder settings", (IContainer)iFolder2, (PropCnr)editorFolderSettingsProp, ".iiziFolder", true);
        if (string5 != null) {
            throw new CoreException((IStatus)Activator.createErrorStatus("Failed creating " + string2 + " folder settings file .iiziFolder: " + string5));
        }
        FilePropCnr filePropCnr = null;
        EUIPanel eUIPanel = null;
        Atom atom = Atom.get((String)string3);
        String string6 = string3 + FileExtension.PANEL.extension;
        URL uRL = classLoader.getResource(string + "/startup/" + string6);
        if (uRL != null) {
            try {
                object = Activator.loadPropertiesFile(uRL);
                eUIPanel = (EUIPanel)object;
                filePropCnr = new FilePropCnr(Atom.get((String)string2), null);
                filePropCnr.addProp2((IGProp)eUIPanel);
                eUIPanel.getProp(Atom.VIRTUALSPACE).setPropValue((Object)new ReferenceString(this.a + ":/vs/" + this.a));
            }
            catch (PropException | IOException throwable) {
                throw new CoreException((IStatus)Activator.createErrorStatus("Failed loading panel " + string3, throwable));
            }
        } else {
            filePropCnr = new FilePropCnr();
            eUIPanel = new EUIPanel(Atom.DATA_CONTAINER);
            filePropCnr.addProp2((IGProp)eUIPanel);
        }
        this.a.add(eUIPanel);
        if (map != null && string4 != null) {
            object = iFolder.getProject().getName() + ":/" + Folder.TEXT.folderName + "/" + string4;
            eUIPanel.setDefaultTextTable((String)object);
            EUILabel[] eUILabelArray = (EUILabel[])eUIPanel.getAllProps(EUILabel.class);
            int n2 = eUILabelArray.length;
            int n3 = 0;
            while (n3 < n2) {
                EUILabel eUILabel = eUILabelArray[n3];
                KString kString = eUILabel.getKStringText();
                if (kString != null) {
                    atom = eUILabel.getPropAtom();
                    map.put(atom, kString);
                    try {
                        kString = new KString(KString.Type.HTML, "<IZ type=\"tt\" ref=\"" + (String)object + "/" + atom.getAtomName() + "\">", true);
                        eUILabel.setText(kString);
                    }
                    catch (KStringException kStringException) {
                        throw new InternalError("Shouldn't be", kStringException);
                    }
                }
                ++n3;
            }
        }
        if ((string5 = CreateResourcesFromProperties.createFile(null, "Create " + string2 + " panel", (IContainer)iFolder2, (PropCnr)eUIPanel, string6, false, false)) != null) {
            throw new CoreException((IStatus)Activator.createErrorStatus("Failed creating panel " + string2 + ": " + string5));
        }
        object = iFolder2.getFile(string6);
        this.a.add(object);
        return object;
    }

    void a(UIFeedBack<?> uIFeedBack) {
        PanelEditor[] panelEditorArray = new PanelEditor[3];
        String[] stringArray = new String[]{uIFeedBack.updateFeedBack("Opening phone panel")};
        try {
            uIFeedBack.getDisplay().syncExec(() -> {
                IEditorPart iEditorPart;
                Object object;
                Object object2;
                IEditorPart iEditorPart2 = PropHelper.doOpen(this.a);
                if (iEditorPart2 instanceof PanelEditor) {
                    PanelEditor panelEditor;
                    panelEditorArray[0] = panelEditor = (PanelEditor)iEditorPart2;
                    object2 = panelEditor.getPartComposite();
                    if (object2 != null) {
                        object2.update();
                    }
                }
                stringArray[0] = uIFeedBack.updateFeedBack("Opening tablet panel");
                IEditorPart iEditorPart3 = PropHelper.doOpen(this.b);
                if (iEditorPart3 instanceof PanelEditor) {
                    object2 = (PanelEditor)iEditorPart3;
                    panelEditorArray[1] = object2;
                    object = ((PropEditorPart)object2).getPartComposite();
                    if (object != null) {
                        object.update();
                    }
                }
                if ((iEditorPart = PropHelper.doOpen(this.c)) instanceof PanelEditor) {
                    object = (PanelEditor)iEditorPart;
                    panelEditorArray[2] = object;
                    stringArray[0] = uIFeedBack.updateFeedBack("Opening desktop panel");
                    Composite composite = ((PropEditorPart)object).getPartComposite();
                    if (composite != null) {
                        composite.update();
                    }
                }
            });
            PanelEditor panelEditor = null;
            int n2 = 0;
            while (n2 < 3) {
                PanelEditor panelEditor2 = panelEditorArray[n2];
                if (panelEditor2 != null) {
                    stringArray[0] = uIFeedBack.updateFeedBack("Preparing " + a[n2] + " panel designer");
                    if (panelEditor == null) {
                        panelEditor = panelEditor2;
                    }
                    panelEditor2.waitForClientSideEditor();
                }
                ++n2;
            }
            PanelEditor panelEditor3 = panelEditor;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            uIFeedBack.getDisplay().syncExec(() -> {
                Composite composite;
                PanelEditor panelEditor2 = panelEditorArray[0];
                if (panelEditor2 != null) {
                    stringArray[0] = uIFeedBack.updateFeedBack("Set phone panel device to iPhone Portrait");
                    panelEditor2.setDevice(GSimpleDevice.IPHONE5_PORTRAIT);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    composite = panelEditor2.getPartComposite();
                    composite.update();
                }
                if ((panelEditor2 = panelEditorArray[1]) != null) {
                    stringArray[0] = uIFeedBack.updateFeedBack("Set tablet panel device to iPad Landscape");
                    panelEditor2.setDevice(GSimpleDevice.IPAD_LANDSCAPE);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    composite = panelEditor2.getPartComposite();
                    composite.update();
                }
                if ((panelEditor2 = panelEditorArray[2]) != null) {
                    panelEditor2.setDevice(GSimpleDevice.BROWSER);
                }
                if (panelEditor3 != null) {
                    boolean bl = true;
                    IWorkbenchPage iWorkbenchPage = panelEditor3.getSite().getWorkbenchWindow().getActivePage();
                    int n2 = 2;
                    while (--n2 >= 0) {
                        panelEditor2 = panelEditorArray[n2];
                        if (panelEditor2 == null) continue;
                        stringArray[0] = uIFeedBack.updateFeedBack("Activating mobile " + a[n2] + " panel");
                        iWorkbenchPage.activate((IWorkbenchPart)panelEditor2);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        stringArray[0] = uIFeedBack.updateFeedBack("Fitting size of mobile " + a[n2] + " panel");
                        panelEditor2.setFitNow();
                        if (panelEditor3 != panelEditor2) continue;
                        bl = false;
                    }
                    if (bl) {
                        stringArray[0] = uIFeedBack.updateFeedBack("Activating first panel " + panelEditor3.getTitle());
                        iWorkbenchPage.activate((IWorkbenchPart)panelEditor3);
                        Composite composite2 = panelEditor3.getPartComposite();
                        composite2.update();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            String string = "Failed " + stringArray[0];
            ILog.SEVERE(this.getClass(), (String)string, (Throwable)throwable);
            Activator.openError(uIFeedBack.getDialogShell(), "Open Panel Error", string + ": " + throwable.getMessage());
        }
    }

    public String getProjectName() {
        return this.a;
    }
}

