/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.java.classpath;

import com.iizigo.ApplicationUI;
import com.iizigo.ImageRegistry;
import com.iizigo.java.classpath.IzClasspathContainer;
import com.iizigo.project.ProjectManager;
import com.iizix.ILog;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IzClasspathContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    public static final String ID = "com.iizigo.classpath";
    private IzClasspathContainer.Type a;
    private HashMap<IzClasspathContainer.Type, Button> a;
    private boolean a;
    private final ApplicationUI a = ApplicationUI.getInstance();

    public IzClasspathContainerPage() {
        super(ID, "IIZI Libraries", ImageRegistry.getInstance().get("large/iizi_libraries.png"));
        this.setMessage("Select the IIZI Libraries type");
    }

    public void initialize(IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray) {
        if (this.a != null && iJavaProject != null) {
            Button button;
            IzClasspathContainer.Type type;
            this.a = ProjectManager.getInstance().isRegistered(iJavaProject.getProject());
            if (this.a && (type = IzClasspathContainer.Type.fromClasspathEntries(iClasspathEntryArray)) != null && (button = (Button)((HashMap)((Object)this.a)).get((Object)type)) != null) {
                this.a = type;
                button.setSelection(true);
            }
        }
    }

    public void setSelection(IClasspathEntry iClasspathEntry) {
        Button button;
        IzClasspathContainer.Type type;
        if (this.a != null && iClasspathEntry != null && (type = IzClasspathContainer.Type.fromClasspathEntry(iClasspathEntry)) != null && (button = (Button)((HashMap)((Object)this.a)).get((Object)type)) != null) {
            this.a = type;
            button.setSelection(true);
        }
    }

    public IClasspathEntry getSelection() {
        IPath iPath;
        IClasspathEntry iClasspathEntry = null;
        if (this.a != null && (iPath = this.a.getPath()) != null) {
            try {
                iClasspathEntry = JavaCore.newContainerEntry((IPath)iPath);
            }
            catch (Throwable throwable) {
                ILog.WARNING(((Object)((Object)this)).getClass(), (String)("Failed to get selection for path " + String.valueOf(iPath)), (Throwable)throwable);
            }
        }
        return iClasspathEntry;
    }

    public void createControl(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = gridLayout.marginHeight = this.a.s10();
        gridLayout.verticalSpacing = gridLayout.marginHeight;
        int n2 = gridLayout.marginHeight;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        this.setControl((Control)composite2);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = composite.getSize().x - n2 * 3;
        Label label = new Label(composite2, 64);
        label.setLayoutData((Object)gridData);
        Object object = "Normal applications should use the IIZI Core and Plug-in libraries that is configured automatically to include the libraries for the Module project's selected plug-in's.\n \n";
        if (!this.a) {
            object = (String)object + "Note: normally only Java projects configured as IIZI Module Projects should use the IIZI Libraries. Ignore this note if you are developing for the IIZI Server or an IIZI Plug-in.";
        }
        label.setText((String)object);
        this.a = new HashMap();
        IzClasspathContainer.Type[] typeArray = IzClasspathContainer.Type.values();
        int n3 = typeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IzClasspathContainer.Type type = typeArray[n4];
            this.a(composite2, type);
            ++n4;
        }
        this.setPageComplete(this.a != null);
    }

    private void a(Composite composite, IzClasspathContainer.Type type) {
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.horizontalIndent = this.a.s20();
        Button button = new Button(composite, 16);
        button.setLayoutData((Object)gridData);
        button.setText(type.getDescription());
        if (this.a == type) {
            button.setSelection(true);
        }
        button.addListener(13, event -> {
            if (button.getSelection()) {
                this.a = type;
                this.setPageComplete(true);
            }
        });
        ((HashMap)((Object)this.a)).put(IzClasspathContainer.Type.RUNTIME, button);
    }

    public boolean finish() {
        return true;
    }
}

