/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.java;

import com.iizigo.Startup;
import com.iizigo.java.JavaHelper;
import com.iizigo.java.JavaManager;
import com.iizigo.java.JavaProject;
import com.iizigo.java.SyncState;
import com.iizigo.java.classpath.IzClasspathContainer;
import com.iizigo.java.parser.ParsedJavaSource;
import com.iizigo.project.ProjectManager;
import com.iizix.ILog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaCompilationParticipant
extends CompilationParticipant {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void holdOperation(String string) {
        Object object = new Object();
        if (Startup.isStartingUp(() -> {
            Object object2 = object;
            synchronized (object2) {
                object.notifyAll();
            }
        })) {
            ILog.INFO(JavaCompilationParticipant.class, (String)("Pausing " + string + " during startup project loading"));
            Object object2 = object;
            synchronized (object2) {
                try {
                    object.wait(60000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ILog.INFO(JavaCompilationParticipant.class, (String)("Resuming " + string + " after startup project load"));
        }
    }

    public boolean isActive(IJavaProject iJavaProject) {
        if (Startup.isStartingUp()) {
            return false;
        }
        JavaProject javaProject = JavaManager.getInstance().getJavaProject(iJavaProject.getProject());
        return javaProject != null && javaProject.isParsingRequired();
    }

    public void cleanStarting(IJavaProject iJavaProject) {
        IProject iProject = iJavaProject.getProject();
        JavaCompilationParticipant.holdOperation("clean project \"" + iProject.getName() + "\"");
        JavaManager.getInstance().clean(iJavaProject);
        IzClasspathContainer.onProjectClean(iProject);
    }

    public int aboutToBuild(IJavaProject iJavaProject) {
        int n2;
        JavaCompilationParticipant.holdOperation("about to build project \"" + iJavaProject.getProject().getName() + "\"");
        JavaProject javaProject = JavaManager.getInstance().getJavaProject(iJavaProject.getProject());
        if (javaProject == null) {
            return 1;
        }
        SyncState.buildStarted();
        ProjectManager.getInstance().onBuildStart(iJavaProject.getProject());
        int n3 = n2 = javaProject.a() ? 2 : 1;
        if (JavaManager.DEBUG) {
            System.err.println("JavaCompilationParticipant: aboutToBuild, project " + iJavaProject.getProject().getName() + ", " + (n2 == 2 ? "NEEDS_FULL_BUILD" : "READY_FOR_BUILD"));
        }
        return n2;
    }

    public void buildStarting(BuildContext[] buildContextArray, boolean bl) {
        JavaCompilationParticipant.holdOperation("building");
        SyncState.buildStarted();
        JavaManager javaManager = JavaManager.getInstance();
        int n2 = buildContextArray.length;
        ParsedJavaSource[] parsedJavaSourceArray = new ParsedJavaSource[n2];
        int n3 = 0;
        while (n3 < n2) {
            parsedJavaSourceArray[n3] = javaManager.a(buildContextArray[n3].getFile(), null, false);
            ++n3;
        }
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        int n4 = 0;
        while (n4 < n2) {
            BuildContext buildContext = buildContextArray[n4];
            ICompilationUnit iCompilationUnit = JavaCore.createCompilationUnitFrom((IFile)buildContext.getFile());
            if (iCompilationUnit == null) {
                ILog.SEVERE(((Object)((Object)this)).getClass(), (String)("Failed getting compilation unit for file '" + String.valueOf(buildContext.getFile().getFullPath()) + "'"));
            } else {
                ASTParser aSTParser = JavaHelper.getASTParser(iCompilationUnit.getJavaProject(), -1);
                aSTParser.setKind(8);
                aSTParser.setSource(iCompilationUnit);
                aSTParser.setResolveBindings(true);
                aSTParser.setBindingsRecovery(true);
                aSTParser.setStatementsRecovery(true);
                CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST((IProgressMonitor)nullProgressMonitor);
                parsedJavaSourceArray[n4].parse(buildContext, compilationUnit);
            }
            ++n4;
        }
    }

    public void buildFinished(IJavaProject iJavaProject) {
        if (JavaManager.DEBUG) {
            System.err.println("JavaCompilationParticipant: buildFinished, project " + iJavaProject.getProject().getName());
        }
        ProjectManager.getInstance().onBuildEnd(iJavaProject.getProject());
    }

    public void reconcile(ReconcileContext reconcileContext) {
        JavaCompilationParticipant.holdOperation("reconcile");
        if (JavaManager.DEBUG) {
            System.err.println("Reconcile " + String.valueOf(reconcileContext.getWorkingCopy().getResource().getFullPath()) + ", flags = " + reconcileContext.getReconcileFlags());
        }
        JavaManager.getInstance().a(reconcileContext);
    }

    public boolean isAnnotationProcessor() {
        return false;
    }
}

