#!/bin/bash

echo ''
echo 'Starting iiziServer...'
echo ''


# Change to root directory.
cd "${0%/*}"
cd ..

# Check for param 1 "-debug" or "/debug" case insensitive.
DEBUG=''
shopt -s nocasematch
if [[ "$1" =~ [-//]debug$ ]]; then
  echo 'Enabling remote Java VM debugging on port 8888'
  DEBUG='-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,address=8888,server=y,suspend=n'
  shift
fi
shopt -u nocasematch

# Remove program name in $0.
shift

# Launch standard iiziServer with ServerAdmin app only using standard Derby database server port.

CMD="java \
 -Xmx512m -Xms256m \
 -Djava.awt.headless=true -Djava.net.preferIPv4Stack=true \
 -XX:+IgnoreUnrecognizedVMOptions --enable-preview -XX:+UseG1GC -XX:+UseStringDeduplication --add-modules=ALL-SYSTEM --enable-native-access=ALL-UNNAMED \
 -cp .:lib:lib/*:lib/asm/*:lib/bc/*:commons/*:lib/compress/*:lib/image/*:lib/jackson/*:lib/jakarta/*:lib/jna/*:lib/json/*:lib/netty/*:lib/push/*:lib/web*:lib/conscrypt/*:lib/jetty/*:lib/jetty/compress/*:lib/jetty/http2/*:lib/jetty/http3/*:lib/jetty/quic/*:lib/jetty/ee11/*:lib/jetty/websocket/*:lib/jetty/ee11-websocket/*:lib/selenium/*:lib/selenium/deps/* \
   com.iizix.server.StandardServer \
    -config  conf/config-apps-only.iiziServer \
    -dbport  1527 \
    -dbdir   db \
    -root    root \
    -app     com.iizix.server.admin -appjar apps/iiziServerAdmin.jar \
    -app     cloud.mindus.icu       -appjar apps/icu.jar \
    $@"

# Show command to execute.
echo $CMD
echo ''

# Change process from bash to the java process using exec command.
exec $CMD
