@echo off

setlocal
pushd %~dp0


::
:: --- Change to installer directory ---
::

set SERVICEDIR=%CD%
cd ..\..
set ROOTPATH=%CD%
cd %SERVICEDIR%

:: Save parameters.
set OPERATION=%1
set DISPLAYNAME=%2
set PROGRAM=%3
set JAVADIR=%4
set MEMORY=%5


::
:: --- Installation of an IIZI Service running Java ---
::
:: --- Set the Java VM and its parameters ---
::

:: The Java executable 1 or 2 (2 is preferred).
set JAVAEXE1=jre\bin\java.exe
set JAVAEXE2=bin\java.exe

:: Java options.
set JAVAOPT=-Xrs -Djava.awt.headless=true -Djava.net.preferIPv4Stack=true -XX:+IgnoreUnrecognizedVMOptions -XX:+UseG1GC -XX:+UseStringDeduplication --add-modules=ALL-SYSTEM

:: The classpath to use for iizi.
set CLASSPATH=.;lib;lib\*;lib\asm\*;lib\bc\*;commons\*;lib\compress\*;lib\image\*;lib\jackson\*;lib\jakarta\*;lib\jna\*;lib\json\*;lib\netty\*;lib\push\*;lib\web*;lib\conscrypt\*;lib\jetty\*;lib\jetty\compress\*;lib\jetty\http2\*;lib\jetty\http3\*;lib\jetty\quic\*;lib\jetty\ee11\*;lib\jetty\websocket\*;lib\jetty\ee11-websocket\*;lib\selenium\*;lib\selenium\deps\* ^

:: The service name (without spaces and quotes).
set SERVICE=%DISPLAYNAME:"=%
set SERVICE=%SERVICE: =%

echo.
echo IIZI Service installer/uninstaller
echo ----------------------------------
echo.

:: Check parameters: INSTALL|UNINSTALL serviceName [program javaHomeDir memory [program ... arguments]].

if /I "%OPERATION%"=="install"   goto install
if /I "%OPERATION%"=="uninstall" goto uninstall

echo.
echo Missing operation: must be either INSTALL or UNINSTALL.


::
:: --- Display syntax ---
::

:syntax

echo.
echo ^  Syntax: IS INSTALL serviceName program javaDir memory [program ... arguments]
echo ^  or      IS UNINSTALL serviceName
echo.
echo ^    where:
echo ^     - serviceName  is the name of the service (quotes: see below).
echo ^     - program      can be SERVER only.
echo ^     - javaDir      is the base directory for the installation of the Oracle JDK (quotes: see below).
echo ^     - memory       is the memory size in MB to use for the Java process (minimum 300 MB).
echo.
echo ^  Note: all components containing space characters must be surrounded by double quote signs like
echo ^        "Service Name" and "C:\java dir with spaces\jdk11".
echo.

goto exit


::
:: --- UNINSTALL ---
::

:uninstall

if "%SERVICE%"=="" echo. & echo Missing serviceName. & goto syntax

if not exist Sc.exe echo MISSING Sc.exe! & goto syntax

Sc.exe delete %SERVICE%
echo.
goto exit


::
:: --- INSTALL ---
::

:install

if "%SERVICE%"=="" echo. & echo Missing serviceName. & goto syntax
if /I "%PROGRAM%"=="server" goto install_server
echo.
echo Unknown program type parameter "%SERVER%", only "SERVER" or "server" is currently accepted.
goto syntax

:install_server
:: Remove quotes from Java directory.
SET JAVADIR=###%JAVADIR%###
SET JAVADIR=%JAVADIR:"###=%
SET JAVADIR=%JAVADIR:###"=%
SET JAVADIR=%JAVADIR:###=%
if "%JAVADIR%"=="" echo. & echo Missing "javaDir" parameter. & goto syntax

:: Check for Java executable.
if not exist "%JAVADIR%\%JAVAEXE%" echo MISSING Java Executable "%JAVADIR%\%JAVAEXE%" & goto syntax

:: --- Check parameters ---
if not exist "%ROOTPATH%\lib\com.iizix.standardserver-*.jar"  echo. & echo Missing "%ROOTPATH%\lib\com.iizix.standardserver-*.jar" & goto syntax

if not exist Sc.exe        echo MISSING Sc.exe!       & goto syntax
if not exist Regini.exe    echo MISSING Regini.exe!   & goto syntax
if not exist SrvAny64.exe  echo MISSING SrvAny64.exe! & goto syntax

:: Check memory.
if "%MEMORY%"=="" echo. & echo Missing memory parameter. & goto syntax


::
:: --- iiziServer ---
::

set CLASS=com.iizix.server.StandardServer
set DESCR=iizi Standard Server

set OPTS=-Xms300m -Xmx%MEMORY%m -cp %CLASSPATH% %JAVAOPT%
echo Checking Java VM version
echo.
"%JAVADIR%\%JAVAEXE%" %OPTS% -version
if errorlevel 1 echo The Java VM returned an error. & echo Command was: "%JAVADIR%\%JAVAEXE%" %OPTS% -version & goto exit
echo.
set OPTS=%OPTS% %CLASS%

:: Program arguments are all the other parameters.
shift
shift
shift
shift
:more_params
shift
if "%1"=="" goto install_service
set OPTS=%OPTS% %1
goto more_params


::
:: --- Install SrvAny64.exe as the service program ---
::

:install_service
Sc.exe create %SERVICE% binpath= %SERVICEDIR%\SrvAny64.exe DisplayName= %DISPLAYNAME%
Sc.exe description %SERVICE% "%DESCR%"
echo.

:: --- Build entries to add in the registry ---
echo \Registry\Machine\SYSTEM\CurrentControlSet\Services\%SERVICE%> _temp_.ini
echo DependOnService = REG_MULTI_SZ "RpcSs" "TcpIp">> _temp_.ini
echo Parameters>> _temp_.ini
echo ^  Application = %JAVADIR%\%JAVAEXE%>> _temp_.ini
echo ^  AppParameters = %OPTS%>> _temp_.ini
echo ^  AppDirectory = %ROOTPATH%>> _temp_.ini
echo ^  WaitTime = 0>> _temp_.ini

:: --- Add the entries in the registry ---
Regini.exe _temp_.ini
echo.

:: --- Delete _temp_.ini files ---
del _temp_.ini > nul
if errorlevel 1 echo ### ERROR DELETING _temp_.ini FILE ### & goto exit


::
:: --- Exit batch file ---
::

:exit

popd
endlocal
