(function(window,document){

const addFlag = (country, rowDiv) => {
  const r = window.flagsRoot || "";
  const colDiv = document.createElement("div");
  colDiv.classList.add("col-xl-2");
  colDiv.classList.add("col-lg-3");
  colDiv.classList.add("col-md-4");
  colDiv.classList.add("col-6");
  colDiv.id = country.code;
  const flagDiv = document.createElement("div");
  flagDiv.classList.add("flag");

  // Code
  const codeSpan = document.createElement("span");
  codeSpan.classList.add("flag-code");
  const code = document.createTextNode(country.code);
  codeSpan.appendChild(code);
  // Divider
  const dividerSpan = document.createElement("span");
  const divider = document.createTextNode(" ");
  dividerSpan.appendChild(divider);
  //Country
  const countryDiv = document.createElement("div");
  countryDiv.classList.add("flag-country");
  countryDiv.classList.add("no-wrap");
  countryDiv.title = country.name;
  const countrySpan = document.createElement("span");
  const countryName = document.createTextNode(country.name);
  countrySpan.appendChild(countryName);
  countryDiv.appendChild(codeSpan);
  countryDiv.appendChild(dividerSpan);
  countryDiv.appendChild(countrySpan);

  const flagImg = document.createElement("img");
  flagImg.classList.add("flag-img");
  flagImg.src = `${r}r/${country.code}.svg`;
  flagImg.alt = `Flag of ${country.name}`;

  const flagImgSquare = document.createElement("img");
  flagImgSquare.classList.add("flag-img-square");
  flagImgSquare.classList.add("hide");
  flagImgSquare.src = `${r}s/${country.code}.svg`;
  flagImgSquare.alt = `Flag of ${country.name}`;

  colDiv.appendChild(flagDiv);
  flagDiv.appendChild(countryDiv);
  flagDiv.appendChild(flagImg);
  flagDiv.appendChild(flagImgSquare);
  rowDiv.appendChild(colDiv);
};

const show4x3 = () => {
  const click4x3 = document.getElementById("click-4x3");
  const click1x1 = document.getElementById("click-1x1");
  click1x1.classList.remove("hide");
  click4x3.classList.add("hide");
  const flags = document.getElementsByClassName("flag-img");
  var flag;
  for (flag of flags) {
    flag.classList.remove("hide");
  }
  const flagsSquared = document.getElementsByClassName("flag-img-square");
  for (flag of flagsSquared) {
    flag.classList.add("hide");
  }
};

const show1x1 = () => {
  const click4x3 = document.getElementById("click-4x3");
  const click1x1 = document.getElementById("click-1x1");
  click4x3.classList.remove("hide");
  click1x1.classList.add("hide");
  const flagsSquared = document.getElementsByClassName("flag-img-square");
  var flag;
  for (flag of flagsSquared) {
    flag.classList.remove("hide");
  }
  const flags = document.getElementsByClassName("flag-img");
  for (flag of flags) {
    flag.classList.add("hide");
  }
};

window.onload = function () {
  const isoFlagsRow = document.getElementById("iso-flags");
  const nonIsoFlagsRow = document.getElementById("non-iso-flags");
  const click4x3 = document.getElementById("click-4x3");
  click4x3.addEventListener("click", (event) => {
    event.stopPropagation();
    event.preventDefault();
    show4x3();
  });

  const click1x1 = document.getElementById("click-1x1");
  click1x1.addEventListener("click", (event) => {
    event.stopPropagation();
    event.preventDefault();
    show1x1();
  });

  const countries = [
  {
    capital: "Georgetown",
    code: "ac",
    continent: "Africa",
    iso: 0,
    name: "Ascension Island"
  },
  {
    capital: "Andorra la Vella",
    code: "ad",
    continent: "Europe",
    iso: 1,
    name: "Andorra"
  },
  {
    capital: "Abu Dhabi",
    code: "ae",
    continent: "Asia",
    iso: 1,
    name: "United Arab Emirates"
  },
  {
    capital: "Kabul",
    code: "af",
    continent: "Asia",
    iso: 1,
    name: "Afghanistan"
  },
  {
    capital: "St. John's",
    code: "ag",
    continent: "North America",
    iso: 1,
    name: "Antigua and Barbuda"
  },
  {
    capital: "The Valley",
    code: "ai",
    continent: "North America",
    iso: 1,
    name: "Anguilla"
  },
  {
    capital: "Tirana",
    code: "al",
    continent: "Europe",
    iso: 1,
    name: "Albania"
  },
  {
    capital: "Yerevan",
    code: "am",
    continent: "Asia",
    iso: 1,
    name: "Armenia"
  },
  {
    capital: "Luanda",
    code: "ao",
    continent: "Africa",
    iso: 1,
    name: "Angola"
  },
  {
    code: "aq",
    iso: 1,
    name: "Antarctica"
  },
  {
    capital: "Buenos Aires",
    code: "ar",
    continent: "South America",
    iso: 1,
    name: "Argentina"
  },
  {
    capital: "Pago Pago",
    code: "as",
    continent: "Oceania",
    iso: 1,
    name: "American Samoa"
  },
  {
    capital: "Vienna",
    code: "at",
    continent: "Europe",
    iso: 1,
    name: "Austria"
  },
  {
    capital: "Canberra",
    code: "au",
    continent: "Oceania",
    iso: 1,
    name: "Australia"
  },
  {
    capital: "Oranjestad",
    code: "aw",
    continent: "South America",
    iso: 1,
    name: "Aruba"
  },
  {
    capital: "Mariehamn",
    code: "ax",
    continent: "Europe",
    iso: 1,
    name: "Aland Islands"
  },
  {
    capital: "Baku",
    code: "az",
    continent: "Asia",
    iso: 1,
    name: "Azerbaijan"
  },
  {
    capital: "Sarajevo",
    code: "ba",
    continent: "Europe",
    iso: 1,
    name: "Bosnia and Herzegovina"
  },
  {
    capital: "Bridgetown",
    code: "bb",
    continent: "North America",
    iso: 1,
    name: "Barbados"
  },
  {
    capital: "Dhaka",
    code: "bd",
    continent: "Asia",
    iso: 1,
    name: "Bangladesh"
  },
  {
    capital: "Brussels",
    code: "be",
    continent: "Europe",
    iso: 1,
    name: "Belgium"
  },
  {
    capital: "Ouagadougou",
    code: "bf",
    continent: "Africa",
    iso: 1,
    name: "Burkina Faso"
  },
  {
    capital: "Sofia",
    code: "bg",
    continent: "Europe",
    iso: 1,
    name: "Bulgaria"
  },
  {
    capital: "Manama",
    code: "bh",
    continent: "Asia",
    iso: 1,
    name: "Bahrain"
  },
  {
    capital: "Bujumbura",
    code: "bi",
    continent: "Africa",
    iso: 1,
    name: "Burundi"
  },
  {
    capital: "Porto-Novo",
    code: "bj",
    continent: "Africa",
    iso: 1,
    name: "Benin"
  },
  {
    capital: "Gustavia",
    code: "bl",
    continent: "North America",
    iso: 1,
    name: "Saint Barthélemy"
  },
  {
    capital: "Hamilton",
    code: "bm",
    continent: "North America",
    iso: 1,
    name: "Bermuda"
  },
  {
    capital: "Bandar Seri Begawan",
    code: "bn",
    continent: "Asia",
    iso: 1,
    name: "Brunei Darussalam"
  },
  {
    capital: "Sucre",
    code: "bo",
    continent: "South America",
    iso: 1,
    name: "Bolivia (Plurinational State of)"
  },
  {
    capital: "Kralendijk",
    code: "bq",
    continent: "South America",
    iso: 1,
    name: "Bonaire, Sint Eustatius and Saba"
  },
  {
    capital: "Brasília",
    code: "br",
    continent: "South America",
    iso: 1,
    name: "Brazil"
  },
  {
    capital: "Nassau",
    code: "bs",
    continent: "North America",
    iso: 1,
    name: "Bahamas"
  },
  {
    capital: "Thimphu",
    code: "bt",
    continent: "Asia",
    iso: 1,
    name: "Bhutan"
  },
  {
    code: "bv",
    iso: 1,
    name: "Bouvet Island"
  },
  {
    capital: "Gaborone",
    code: "bw",
    continent: "Africa",
    iso: 1,
    name: "Botswana"
  },
  {
    capital: "Minsk",
    code: "by",
    continent: "Europe",
    iso: 1,
    name: "Belarus"
  },
  {
    capital: "Belmopan",
    code: "bz",
    continent: "North America",
    iso: 1,
    name: "Belize"
  },
  {
    capital: "Ottawa",
    code: "ca",
    continent: "North America",
    iso: 1,
    name: "Canada"
  },
  {
    capital: "West Island",
    code: "cc",
    continent: "Asia",
    iso: 1,
    name: "Cocos (Keeling) Islands"
  },
  {
    capital: "Kinshasa",
    code: "cd",
    continent: "Africa",
    iso: 1,
    name: "Democratic Republic of the Congo"
  },
  {
    code: "cefta",
    iso: 0,
    name: "Central European Free Trade Agreement"
  },
  {
    capital: "Bangui",
    code: "cf",
    continent: "Africa",
    iso: 1,
    name: "Central African Republic"
  },
  {
    capital: "Brazzaville",
    code: "cg",
    continent: "Africa",
    iso: 1,
    name: "Republic of the Congo"
  },
  {
    capital: "Bern",
    code: "ch",
    continent: "Europe",
    iso: 1,
    name: "Switzerland"
  },
  {
    capital: "Yamoussoukro",
    code: "ci",
    continent: "Africa",
    iso: 1,
    name: "Côte d'Ivoire"
  },
  {
    capital: "Avarua",
    code: "ck",
    continent: "Oceania",
    iso: 1,
    name: "Cook Islands"
  },
  {
    capital: "Santiago",
    code: "cl",
    continent: "South America",
    iso: 1,
    name: "Chile"
  },
  {
    capital: "Yaoundé",
    code: "cm",
    continent: "Africa",
    iso: 1,
    name: "Cameroon"
  },
  {
    capital: "Beijing",
    code: "cn",
    continent: "Asia",
    iso: 1,
    name: "China"
  },
  {
    capital: "Bogotá",
    code: "co",
    continent: "South America",
    iso: 1,
    name: "Colombia"
  },
  {
    code: "cp",
    iso: 0,
    name: "Clipperton Island"
  },
  {
    capital: "San José",
    code: "cr",
    continent: "North America",
    iso: 1,
    name: "Costa Rica"
  },
  {
    capital: "Havana",
    code: "cu",
    continent: "North America",
    iso: 1,
    name: "Cuba"
  },
  {
    capital: "Praia",
    code: "cv",
    continent: "Africa",
    iso: 1,
    name: "Cabo Verde"
  },
  {
    capital: "Willemstad",
    code: "cw",
    continent: "South America",
    iso: 1,
    name: "Curaçao"
  },
  {
    capital: "Flying Fish Cove",
    code: "cx",
    continent: "Asia",
    iso: 1,
    name: "Christmas Island"
  },
  {
    capital: "Nicosia",
    code: "cy",
    continent: "Europe",
    iso: 1,
    name: "Cyprus"
  },
  {
    capital: "Prague",
    code: "cz",
    continent: "Europe",
    iso: 1,
    name: "Czech Republic"
  },
  {
    capital: "Berlin",
    code: "de",
    continent: "Europe",
    iso: 1,
    name: "Germany"
  },
  {
    code: "dg",
    iso: 0,
    name: "Diego Garcia"
  },
  {
    capital: "Djibouti",
    code: "dj",
    continent: "Africa",
    iso: 1,
    name: "Djibouti"
  },
  {
    capital: "Copenhagen",
    code: "dk",
    continent: "Europe",
    iso: 1,
    name: "Denmark"
  },
  {
    capital: "Roseau",
    code: "dm",
    continent: "North America",
    iso: 1,
    name: "Dominica"
  },
  {
    capital: "Santo Domingo",
    code: "do",
    continent: "North America",
    iso: 1,
    name: "Dominican Republic"
  },
  {
    capital: "Algiers",
    code: "dz",
    continent: "Africa",
    iso: 1,
    name: "Algeria"
  },
  {
    code: "ea",
    iso: 0,
    name: "Ceuta & Melilla"
  },
  {
    capital: "Quito",
    code: "ec",
    continent: "South America",
    iso: 1,
    name: "Ecuador"
  },
  {
    capital: "Tallinn",
    code: "ee",
    continent: "Europe",
    iso: 1,
    name: "Estonia"
  },
  {
    capital: "Cairo",
    code: "eg",
    continent: "Africa",
    iso: 1,
    name: "Egypt"
  },
  {
    capital: "Laayoune",
    code: "eh",
    continent: "Africa",
    iso: 1,
    name: "Western Sahara"
  },
  {
    capital: "Asmara",
    code: "er",
    continent: "Africa",
    iso: 1,
    name: "Eritrea"
  },
  {
    capital: "Madrid",
    code: "es",
    continent: "Europe",
    iso: 1,
    name: "Spain"
  },
  {
    code: "es-ct",
    iso: 0,
    name: "Catalonia"
  },
  {
    code: "es-ga",
    iso: 0,
    name: "Galicia"
  },
  {
    capital: "Addis Ababa",
    code: "et",
    continent: "Africa",
    iso: 1,
    name: "Ethiopia"
  },
  {
    code: "eu",
    iso: 0,
    name: "Europe"
  },
  {
    capital: "Helsinki",
    code: "fi",
    continent: "Europe",
    iso: 1,
    name: "Finland"
  },
  {
    capital: "Suva",
    code: "fj",
    continent: "Oceania",
    iso: 1,
    name: "Fiji"
  },
  {
    capital: "Stanley",
    code: "fk",
    continent: "South America",
    iso: 1,
    name: "Falkland Islands"
  },
  {
    capital: "Palikir",
    code: "fm",
    continent: "Oceania",
    iso: 1,
    name: "Federated States of Micronesia"
  },
  {
    capital: "Tórshavn",
    code: "fo",
    continent: "Europe",
    iso: 1,
    name: "Faroe Islands"
  },
  {
    capital: "Paris",
    code: "fr",
    continent: "Europe",
    iso: 1,
    name: "France"
  },
  {
    capital: "Libreville",
    code: "ga",
    continent: "Africa",
    iso: 1,
    name: "Gabon"
  },
  {
    capital: "London",
    code: "gb",
    continent: "Europe",
    iso: 1,
    name: "United Kingdom"
  },
  {
    capital: "London",
    code: "gb-eng",
    continent: "Europe",
    iso: 0,
    name: "England"
  },
  {
    capital: "Belfast",
    code: "gb-nir",
    continent: "Europe",
    iso: 0,
    name: "Northern Ireland"
  },
  {
    capital: "Edinburgh",
    code: "gb-sct",
    continent: "Europe",
    iso: 0,
    name: "Scotland"
  },
  {
    capital: "Cardiff",
    code: "gb-wls",
    continent: "Europe",
    iso: 0,
    name: "Wales"
  },
  {
    capital: "St. George's",
    code: "gd",
    continent: "North America",
    iso: 1,
    name: "Grenada"
  },
  {
    capital: "Tbilisi",
    code: "ge",
    continent: "Asia",
    iso: 1,
    name: "Georgia"
  },
  {
    capital: "Cayenne",
    code: "gf",
    continent: "South America",
    iso: 1,
    name: "French Guiana"
  },
  {
    capital: "Saint Peter Port",
    code: "gg",
    continent: "Europe",
    iso: 1,
    name: "Guernsey"
  },
  {
    capital: "Accra",
    code: "gh",
    continent: "Africa",
    iso: 1,
    name: "Ghana"
  },
  {
    capital: "Gibraltar",
    code: "gi",
    continent: "Europe",
    iso: 1,
    name: "Gibraltar"
  },
  {
    capital: "Nuuk",
    code: "gl",
    continent: "North America",
    iso: 1,
    name: "Greenland"
  },
  {
    capital: "Banjul",
    code: "gm",
    continent: "Africa",
    iso: 1,
    name: "Gambia"
  },
  {
    capital: "Conakry",
    code: "gn",
    continent: "Africa",
    iso: 1,
    name: "Guinea"
  },
  {
    capital: "Basse-Terre",
    code: "gp",
    continent: "North America",
    iso: 1,
    name: "Guadeloupe"
  },
  {
    capital: "Malabo",
    code: "gq",
    continent: "Africa",
    iso: 1,
    name: "Equatorial Guinea"
  },
  {
    capital: "Athens",
    code: "gr",
    continent: "Europe",
    iso: 1,
    name: "Greece"
  },
  {
    capital: "King Edward Point",
    code: "gs",
    continent: "Antarctica",
    iso: 1,
    name: "South Georgia and the South Sandwich Islands"
  },
  {
    capital: "Guatemala City",
    code: "gt",
    continent: "North America",
    iso: 1,
    name: "Guatemala"
  },
  {
    capital: "Hagåtña",
    code: "gu",
    continent: "Oceania",
    iso: 1,
    name: "Guam"
  },
  {
    capital: "Bissau",
    code: "gw",
    continent: "Africa",
    iso: 1,
    name: "Guinea-Bissau"
  },
  {
    capital: "Georgetown",
    code: "gy",
    continent: "South America",
    iso: 1,
    name: "Guyana"
  },
  {
    capital: "Hong Kong",
    code: "hk",
    continent: "Asia",
    iso: 1,
    name: "Hong Kong"
  },
  {
    code: "hm",
    iso: 1,
    name: "Heard Island and McDonald Islands"
  },
  {
    capital: "Tegucigalpa",
    code: "hn",
    continent: "North America",
    iso: 1,
    name: "Honduras"
  },
  {
    capital: "Zagreb",
    code: "hr",
    continent: "Europe",
    iso: 1,
    name: "Croatia"
  },
  {
    capital: "Port-au-Prince",
    code: "ht",
    continent: "North America",
    iso: 1,
    name: "Haiti"
  },
  {
    capital: "Budapest",
    code: "hu",
    continent: "Europe",
    iso: 1,
    name: "Hungary"
  },
  {
    code: "ic",
    iso: 0,
    name: "Canary Islands"
  },
  {
    capital: "Jakarta",
    code: "id",
    continent: "Asia",
    iso: 1,
    name: "Indonesia"
  },
  {
    capital: "Dublin",
    code: "ie",
    continent: "Europe",
    iso: 1,
    name: "Ireland"
  },
  {
    capital: "Jerusalem",
    code: "il",
    continent: "Asia",
    iso: 1,
    name: "Israel"
  },
  {
    capital: "Douglas",
    code: "im",
    continent: "Europe",
    iso: 1,
    name: "Isle of Man"
  },
  {
    capital: "New Delhi",
    code: "in",
    continent: "Asia",
    iso: 1,
    name: "India"
  },
  {
    capital: "Diego Garcia",
    code: "io",
    continent: "Asia",
    iso: 1,
    name: "British Indian Ocean Territory"
  },
  {
    capital: "Baghdad",
    code: "iq",
    continent: "Asia",
    iso: 1,
    name: "Iraq"
  },
  {
    capital: "Tehran",
    code: "ir",
    continent: "Asia",
    iso: 1,
    name: "Iran (Islamic Republic of)"
  },
  {
    capital: "Reykjavik",
    code: "is",
    continent: "Europe",
    iso: 1,
    name: "Iceland"
  },
  {
    capital: "Rome",
    code: "it",
    continent: "Europe",
    iso: 1,
    name: "Italy"
  },
  {
    capital: "Saint Helier",
    code: "je",
    continent: "Europe",
    iso: 1,
    name: "Jersey"
  },
  {
    capital: "Kingston",
    code: "jm",
    continent: "North America",
    iso: 1,
    name: "Jamaica"
  },
  {
    capital: "Amman",
    code: "jo",
    continent: "Asia",
    iso: 1,
    name: "Jordan"
  },
  {
    capital: "Tokyo",
    code: "jp",
    continent: "Asia",
    iso: 1,
    name: "Japan"
  },
  {
    capital: "Nairobi",
    code: "ke",
    continent: "Africa",
    iso: 1,
    name: "Kenya"
  },
  {
    capital: "Bishkek",
    code: "kg",
    continent: "Asia",
    iso: 1,
    name: "Kyrgyzstan"
  },
  {
    capital: "Phnom Penh",
    code: "kh",
    continent: "Asia",
    iso: 1,
    name: "Cambodia"
  },
  {
    capital: "South Tarawa",
    code: "ki",
    continent: "Oceania",
    iso: 1,
    name: "Kiribati"
  },
  {
    capital: "Moroni",
    code: "km",
    continent: "Africa",
    iso: 1,
    name: "Comoros"
  },
  {
    capital: "Basseterre",
    code: "kn",
    continent: "North America",
    iso: 1,
    name: "Saint Kitts and Nevis"
  },
  {
    capital: "Pyongyang",
    code: "kp",
    continent: "Asia",
    iso: 1,
    name: "North Korea"
  },
  {
    capital: "Seoul",
    code: "kr",
    continent: "Asia",
    iso: 1,
    name: "South Korea"
  },
  {
    capital: "Kuwait City",
    code: "kw",
    continent: "Asia",
    iso: 1,
    name: "Kuwait"
  },
  {
    capital: "George Town",
    code: "ky",
    continent: "North America",
    iso: 1,
    name: "Cayman Islands"
  },
  {
    capital: "Astana",
    code: "kz",
    continent: "Asia",
    iso: 1,
    name: "Kazakhstan"
  },
  {
    capital: "Vientiane",
    code: "la",
    continent: "Asia",
    iso: 1,
    name: "Laos"
  },
  {
    capital: "Beirut",
    code: "lb",
    continent: "Asia",
    iso: 1,
    name: "Lebanon"
  },
  {
    capital: "Castries",
    code: "lc",
    continent: "North America",
    iso: 1,
    name: "Saint Lucia"
  },
  {
    capital: "Vaduz",
    code: "li",
    continent: "Europe",
    iso: 1,
    name: "Liechtenstein"
  },
  {
    capital: "Sri Jayawardenepura Kotte, Colombo",
    code: "lk",
    continent: "Asia",
    iso: 1,
    name: "Sri Lanka"
  },
  {
    capital: "Monrovia",
    code: "lr",
    continent: "Africa",
    iso: 1,
    name: "Liberia"
  },
  {
    capital: "Maseru",
    code: "ls",
    continent: "Africa",
    iso: 1,
    name: "Lesotho"
  },
  {
    capital: "Vilnius",
    code: "lt",
    continent: "Europe",
    iso: 1,
    name: "Lithuania"
  },
  {
    capital: "Luxembourg City",
    code: "lu",
    continent: "Europe",
    iso: 1,
    name: "Luxembourg"
  },
  {
    capital: "Riga",
    code: "lv",
    continent: "Europe",
    iso: 1,
    name: "Latvia"
  },
  {
    capital: "Tripoli",
    code: "ly",
    continent: "Africa",
    iso: 1,
    name: "Libya"
  },
  {
    capital: "Rabat",
    code: "ma",
    continent: "Africa",
    iso: 1,
    name: "Morocco"
  },
  {
    capital: "Monaco",
    code: "mc",
    continent: "Europe",
    iso: 1,
    name: "Monaco"
  },
  {
    capital: "Chișinău",
    code: "md",
    continent: "Europe",
    iso: 1,
    name: "Moldova"
  },
  {
    capital: "Podgorica",
    code: "me",
    continent: "Europe",
    iso: 1,
    name: "Montenegro"
  },
  {
    capital: "Marigot",
    code: "mf",
    continent: "North America",
    iso: 1,
    name: "Saint Martin"
  },
  {
    capital: "Antananarivo",
    code: "mg",
    continent: "Africa",
    iso: 1,
    name: "Madagascar"
  },
  {
    capital: "Majuro",
    code: "mh",
    continent: "Oceania",
    iso: 1,
    name: "Marshall Islands"
  },
  {
    capital: "Skopje",
    code: "mk",
    continent: "Europe",
    iso: 1,
    name: "North Macedonia"
  },
  {
    capital: "Bamako",
    code: "ml",
    continent: "Africa",
    iso: 1,
    name: "Mali"
  },
  {
    capital: "Naypyidaw",
    code: "mm",
    continent: "Asia",
    iso: 1,
    name: "Myanmar"
  },
  {
    capital: "Ulaanbaatar",
    code: "mn",
    continent: "Asia",
    iso: 1,
    name: "Mongolia"
  },
  {
    capital: "Macau",
    code: "mo",
    continent: "Asia",
    iso: 1,
    name: "Macau"
  },
  {
    capital: "Saipan",
    code: "mp",
    continent: "Oceania",
    iso: 1,
    name: "Northern Mariana Islands"
  },
  {
    capital: "Fort-de-France",
    code: "mq",
    continent: "North America",
    iso: 1,
    name: "Martinique"
  },
  {
    capital: "Nouakchott",
    code: "mr",
    continent: "Africa",
    iso: 1,
    name: "Mauritania"
  },
  {
    capital: "Little Bay, Brades, Plymouth",
    code: "ms",
    continent: "North America",
    iso: 1,
    name: "Montserrat"
  },
  {
    capital: "Valletta",
    code: "mt",
    continent: "Europe",
    iso: 1,
    name: "Malta"
  },
  {
    capital: "Port Louis",
    code: "mu",
    continent: "Africa",
    iso: 1,
    name: "Mauritius"
  },
  {
    capital: "Malé",
    code: "mv",
    continent: "Asia",
    iso: 1,
    name: "Maldives"
  },
  {
    capital: "Lilongwe",
    code: "mw",
    continent: "Africa",
    iso: 1,
    name: "Malawi"
  },
  {
    capital: "Mexico City",
    code: "mx",
    continent: "North America",
    iso: 1,
    name: "Mexico"
  },
  {
    capital: "Kuala Lumpur",
    code: "my",
    continent: "Asia",
    iso: 1,
    name: "Malaysia"
  },
  {
    capital: "Maputo",
    code: "mz",
    continent: "Africa",
    iso: 1,
    name: "Mozambique"
  },
  {
    capital: "Windhoek",
    code: "na",
    continent: "Africa",
    iso: 1,
    name: "Namibia"
  },
  {
    capital: "Nouméa",
    code: "nc",
    continent: "Oceania",
    iso: 1,
    name: "New Caledonia"
  },
  {
    capital: "Niamey",
    code: "ne",
    continent: "Africa",
    iso: 1,
    name: "Niger"
  },
  {
    capital: "Kingston",
    code: "nf",
    continent: "Oceania",
    iso: 1,
    name: "Norfolk Island"
  },
  {
    capital: "Abuja",
    code: "ng",
    continent: "Africa",
    iso: 1,
    name: "Nigeria"
  },
  {
    capital: "Managua",
    code: "ni",
    continent: "North America",
    iso: 1,
    name: "Nicaragua"
  },
  {
    capital: "Amsterdam",
    code: "nl",
    continent: "Europe",
    iso: 1,
    name: "Netherlands"
  },
  {
    capital: "Oslo",
    code: "no",
    continent: "Europe",
    iso: 1,
    name: "Norway"
  },
  {
    capital: "Kathmandu",
    code: "np",
    continent: "Asia",
    iso: 1,
    name: "Nepal"
  },
  {
    capital: "Yaren District",
    code: "nr",
    continent: "Oceania",
    iso: 1,
    name: "Nauru"
  },
  {
    capital: "Alofi",
    code: "nu",
    continent: "Oceania",
    iso: 1,
    name: "Niue"
  },
  {
    capital: "Wellington",
    code: "nz",
    continent: "Oceania",
    iso: 1,
    name: "New Zealand"
  },
  {
    capital: "Muscat",
    code: "om",
    continent: "Asia",
    iso: 1,
    name: "Oman"
  },
  {
    capital: "Panama City",
    code: "pa",
    continent: "North America",
    iso: 1,
    name: "Panama"
  },
  {
    capital: "Lima",
    code: "pe",
    continent: "South America",
    iso: 1,
    name: "Peru"
  },
  {
    capital: "Papeete",
    code: "pf",
    continent: "Oceania",
    iso: 1,
    name: "French Polynesia"
  },
  {
    capital: "Port Moresby",
    code: "pg",
    continent: "Oceania",
    iso: 1,
    name: "Papua New Guinea"
  },
  {
    capital: "Manila",
    code: "ph",
    continent: "Asia",
    iso: 1,
    name: "Philippines"
  },
  {
    capital: "Islamabad",
    code: "pk",
    continent: "Asia",
    iso: 1,
    name: "Pakistan"
  },
  {
    capital: "Warsaw",
    code: "pl",
    continent: "Europe",
    iso: 1,
    name: "Poland"
  },
  {
    capital: "Saint-Pierre",
    code: "pm",
    continent: "North America",
    iso: 1,
    name: "Saint Pierre and Miquelon"
  },
  {
    capital: "Adamstown",
    code: "pn",
    continent: "Oceania",
    iso: 1,
    name: "Pitcairn"
  },
  {
    capital: "San Juan",
    code: "pr",
    continent: "North America",
    iso: 1,
    name: "Puerto Rico"
  },
  {
    capital: "Ramallah",
    code: "ps",
    continent: "Asia",
    iso: 1,
    name: "State of Palestine"
  },
  {
    capital: "Lisbon",
    code: "pt",
    continent: "Europe",
    iso: 1,
    name: "Portugal"
  },
  {
    capital: "Ngerulmud",
    code: "pw",
    continent: "Oceania",
    iso: 1,
    name: "Palau"
  },
  {
    capital: "Asunción",
    code: "py",
    continent: "South America",
    iso: 1,
    name: "Paraguay"
  },
  {
    capital: "Doha",
    code: "qa",
    continent: "Asia",
    iso: 1,
    name: "Qatar"
  },
  {
    capital: "Saint-Denis",
    code: "re",
    continent: "Africa",
    iso: 1,
    name: "Réunion"
  },
  {
    capital: "Bucharest",
    code: "ro",
    continent: "Europe",
    iso: 1,
    name: "Romania"
  },
  {
    capital: "Belgrade",
    code: "rs",
    continent: "Europe",
    iso: 1,
    name: "Serbia"
  },
  {
    capital: "Moscow",
    code: "ru",
    continent: "Europe",
    iso: 1,
    name: "Russia"
  },
  {
    capital: "Kigali",
    code: "rw",
    continent: "Africa",
    iso: 1,
    name: "Rwanda"
  },
  {
    capital: "Riyadh",
    code: "sa",
    continent: "Asia",
    iso: 1,
    name: "Saudi Arabia"
  },
  {
    capital: "Honiara",
    code: "sb",
    continent: "Oceania",
    iso: 1,
    name: "Solomon Islands"
  },
  {
    capital: "Victoria",
    code: "sc",
    continent: "Africa",
    iso: 1,
    name: "Seychelles"
  },
  {
    capital: "Khartoum",
    code: "sd",
    continent: "Africa",
    iso: 1,
    name: "Sudan"
  },
  {
    capital: "Stockholm",
    code: "se",
    continent: "Europe",
    iso: 1,
    name: "Sweden"
  },
  {
    capital: "Singapore",
    code: "sg",
    continent: "Asia",
    iso: 1,
    name: "Singapore"
  },
  {
    capital: "Jamestown",
    code: "sh",
    continent: "Africa",
    iso: 1,
    name: "Saint Helena, Ascension and Tristan da Cunha"
  },
  {
    capital: "Ljubljana",
    code: "si",
    continent: "Europe",
    iso: 1,
    name: "Slovenia"
  },
  {
    capital: "Longyearbyen",
    code: "sj",
    continent: "Europe",
    iso: 1,
    name: "Svalbard and Jan Mayen"
  },
  {
    capital: "Bratislava",
    code: "sk",
    continent: "Europe",
    iso: 1,
    name: "Slovakia"
  },
  {
    capital: "Freetown",
    code: "sl",
    continent: "Africa",
    iso: 1,
    name: "Sierra Leone"
  },
  {
    capital: "San Marino",
    code: "sm",
    continent: "Europe",
    iso: 1,
    name: "San Marino"
  },
  {
    capital: "Dakar",
    code: "sn",
    continent: "Africa",
    iso: 1,
    name: "Senegal"
  },
  {
    capital: "Mogadishu",
    code: "so",
    continent: "Africa",
    iso: 1,
    name: "Somalia"
  },
  {
    capital: "Paramaribo",
    code: "sr",
    continent: "South America",
    iso: 1,
    name: "Suriname"
  },
  {
    capital: "Juba",
    code: "ss",
    continent: "Africa",
    iso: 1,
    name: "South Sudan"
  },
  {
    capital: "São Tomé",
    code: "st",
    continent: "Africa",
    iso: 1,
    name: "Sao Tome and Principe"
  },
  {
    capital: "San Salvador",
    code: "sv",
    continent: "North America",
    iso: 1,
    name: "El Salvador"
  },
  {
    capital: "Philipsburg",
    code: "sx",
    continent: "North America",
    iso: 1,
    name: "Sint Maarten"
  },
  {
    capital: "Damascus",
    code: "sy",
    continent: "Asia",
    iso: 1,
    name: "Syria"
  },
  {
    capital: "Lobamba, Mbabane",
    code: "sz",
    continent: "Africa",
    iso: 1,
    name: "Eswatini"
  },
  {
    code: "ta",
    iso: 0,
    name: "Tristan da Cunha"
  },
  {
    capital: "Cockburn Town",
    code: "tc",
    continent: "North America",
    iso: 1,
    name: "Turks and Caicos Islands"
  },
  {
    capital: "N'Djamena",
    code: "td",
    continent: "Africa",
    iso: 1,
    name: "Chad"
  },
  {
    capital: "Saint-Pierre, Réunion",
    code: "tf",
    continent: "Africa",
    iso: 1,
    name: "French Southern Territories"
  },
  {
    capital: "Lomé",
    code: "tg",
    continent: "Africa",
    iso: 1,
    name: "Togo"
  },
  {
    capital: "Bangkok",
    code: "th",
    continent: "Asia",
    iso: 1,
    name: "Thailand"
  },
  {
    capital: "Dushanbe",
    code: "tj",
    continent: "Asia",
    iso: 1,
    name: "Tajikistan"
  },
  {
    capital: "Nukunonu, Atafu,Tokelau",
    code: "tk",
    continent: "Oceania",
    iso: 1,
    name: "Tokelau"
  },
  {
    capital: "Dili",
    code: "tl",
    continent: "Asia",
    iso: 1,
    name: "Timor-Leste"
  },
  {
    capital: "Ashgabat",
    code: "tm",
    continent: "Asia",
    iso: 1,
    name: "Turkmenistan"
  },
  {
    capital: "Tunis",
    code: "tn",
    continent: "Africa",
    iso: 1,
    name: "Tunisia"
  },
  {
    capital: "Nukuʻalofa",
    code: "to",
    continent: "Oceania",
    iso: 1,
    name: "Tonga"
  },
  {
    capital: "Ankara",
    code: "tr",
    continent: "Asia",
    iso: 1,
    name: "Turkey"
  },
  {
    capital: "Port of Spain",
    code: "tt",
    continent: "South America",
    iso: 1,
    name: "Trinidad and Tobago"
  },
  {
    capital: "Funafuti",
    code: "tv",
    continent: "Oceania",
    iso: 1,
    name: "Tuvalu"
  },
  {
    capital: "Taipei",
    code: "tw",
    continent: "Asia",
    iso: 1,
    name: "Taiwan"
  },
  {
    capital: "Dodoma",
    code: "tz",
    continent: "Africa",
    iso: 1,
    name: "Tanzania"
  },
  {
    capital: "Kiev",
    code: "ua",
    continent: "Europe",
    iso: 1,
    name: "Ukraine"
  },
  {
    capital: "Kampala",
    code: "ug",
    continent: "Africa",
    iso: 1,
    name: "Uganda"
  },
  {
    capital: "Washington, D.C.",
    code: "um",
    continent: "North America",
    iso: 1,
    name: "United States Minor Outlying Islands"
  },
  {
    code: "un",
    iso: 0,
    name: "United Nations"
  },
  {
    capital: "Washington, D.C.",
    code: "us",
    continent: "North America",
    iso: 1,
    name: "United States of America"
  },
  {
    capital: "Montevideo",
    code: "uy",
    continent: "South America",
    iso: 1,
    name: "Uruguay"
  },
  {
    capital: "Tashkent",
    code: "uz",
    continent: "Asia",
    iso: 1,
    name: "Uzbekistan"
  },
  {
    capital: "Vatican City",
    code: "va",
    continent: "Europe",
    iso: 1,
    name: "Holy See"
  },
  {
    capital: "Kingstown",
    code: "vc",
    continent: "North America",
    iso: 1,
    name: "Saint Vincent and the Grenadines"
  },
  {
    capital: "Caracas",
    code: "ve",
    continent: "South America",
    iso: 1,
    name: "Venezuela (Bolivarian Republic of)"
  },
  {
    capital: "Road Town",
    code: "vg",
    continent: "North America",
    iso: 1,
    name: "Virgin Islands (British)"
  },
  {
    capital: "Charlotte Amalie",
    code: "vi",
    continent: "North America",
    iso: 1,
    name: "Virgin Islands (U.S.)"
  },
  {
    capital: "Hanoi",
    code: "vn",
    continent: "Asia",
    iso: 1,
    name: "Vietnam"
  },
  {
    capital: "Port Vila",
    code: "vu",
    continent: "Oceania",
    iso: 1,
    name: "Vanuatu"
  },
  {
    capital: "Mata-Utu",
    code: "wf",
    continent: "Oceania",
    iso: 1,
    name: "Wallis and Futuna"
  },
  {
    capital: "Apia",
    code: "ws",
    continent: "Oceania",
    iso: 1,
    name: "Samoa"
  },
  {
    capital: "Pristina",
    code: "xk",
    continent: "Europe",
    iso: 0,
    name: "Kosovo"
  },
  {
    code: "xx",
    iso: 0,
    name: "Unknown"
  },
  {
    capital: "Sana'a",
    code: "ye",
    continent: "Asia",
    iso: 1,
    name: "Yemen"
  },
  {
    capital: "Mamoudzou",
    code: "yt",
    continent: "Africa",
    iso: 1,
    name: "Mayotte"
  },
  {
    capital: "Pretoria",
    code: "za",
    continent: "Africa",
    iso: 1,
    name: "South Africa"
  },
  {
    capital: "Lusaka",
    code: "zm",
    continent: "Africa",
    iso: 1,
    name: "Zambia"
  },
  {
    capital: "Harare",
    code: "zw",
    continent: "Africa",
    iso: 1,
    name: "Zimbabwe"
  }];
  
  for (var country of countries)
    addFlag(country, country.iso? isoFlagsRow: nonIsoFlagsRow);
};

})(window,document);