/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.font.prop;

import com.iizigo.ApplicationUI;
import com.iizigo.font.prop.FontDesignerProp;
import com.iizigo.font.prop.IEditorFont;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizix.prop.AssetReference;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.font.FontFile;
import com.iizix.prop.font.FontFormat;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EditorFontFile
extends FontFile
implements IEditorFont,
IPropDesigner {
    private FontDesignerProp a = new FontDesignerProp((PropCnr)this);
    private static final List<TooltipItem> a;

    static {
        a = List.of(TooltipItem.HEADER_IMAGE_DESCR_TYPE, TooltipItem.SEPARATOR, TooltipItem.newNormal("Asset file", Atom.FILENAME), TooltipItem.newIntIndex("Font format", "format", FontFormat.FORMATS, "(undefined)"), TooltipItem.newNormal("File query or SVG font name", "query"));
    }

    public EditorFontFile() {
    }

    public EditorFontFile(Atom atom) {
        super(atom);
    }

    @Override
    public Image getCNImage() {
        return ApplicationUI.getInstance().imageFontFile;
    }

    @Override
    public String getCNType() {
        return "Font file";
    }

    @Override
    public String getCNText() {
        String string;
        AssetReference assetReference = this.getAssetReference();
        if (assetReference != null && (string = assetReference.getReference()) != null && !string.isEmpty()) {
            return string;
        }
        return "(Missing font file name)";
    }

    @Override
    public FontDesignerProp getDesigner() {
        return this.a;
    }

    public EditorFontFile clone() throws CloneNotSupportedException {
        EditorFontFile editorFontFile = (EditorFontFile)super.clone();
        editorFontFile.a = new FontDesignerProp((PropCnr)editorFontFile);
        return editorFontFile;
    }

    @Override
    public Composite createTooltip(Composite composite) {
        return DesignerProp.createCNToolTipItemList(composite, (PropCnr)this, (List<TooltipItem>)((Object)a), false);
    }

    public Class<?>[] getPossibleChildren() {
        return null;
    }

    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        AssetReference assetReference = (AssetReference)this.getProp(Atom.FILENAME, AssetReference.class);
        if (assetReference == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, Atom.FILENAME, PropVerificationError.Severity.WARNING, "File name", "Missing font file name", new String[0]));
        } else {
            String string = assetReference.getReference();
            if (string == null || string.isEmpty()) {
                propVerification.add(new PropVerificationError("name", PropVerificationError.Severity.WARNING, "File name", (GProp)assetReference, "Missing font file name", new String[0]));
            } else {
                IntProp intProp = (IntProp)this.getProp("format", IntProp.class);
                if (intProp == null) {
                    propVerification.add(new PropVerificationError((PropCnr)this, "format", PropVerificationError.Severity.WARNING, "Font format", "Font format is undefined", new String[0]));
                } else if (intProp.getInt() <= 0) {
                    propVerification.add(new PropVerificationError("format", PropVerificationError.Severity.WARNING, "Font format", (GProp)intProp, "Font format is undefined", new String[0]));
                }
            }
        }
        return true;
    }
}

