/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.push;

import com.iizix.Utilities;
import java.awt.Color;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public enum PushNotificationParameters {
    TITLE("n", true, String.class),
    BODY("b", true, String.class),
    SOUND("d", false, Integer.class),
    VIBRATION("v", false, Integer.class, String.class),
    ICON("i", false, String.class),
    ICON_COLOR("c", false, Color.class, String.class),
    URL("u", false, URL.class, URI.class, String.class),
    URL_TITLE("t", false, String.class),
    IMAGE("p", false, File.class, String.class),
    PRIORITY("y", false, Integer.class, String.class),
    SENDER("s", true, String.class),
    ORIGIN("o", true, InetAddress.class, String.class),
    KEY_ALIAS("k", true, String.class);

    public final String name;
    public final boolean isRequired;
    private final Class<?>[] a;
    private static final HashMap<String, PushNotificationParameters> a;
    private static final HashSet<PushNotificationParameters> a;

    static {
        a = new HashMap();
        a = new HashSet();
        PushNotificationParameters[] pushNotificationParametersArray = PushNotificationParameters.values();
        int n2 = pushNotificationParametersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PushNotificationParameters pushNotificationParameters = pushNotificationParametersArray[n3];
            a.put(pushNotificationParameters.name, pushNotificationParameters);
            if (pushNotificationParameters.isRequired) {
                a.add(pushNotificationParameters);
            }
            ++n3;
        }
    }

    private PushNotificationParameters(String string2, boolean bl, Class<?> ... classArray) {
        this.name = string2;
        this.isRequired = bl;
        this.a = classArray;
    }

    public String toString() {
        String string = this.name() + "[\"" + this.name + "\",";
        return this.isRequired ? string + "required]" : string + "optional]";
    }

    public static Map<PushNotificationParameters, String> parseURL(String string) {
        HashMap<PushNotificationParameters, String> hashMap = new HashMap<PushNotificationParameters, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            int n2 = string3.indexOf(61);
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid parameter format: \"" + string3 + "\"");
            }
            String string4 = string3.substring(0, n2).toLowerCase(Locale.ENGLISH);
            PushNotificationParameters pushNotificationParameters = (PushNotificationParameters)((Object)a.get(string4));
            if (pushNotificationParameters == null) {
                throw new IllegalArgumentException("Invalid parameter name (\"" + string4 + "\"): \"" + string3 + "\"");
            }
            string4 = string3.substring(n2 + 1);
            String string5 = Utilities.decodeURIComponent(string4).trim();
            if (pushNotificationParameters.isRequired) {
                if (string5.isEmpty()) {
                    throw new IllegalArgumentException("Parameter " + String.valueOf((Object)pushNotificationParameters) + " value is empty: \"" + string4 + "\", decoded = \"" + string5 + "\"");
                }
                if (string5.isBlank()) {
                    throw new IllegalArgumentException("Parameter " + String.valueOf((Object)pushNotificationParameters) + " value is blank: \"" + string4 + "\", decoded = \"" + string5 + "\"");
                }
            }
            if ((string2 = hashMap.put(pushNotificationParameters, string5)) == null) continue;
            throw new IllegalArgumentException("Parameter " + String.valueOf((Object)pushNotificationParameters) + " is specified twice: \"" + string3 + "\", previous value = \"" + string2 + "\"");
        }
        return PushNotificationParameters.validateParams(hashMap);
    }

    public static Map<PushNotificationParameters, String> validateParams(Map<PushNotificationParameters, String> map) {
        for (PushNotificationParameters pushNotificationParameters : a) {
            if (map.get((Object)pushNotificationParameters) != null) continue;
            throw new IllegalArgumentException("Required parameter name " + String.valueOf((Object)pushNotificationParameters) + " is not specified");
        }
        return map;
    }
}

