/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.geo.ILongitudeLatitudeAltitude;
import java.util.Date;
import java.util.Objects;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;
import org.json.JSONWriter;

public class GeoLocation
implements ILongitudeLatitudeAltitude {
    public final boolean isAvailable;
    public final int errorCode;
    public final String errorMessage;
    private final long a;
    public final long timestampDevice;
    public final double latitude;
    public final double longitude;
    public final double altitude;
    public final double accuracy;
    public final double altitudeAccuracy;
    public final double heading;
    public final double speed;

    public GeoLocation(double d2, double d3) {
        this(true, 0, null, System.currentTimeMillis(), d2, d3, Double.NaN, 0.0, Double.NaN, Double.NaN, Double.NaN);
    }

    public GeoLocation(long l2, double d2, double d3, double d4, double d5, double d6) {
        this(true, 0, null, l2, d2, d3, d4, d5, Double.NaN, Double.NaN, d6);
    }

    public GeoLocation(boolean bl, int n2, String string, long l2, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.a = System.currentTimeMillis();
        this.isAvailable = bl;
        this.errorCode = n2;
        this.errorMessage = string;
        this.timestampDevice = l2;
        this.latitude = d2;
        this.longitude = d3;
        this.altitude = d4;
        this.accuracy = d5;
        this.altitudeAccuracy = d6;
        this.heading = d7;
        this.speed = d8;
    }

    public long getTimestamp() {
        return this.a;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public double getAltitude() {
        return this.altitude;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GeoLocation)) return false;
        GeoLocation geoLocation = (GeoLocation)object;
        if (this.a != geoLocation.a) return false;
        if (this.isAvailable != geoLocation.isAvailable) return false;
        if (this.errorCode != geoLocation.errorCode) return false;
        if (!Objects.equals(this.errorMessage, geoLocation.errorMessage)) return false;
        if (this.timestampDevice != geoLocation.timestampDevice) return false;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(geoLocation.latitude)) return false;
        if (Double.doubleToLongBits(this.longitude) != Double.doubleToLongBits(geoLocation.longitude)) return false;
        if (Double.doubleToLongBits(this.accuracy) != Double.doubleToLongBits(geoLocation.accuracy)) return false;
        if (Double.doubleToLongBits(this.altitudeAccuracy) != Double.doubleToLongBits(geoLocation.altitudeAccuracy)) return false;
        if (Double.doubleToLongBits(this.heading) != Double.doubleToLongBits(geoLocation.heading)) return false;
        if (Double.doubleToLongBits(this.speed) != Double.doubleToLongBits(geoLocation.speed)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.accuracy, this.altitude, this.altitudeAccuracy, this.errorCode, this.errorMessage, this.heading, this.isAvailable, this.latitude, this.longitude, this.speed, this.a, this.timestampDevice);
    }

    public String paramString(String string) {
        long l2;
        String string2 = "isAvailable=" + this.isAvailable + string + "timestamp=" + String.valueOf(new Date(this.a));
        int n2 = this.errorCode;
        switch (n2) {
            case -1: {
                break;
            }
            case 0: {
                string2 = string2 + string + "errorCode=0 (OK)";
                break;
            }
            case 1: {
                string2 = string2 + string + "errorCode=1 (PERMISSION_DENIED)";
                break;
            }
            case 2: {
                string2 = string2 + string + "errorCode=2 (UNAVAILABLE)";
                break;
            }
            case 3: {
                string2 = string2 + string + "errorCode=3 (TIMEOUT)";
                break;
            }
            default: {
                string2 = string2 + string + "errorCode=" + n2 + " (UNKNOWN)";
            }
        }
        String string3 = this.errorMessage;
        if (string3 != null) {
            string2 = string2 + string + "errorMessage=" + string3;
        }
        string2 = (l2 = this.timestampDevice) < 0L ? string2 + string + "timestampDevice=-1 (NOT_AVAILABLE)" : string2 + string + "timestampDevice=" + l2 + " (" + String.valueOf(new Date(l2)) + ")";
        double d2 = this.latitude;
        string2 = string2 + string + "latitude=" + String.valueOf(Double.isNaN(d2) ? "n/a" : Double.valueOf(d2));
        d2 = this.longitude;
        string2 = string2 + string + "longitude=" + String.valueOf(Double.isNaN(d2) ? "n/a" : Double.valueOf(d2));
        d2 = this.accuracy;
        string2 = string2 + string + "accuracy=" + String.valueOf(Double.isNaN(d2) ? "n/a" : Double.valueOf(d2));
        d2 = this.altitudeAccuracy;
        string2 = string2 + string + "altitudeAccuracy=" + String.valueOf(Double.isNaN(d2) ? "n/a" : Double.valueOf(d2));
        d2 = this.heading;
        string2 = string2 + string + "heading=" + String.valueOf(Double.isNaN(d2) ? "n/a" : Double.valueOf(d2));
        d2 = this.speed;
        string2 = string2 + string + "speed=" + String.valueOf(Double.isNaN(d2) ? "n/a" : Double.valueOf(d2));
        return string2;
    }

    public String toString() {
        return GeoLocation.class.getName() + "[" + this.paramString(",") + "]";
    }

    public String toJSONString() {
        JSONWriter jSONWriter = new JSONStringer().object().key("timestamp").value(this.a).key("isAvailable").value(this.isAvailable).key("errorCode").value((long)this.errorCode);
        if (this.errorMessage != null) {
            jSONWriter = jSONWriter.value((Object)"errorMessage").value((Object)this.errorMessage);
        }
        jSONWriter.key("timestampDevice").value(this.timestampDevice);
        if (!Double.isNaN(this.latitude)) {
            jSONWriter = jSONWriter.key("latitude").value(this.latitude);
        }
        if (!Double.isNaN(this.longitude)) {
            jSONWriter = jSONWriter.key("longitude").value(this.longitude);
        }
        if (!Double.isNaN(this.altitude)) {
            jSONWriter = jSONWriter.key("altitude").value(this.altitude);
        }
        if (!Double.isNaN(this.accuracy)) {
            jSONWriter = jSONWriter.key("accuracy").value(this.accuracy);
        }
        if (!Double.isNaN(this.altitudeAccuracy)) {
            jSONWriter = jSONWriter.key("altitudeAccuracy").value(this.altitudeAccuracy);
        }
        if (!Double.isNaN(this.heading)) {
            jSONWriter = jSONWriter.key("heading").value(this.heading);
        }
        if (!Double.isNaN(this.speed)) {
            jSONWriter = jSONWriter.key("speed").value(this.speed);
        }
        return jSONWriter.endObject().toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("timestamp", this.a);
        jSONObject.put("isAvailable", this.isAvailable);
        jSONObject.put("errorCode", this.errorCode);
        if (this.errorMessage != null) {
            jSONObject.put("errorMessage", (Object)this.errorMessage);
        }
        jSONObject.put("timestampDevice", this.timestampDevice);
        if (!Double.isNaN(this.latitude)) {
            jSONObject.put("latitude", this.latitude);
        }
        if (!Double.isNaN(this.longitude)) {
            jSONObject.put("longitude", this.longitude);
        }
        if (!Double.isNaN(this.altitude)) {
            jSONObject.put("altitude", this.altitude);
        }
        if (!Double.isNaN(this.accuracy)) {
            jSONObject.put("accuracy", this.accuracy);
        }
        if (!Double.isNaN(this.altitudeAccuracy)) {
            jSONObject.put("altitudeAccuracy", this.altitudeAccuracy);
        }
        if (!Double.isNaN(this.heading)) {
            jSONObject.put("heading", this.heading);
        }
        if (!Double.isNaN(this.speed)) {
            jSONObject.put("speed", this.speed);
        }
        return jSONObject;
    }

    public static GeoLocation of(String string) {
        return new GeoLocation(new JSONObject(new JSONTokener(string)));
    }

    public static GeoLocation of(JSONObject jSONObject) {
        return new GeoLocation(jSONObject);
    }

    private GeoLocation(JSONObject jSONObject) {
        this.a = jSONObject.getLong("timestamp");
        this.isAvailable = jSONObject.getBoolean("isAvailable");
        this.errorCode = jSONObject.getInt("errorCode");
        this.errorMessage = jSONObject.optString("errorMessage");
        this.timestampDevice = jSONObject.getLong("timestamp");
        this.latitude = jSONObject.optDouble("latitude");
        this.longitude = jSONObject.optDouble("longitude");
        this.altitude = jSONObject.optDouble("altitude");
        this.accuracy = jSONObject.optDouble("accuracy");
        this.altitudeAccuracy = jSONObject.optDouble("altitudeAccuracy");
        this.heading = jSONObject.optDouble("heading");
        this.speed = jSONObject.optDouble("speed");
    }
}

