/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.services;

import com.tabnine.eclipse.shared.api.DependencyContainer;
import com.tabnine.eclipse.shared.api.binary.BinaryRequestFacade;
import com.tabnine.eclipse.shared.api.binary.requests.WorkspaceRequest;
import com.tabnine.eclipse.shared.f.a;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class WorkspaceService {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private BinaryRequestFacade binaryRequestFacade = DependencyContainer.instanceOfBinaryRequestFacade();
    private static WorkspaceService instance;

    public static WorkspaceService getInstance() {
        if (instance == null) {
            instance = new WorkspaceService();
        }
        return instance;
    }

    public void start() {
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                String[] stringArray = a.a().toArray(new String[0]);
                this.binaryRequestFacade.executeRequest(new WorkspaceRequest(stringArray));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
                return;
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    public static Optional<String> getCurrentOpenedFilePath() {
        return Optional.ofNullable(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).map(IWorkbenchWindow::getActivePage).map(IWorkbenchPage::getActiveEditor).filter(iEditorPart -> iEditorPart.getEditorInput() instanceof IFileEditorInput).map(iEditorPart -> (IFileEditorInput)iEditorPart.getEditorInput()).map(IFileEditorInput::getFile).map(IResource::getLocation).flatMap(iPath -> Optional.ofNullable(iPath).map(IPath::toOSString));
    }
}

