/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary.fetch;

import com.tabnine.eclipse.shared.api.binary.fetch.BinaryFetchUtils;
import com.tabnine.eclipse.shared.api.binary.fetch.BinaryValidator;
import com.tabnine.eclipse.shared.api.binary.fetch.BinaryVersion;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LocalBinaryVersions {
    private BinaryValidator binaryValidator;

    public LocalBinaryVersions(BinaryValidator binaryValidator) {
        this.binaryValidator = binaryValidator;
    }

    public List<BinaryVersion> listExisting() {
        File[] fileArray = Optional.ofNullable(BinaryFetchUtils.getBaseDirectory().toFile().listFiles()).orElse(new File[0]);
        return Stream.of(fileArray).map(File::getName).filter(this::isValidVersion).map(Semver::new).filter(Objects::nonNull).sorted(Comparator.reverseOrder()).map(Semver::toString).map(BinaryVersion::new).filter(binaryVersion -> !binaryVersion.getVersion().equals("4.0.47") && this.binaryValidator.isWorking(binaryVersion.getVersionFullPath())).collect(Collectors.toList());
    }

    public Optional<BinaryVersion> activeVersion() {
        List<String> list = this.readActiveFile();
        if (list.size() == 0) {
            return Optional.empty();
        }
        if (((String)((Object)(list = list.get(0)))).equals("4.0.47")) {
            return Optional.empty();
        }
        if (!this.binaryValidator.isWorking(((BinaryVersion)((Object)(list = new BinaryVersion((String)((Object)list))))).getVersionFullPath())) {
            return Optional.empty();
        }
        return Optional.of(list);
    }

    private List<String> readActiveFile() {
        Path path = BinaryFetchUtils.getActiveVersionPath();
        List<String> list = new ArrayList<String>();
        if (path.toFile().exists()) {
            try {
                list = Files.readAllLines(path);
            }
            catch (IOException iOException) {}
        }
        return list;
    }

    private boolean isValidVersion(String string) {
        try {
            new Semver(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

