/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewInterfaceWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeWizard;
import org.eclipse.pde.internal.ui.util.TextUtil;

public class NewClassCreationWizard
extends JavaAttributeWizard {
    private final boolean fIsInterface;
    private IPackageFragment packageName = null;
    private String className = null;
    private IPackageFragmentRoot packageRoot = null;

    public NewClassCreationWizard(IProject project, boolean isInterface, String value) {
        super(project, null, null, null);
        try {
            this.initializeValues(project, value);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        this.fIsInterface = isInterface;
    }

    @Override
    public void addPages() {
        this.fMainPage = this.fIsInterface ? new NewInterfaceWizardPage() : new NewClassWizardPage();
        this.addPage((IWizardPage)this.fMainPage);
        if (this.fIsInterface) {
            ((NewInterfaceWizardPage)this.fMainPage).init((IStructuredSelection)StructuredSelection.EMPTY);
            if (this.className != null) {
                this.fMainPage.setTypeName(this.className, true);
            }
            if (this.packageRoot != null) {
                this.fMainPage.setPackageFragmentRoot(this.packageRoot, true);
            }
            if (this.packageName != null) {
                this.fMainPage.setPackageFragment(this.packageName, true);
            }
        } else {
            ((NewClassWizardPage)this.fMainPage).init((IStructuredSelection)StructuredSelection.EMPTY);
            if (this.className != null) {
                this.fMainPage.setTypeName(this.className, true);
            }
            if (this.packageRoot != null) {
                this.fMainPage.setPackageFragmentRoot(this.packageRoot, true);
            }
            if (this.packageName != null) {
                this.fMainPage.setPackageFragment(this.packageName, true);
            }
        }
    }

    private void initializeValues(IProject project, String value) throws JavaModelException {
        IPackageFragmentRoot[] roots;
        value = TextUtil.trimNonAlphaChars(value);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragmentRoot srcEntryDft = null;
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                srcEntryDft = root;
                break;
            }
            ++n2;
        }
        this.packageRoot = srcEntryDft != null ? srcEntryDft : javaProject.getPackageFragmentRoot(javaProject.getResource());
        String packageNameString = null;
        int index = value.lastIndexOf(".");
        if (index == -1) {
            this.className = value;
        } else {
            this.className = value.substring(index + 1);
            packageNameString = value.substring(0, index);
        }
        if (packageNameString != null && this.packageRoot != null) {
            IFolder packageFolder = project.getFolder(packageNameString);
            this.packageName = this.packageRoot.getPackageFragment(packageFolder.getProjectRelativePath().toOSString());
        }
    }
}

