/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.correction.java.JavaResolutionFactory;

public class FindClassResolutionsOperation
implements IRunnableWithProgress {
    private String fClassName = null;
    private IProject fProject = null;
    private AbstractClassResolutionCollector fCollector = null;
    private CompilationUnit fCompilationUnit;
    private static final Comparator<BaseDescription> BY_DESCENDING_VERSION = Comparator.comparing(BaseDescription::getVersion).reversed();

    public FindClassResolutionsOperation(IProject project, String className, AbstractClassResolutionCollector collector) {
        this.fProject = project;
        this.fClassName = className;
        this.fCollector = collector;
    }

    public FindClassResolutionsOperation(IProject project, CompilationUnit cu, String className, AbstractClassResolutionCollector collector) {
        this.fProject = project;
        this.fCompilationUnit = cu;
        this.fClassName = className;
        this.fCollector = collector;
    }

    public void run(IProgressMonitor monitor) {
        HashSet<IPackageFragment> packagesToExport;
        Map<String, List<ExportPackageDescription>> validPackages;
        int idx = this.fClassName.lastIndexOf(46);
        String packageName = idx != -1 ? this.fClassName.substring(0, idx) : null;
        String typeName = this.fClassName.substring(idx + 1);
        if (typeName.length() == 1 && typeName.charAt(0) == '*') {
            typeName = null;
        }
        if ((validPackages = this.getValidPackages(typeName, this.fClassName, packageName, packagesToExport = new HashSet<IPackageFragment>(), monitor)) != null) {
            if (validPackages.isEmpty()) {
                for (IPackageFragment fragment : packagesToExport) {
                    this.fCollector.addExportPackageResolutionModification(fragment);
                }
                return;
            }
            Set<ExportPackageDescription> visiblePackages = !validPackages.isEmpty() ? this.getVisiblePackages() : null;
            boolean allowMultipleFixes = packageName == null;
            Iterator<Map.Entry<String, List<ExportPackageDescription>>> validPackagesIter = validPackages.entrySet().iterator();
            while (validPackagesIter.hasNext() && (allowMultipleFixes || !this.fCollector.isDone())) {
                Map.Entry<String, List<ExportPackageDescription>> entry = validPackagesIter.next();
                String qualifiedType = entry.getKey();
                List<ExportPackageDescription> currentPackages2 = entry.getValue();
                currentPackages2.stream().sorted(BY_DESCENDING_VERSION).filter(p -> !visiblePackages.contains(p)).forEach(p -> this.fCollector.addResolutionModification(this.fProject, (ExportPackageDescription)p, this.fCompilationUnit, qualifiedType));
            }
            Set<String> bundleNames = this.getCurrentBundleNames();
            validPackages.forEach((key, currentPackages) -> currentPackages.stream().sorted(BY_DESCENDING_VERSION).forEach(currentPackage -> {
                BundleDescription desc = currentPackage.getExporter();
                if (desc != null && !bundleNames.contains(desc.getName())) {
                    this.fCollector.addRequireBundleModification(this.fProject, (ExportPackageDescription)currentPackage, 3, this.fCompilationUnit, (String)key);
                    bundleNames.add(desc.getName());
                }
            }));
        }
    }

    private Map<String, List<ExportPackageDescription>> getValidPackages(String typeName, String qualifiedTypeToImport, String packageName, Set<IPackageFragment> packagesToExport, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        Map<String, List<Object>> validPackages = null;
        ImportPackageSpecification[] importPkgs = null;
        IPluginModelBase model = PluginRegistry.findModel((IProject)this.fProject);
        if (model != null && model.getBundleDescription() != null) {
            importPkgs = model.getBundleDescription().getImportPackages();
        }
        subMonitor.split(1);
        if (importPkgs != null) {
            if (packageName != null) {
                if (!this.isImportedPackage(packageName, importPkgs)) {
                    List<ExportPackageDescription> packages = FindClassResolutionsOperation.getValidPackages(packageName);
                    validPackages = !packages.isEmpty() ? Map.of(qualifiedTypeToImport, packages) : Map.of();
                }
                subMonitor.split(1);
            } else {
                validPackages = this.findValidPackagesContainingSimpleType(typeName, importPkgs, packagesToExport, (IProgressMonitor)subMonitor.split(1));
            }
        }
        return validPackages;
    }

    private Map<String, List<ExportPackageDescription>> findValidPackagesContainingSimpleType(String aTypeName, ImportPackageSpecification[] importPkgs, Set<IPackageFragment> packagesToExport, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        Set javaProjects = Arrays.stream(PluginRegistry.getWorkspaceModels()).map(IModel::getUnderlyingResource).map(IResource::getProject).map(JavaCore::create).filter(IJavaElement::exists).collect(Collectors.toCollection(LinkedHashSet::new));
        final IJavaProject currentJavaProject = JavaCore.create((IProject)this.fProject);
        javaProjects.remove(currentJavaProject);
        try {
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProjects.toArray(new IJavaElement[javaProjects.size()]));
            final HashMap packages = new HashMap();
            final HashMap qualifiedTypeNames = new HashMap();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch aMatch) throws CoreException {
                    IPackageFragment packageFragment;
                    IType type;
                    Object element = aMatch.getElement();
                    if (element instanceof IType && Flags.isPublic((int)(type = (IType)element).getFlags()) && !currentJavaProject.equals(type.getJavaProject()) && (packageFragment = type.getPackageFragment()).exists()) {
                        packages.put(packageFragment.getElementName(), packageFragment);
                        qualifiedTypeNames.put(packageFragment.getElementName(), type.getFullyQualifiedName());
                    }
                }
            };
            SearchPattern typePattern = SearchPattern.createPattern((String)aTypeName, (int)0, (int)0, (int)8);
            if (typePattern == null) {
                return Collections.emptyMap();
            }
            new SearchEngine().search(typePattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, requestor, (IProgressMonitor)subMonitor.split(1));
            if (!packages.isEmpty()) {
                ExportPackageDescription[] systemPackages;
                State state = PDECore.getDefault().getModelManager().getState().getState();
                ExportPackageDescription[] exportPackageDescriptionArray = systemPackages = state.getSystemPackages();
                int n = systemPackages.length;
                int n2 = 0;
                while (n2 < n) {
                    ExportPackageDescription systemPackage = exportPackageDescriptionArray[n2];
                    packages.remove(systemPackage.getName());
                    ++n2;
                }
                exportPackageDescriptionArray = importPkgs;
                n = importPkgs.length;
                n2 = 0;
                while (n2 < n) {
                    ExportPackageDescription importPackage = exportPackageDescriptionArray[n2];
                    packages.remove(importPackage.getName());
                    ++n2;
                }
                Map<String, List<ExportPackageDescription>> exportDescriptions = Arrays.stream(state.getExportedPackages()).filter(p -> packages.containsKey(p.getName())).collect(Collectors.groupingBy(p -> (String)qualifiedTypeNames.get(p.getName())));
                if (exportDescriptions.isEmpty()) {
                    packagesToExport.addAll(packages.values());
                }
                return exportDescriptions;
            }
            return Collections.emptyMap();
        }
        catch (CoreException ex) {
            return Collections.emptyMap();
        }
    }

    private boolean isImportedPackage(String packageName, ImportPackageSpecification[] importPkgs) {
        ImportPackageSpecification[] importPackageSpecificationArray = importPkgs;
        int n = importPkgs.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification importPackage = importPackageSpecificationArray[n2];
            if (importPackage.getName().equals(packageName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static List<ExportPackageDescription> getValidPackages(String packageName) {
        State state = PDECore.getDefault().getModelManager().getState().getState();
        List<ExportPackageDescription> validPackages = Arrays.stream(state.getExportedPackages()).filter(p -> packageName.equals(p.getName())).toList();
        if (!validPackages.isEmpty()) {
            ExportPackageDescription[] systemPackages = state.getSystemPackages();
            if (Arrays.stream(systemPackages).map(BaseDescription::getName).anyMatch(packageName::equals)) {
                return List.of();
            }
        }
        return validPackages;
    }

    private Set<ExportPackageDescription> getVisiblePackages() {
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.fProject);
        if (base != null) {
            BundleDescription desc = base.getBundleDescription();
            StateHelper helper = BundleHelper.getPlatformAdmin().getStateHelper();
            return Set.of(helper.getVisiblePackages(desc));
        }
        return Collections.emptySet();
    }

    private Set<String> getCurrentBundleNames() {
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.fProject);
        if (base != null) {
            BundleSpecification[] reqBundles;
            HashSet<String> bundleNames = new HashSet<String>();
            BundleSpecification[] bundleSpecificationArray = reqBundles = base.getBundleDescription().getRequiredBundles();
            int n = reqBundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleSpecification reqBundle = bundleSpecificationArray[n2];
                bundleNames.add(reqBundle.getName());
                ++n2;
            }
            return bundleNames;
        }
        return Collections.emptySet();
    }

    public static abstract class AbstractClassResolutionCollector {
        public void addResolutionModification(IProject project, ExportPackageDescription desc) {
            this.addResolutionModification(project, desc, null, "");
        }

        public abstract void addResolutionModification(IProject var1, ExportPackageDescription var2, CompilationUnit var3, String var4);

        public IJavaCompletionProposal addExportPackageResolutionModification(IPackageFragment aPackage) {
            IResource packageResource;
            if (aPackage.exists() && (packageResource = aPackage.getResource()) != null) {
                IProject project = packageResource.getProject();
                JavaResolutionFactory.AbstractManifestChange<IPackageFragment> change = JavaResolutionFactory.createExportPackageChange(project, aPackage);
                return JavaResolutionFactory.createJavaCompletionProposal(change, 100);
            }
            return null;
        }

        public Object addRequireBundleModification(IProject project, ExportPackageDescription desc, int relevance) {
            return this.addRequireBundleModification(project, desc, relevance, null, "");
        }

        public IJavaCompletionProposal addRequireBundleModification(IProject project, ExportPackageDescription desc, int relevance, CompilationUnit cu, String qualifiedTypeToImport) {
            BundleDescription exporter = desc.getExporter();
            if (exporter == null) {
                return null;
            }
            JavaResolutionFactory.AbstractManifestChange<BundleDescription> change = JavaResolutionFactory.createRequireBundleChange(project, exporter, cu, qualifiedTypeToImport);
            return JavaResolutionFactory.createJavaCompletionProposal(change, relevance);
        }

        public Object addSearchRepositoriesModification(String packageName) {
            return JavaResolutionFactory.createSearchRepositoriesProposal(packageName);
        }

        public boolean isDone() {
            return false;
        }
    }
}

