/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;

public class RefactoringHandleTransplanter {
    private final IType fOldType;
    private final IType fNewType;
    private final Map<IJavaElement, String> fRefactoredSimilarElements;

    public RefactoringHandleTransplanter(IType oldType, IType newType, Map<IJavaElement, String> refactoredSimilarElements) {
        this.fOldType = oldType;
        this.fNewType = newType;
        this.fRefactoredSimilarElements = refactoredSimilarElements == null ? Collections.emptyMap() : refactoredSimilarElements;
    }

    public IMember transplantHandle(IMember handle) {
        LinkedList<IMember> oldElements = new LinkedList<IMember>();
        this.addElements(handle, oldElements);
        IMember[] newElements = this.convertElements(oldElements.toArray(new IMember[0]));
        return newElements[newElements.length - 1];
    }

    private void addElements(IMember element, LinkedList<IMember> chain) {
        chain.addFirst(element);
        IJavaElement parent = element.getParent();
        if (parent instanceof IMember) {
            this.addElements((IMember)parent, chain);
        }
    }

    private IMember[] convertElements(IMember[] oldElements) {
        IMember[] newElements = new IMember[oldElements.length];
        IMember first = oldElements[0];
        Assert.isTrue((boolean)(first instanceof IType));
        newElements[0] = first.equals(this.fOldType) ? this.fNewType : first;
        int i = 1;
        while (i < oldElements.length) {
            IMember newParent = newElements[i - 1];
            IMember currentElement = oldElements[i];
            switch (newParent.getElementType()) {
                case 7: {
                    switch (currentElement.getElementType()) {
                        case 7: {
                            String newName = this.resolveTypeName((IType)currentElement);
                            newElements[i] = ((IType)newParent).getType(newName);
                            break;
                        }
                        case 9: {
                            String newName = this.resolveElementName((IJavaElement)currentElement);
                            String[] newParameterTypes = this.resolveParameterTypes((IMethod)currentElement);
                            newElements[i] = ((IType)newParent).getMethod(newName, newParameterTypes);
                            break;
                        }
                        case 10: {
                            IInitializer initializer = (IInitializer)currentElement;
                            newElements[i] = ((IType)newParent).getInitializer(initializer.getOccurrenceCount());
                            break;
                        }
                        case 8: {
                            String newName = this.resolveElementName((IJavaElement)currentElement);
                            newElements[i] = ((IType)newParent).getField(newName);
                        }
                    }
                    break;
                }
                case 9: {
                    switch (currentElement.getElementType()) {
                        case 7: {
                            newElements[i] = this.resolveTypeInMember((IMember)((IMethod)newParent), (IType)currentElement);
                        }
                    }
                    break;
                }
                case 10: {
                    switch (currentElement.getElementType()) {
                        case 7: {
                            newElements[i] = this.resolveTypeInMember((IMember)((IInitializer)newParent), (IType)currentElement);
                        }
                    }
                    break;
                }
                case 8: {
                    switch (currentElement.getElementType()) {
                        case 7: {
                            newElements[i] = this.resolveTypeInMember((IMember)((IField)newParent), (IType)currentElement);
                        }
                    }
                }
            }
            ++i;
        }
        return newElements;
    }

    private String[] resolveParameterTypes(IMethod method) {
        String[] oldParameterTypes = method.getParameterTypes();
        String[] newparams = new String[oldParameterTypes.length];
        String[] possibleOldSigs = new String[]{Signature.createTypeSignature((String)this.fOldType.getElementName(), (boolean)false), Signature.createTypeSignature((String)this.fOldType.getElementName(), (boolean)true), Signature.createTypeSignature((String)this.fOldType.getFullyQualifiedName(), (boolean)false), Signature.createTypeSignature((String)this.fOldType.getFullyQualifiedName(), (boolean)true)};
        String[] possibleNewSigs = new String[]{Signature.createTypeSignature((String)this.fNewType.getElementName(), (boolean)false), Signature.createTypeSignature((String)this.fNewType.getElementName(), (boolean)true), Signature.createTypeSignature((String)this.fNewType.getFullyQualifiedName(), (boolean)false), Signature.createTypeSignature((String)this.fNewType.getFullyQualifiedName(), (boolean)true)};
        int i = 0;
        while (i < oldParameterTypes.length) {
            newparams[i] = oldParameterTypes[i];
            int j = 0;
            while (j < possibleOldSigs.length) {
                newparams[i] = RefactoringHandleTransplanter.replaceAll(newparams[i], possibleOldSigs[j], possibleNewSigs[j]);
                ++j;
            }
            ++i;
        }
        return newparams;
    }

    private String resolveElementName(IJavaElement element) {
        String newName = this.fRefactoredSimilarElements.get(element);
        if (newName != null) {
            return newName;
        }
        return element.getElementName();
    }

    private IMember resolveTypeInMember(IMember newParent, IType oldChild) {
        String newName = "";
        if (oldChild.getElementName().length() != 0) {
            newName = this.resolveTypeName(oldChild);
        }
        return newParent.getType(newName, oldChild.getOccurrenceCount());
    }

    private String resolveTypeName(IType type) {
        return type.equals(this.fOldType) ? this.fNewType.getElementName() : type.getElementName();
    }

    private static String replaceAll(String source, String replaceFrom, String replaceTo) {
        int matchIndex;
        StringBuilder buf = new StringBuilder(source.length());
        int currentIndex = 0;
        while ((matchIndex = source.indexOf(replaceFrom, currentIndex)) != -1) {
            buf.append(source.substring(currentIndex, matchIndex));
            buf.append(replaceTo);
            currentIndex = matchIndex + replaceFrom.length();
        }
        buf.append(source.substring(currentIndex));
        return buf.toString();
    }
}

